/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.DynamicAny;

import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.ee.internal.DynamicAny.DynAnyBasicImpl;
import com.sun.corba.ee.internal.DynamicAny.DynAnyImpl;
import com.sun.corba.ee.internal.DynamicAny.DynArrayImpl;
import com.sun.corba.ee.internal.DynamicAny.DynEnumImpl;
import com.sun.corba.ee.internal.DynamicAny.DynFixedImpl;
import com.sun.corba.ee.internal.DynamicAny.DynSequenceImpl;
import com.sun.corba.ee.internal.DynamicAny.DynStructImpl;
import com.sun.corba.ee.internal.DynamicAny.DynUnionImpl;
import com.sun.corba.ee.internal.DynamicAny.DynValueBoxImpl;
import com.sun.corba.ee.internal.DynamicAny.DynValueImpl;
import com.sun.corba.ee.internal.corba.AnyImpl;
import java.math.BigDecimal;
import java.util.logging.Level;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;

public class DynAnyUtil {
    static boolean isConsistentType(TypeCode typeCode) {
        int n = typeCode.kind().value();
        return n != 13 && n != 31 && n != 32;
    }

    static boolean isConstructedDynAny(DynAny dynAny) {
        int n = dynAny.type().kind().value();
        return n == 19 || n == 15 || n == 20 || n == 16 || n == 17 || n == 28 || n == 29 || n == 30;
    }

    static DynAny createMostDerivedDynAny(Any any, ORB oRB, boolean bl) throws InconsistentTypeCode {
        if (any == null || !DynAnyUtil.isConsistentType(any.type())) {
            throw new InconsistentTypeCode();
        }
        switch (any.type().kind().value()) {
            case 19: {
                return new DynSequenceImpl(oRB, any, bl);
            }
            case 15: {
                return new DynStructImpl(oRB, any, bl);
            }
            case 20: {
                return new DynArrayImpl(oRB, any, bl);
            }
            case 16: {
                return new DynUnionImpl(oRB, any, bl);
            }
            case 17: {
                return new DynEnumImpl(oRB, any, bl);
            }
            case 28: {
                return new DynFixedImpl(oRB, any, bl);
            }
            case 29: {
                return new DynValueImpl(oRB, any, bl);
            }
            case 30: {
                return new DynValueBoxImpl(oRB, any, bl);
            }
        }
        return new DynAnyBasicImpl(oRB, any, bl);
    }

    static DynAny createMostDerivedDynAny(TypeCode typeCode, ORB oRB) throws InconsistentTypeCode {
        if (typeCode == null || !DynAnyUtil.isConsistentType(typeCode)) {
            throw new InconsistentTypeCode();
        }
        switch (typeCode.kind().value()) {
            case 19: {
                return new DynSequenceImpl(oRB, typeCode);
            }
            case 15: {
                return new DynStructImpl(oRB, typeCode);
            }
            case 20: {
                return new DynArrayImpl(oRB, typeCode);
            }
            case 16: {
                return new DynUnionImpl(oRB, typeCode);
            }
            case 17: {
                return new DynEnumImpl(oRB, typeCode);
            }
            case 28: {
                return new DynFixedImpl(oRB, typeCode);
            }
            case 29: {
                return new DynValueImpl(oRB, typeCode);
            }
            case 30: {
                return new DynValueBoxImpl(oRB, typeCode);
            }
        }
        return new DynAnyBasicImpl(oRB, typeCode);
    }

    static Any extractAnyFromStream(TypeCode typeCode, InputStream inputStream, ORB oRB) {
        return AnyImpl.extractAnyFromStream(typeCode, inputStream, oRB);
    }

    static Any createDefaultAnyOfType(TypeCode typeCode, ORB oRB) {
        Any any = oRB.create_any();
        switch (typeCode.kind().value()) {
            case 8: {
                any.insert_boolean(false);
                break;
            }
            case 2: {
                any.insert_short((short)0);
                break;
            }
            case 4: {
                any.insert_ushort((short)0);
                break;
            }
            case 3: {
                any.insert_long(0);
                break;
            }
            case 5: {
                any.insert_ulong(0);
                break;
            }
            case 23: {
                any.insert_longlong(0L);
                break;
            }
            case 24: {
                any.insert_ulonglong(0L);
                break;
            }
            case 6: {
                any.insert_float(0.0f);
                break;
            }
            case 7: {
                any.insert_double(0.0);
                break;
            }
            case 10: {
                any.insert_octet((byte)0);
                break;
            }
            case 9: {
                any.insert_char('\u0000');
                break;
            }
            case 26: {
                any.insert_wchar('\u0000');
                break;
            }
            case 18: {
                any.type(typeCode);
                any.insert_string("");
                break;
            }
            case 27: {
                any.type(typeCode);
                any.insert_wstring("");
                break;
            }
            case 14: {
                any.insert_Object(null);
                break;
            }
            case 12: {
                any.insert_TypeCode(any.type());
                break;
            }
            case 11: {
                any.insert_any(oRB.create_any());
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 29: 
            case 30: {
                any.type(typeCode);
                break;
            }
            case 28: {
                any.insert_fixed(new BigDecimal("0.0"), typeCode);
                break;
            }
            case 1: 
            case 13: 
            case 21: 
            case 31: 
            case 32: {
                any.type(typeCode);
                break;
            }
            case 0: {
                break;
            }
            case 25: {
                throw new NO_IMPLEMENT();
            }
            default: {
                throw new BAD_PARAM();
            }
        }
        return any;
    }

    static Any copy(Any any, ORB oRB) {
        return new AnyImpl(oRB, any);
    }

    static DynAny convertToNative(DynAny dynAny, ORB oRB) {
        if (dynAny instanceof DynAnyImpl) {
            return dynAny;
        }
        try {
            return DynAnyUtil.createMostDerivedDynAny(dynAny.to_any(), oRB, true);
        }
        catch (InconsistentTypeCode inconsistentTypeCode) {
            LogWrap.logger.log(Level.FINE, "", inconsistentTypeCode);
            return null;
        }
    }

    static boolean isInitialized(Any any) {
        boolean bl = ((AnyImpl)any).isInitialized();
        switch (any.type().kind().value()) {
            case 18: {
                return bl && any.extract_string() != null;
            }
            case 27: {
                return bl && any.extract_wstring() != null;
            }
        }
        return bl;
    }

    static boolean set_current_component(DynAny dynAny, DynAny dynAny2) {
        if (dynAny2 != null) {
            try {
                dynAny.rewind();
                do {
                    if (dynAny.current_component() != dynAny2) continue;
                    return true;
                } while (dynAny.next());
            }
            catch (TypeMismatch typeMismatch) {
                // empty catch block
            }
        }
        return false;
    }
}

