/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.Activation;

import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.ee.ActivationIDL.ActivatorHelper;
import com.sun.corba.ee.ActivationIDL.RepositoryHelper;
import com.sun.corba.ee.ActivationIDL.ServerHeldDown;
import com.sun.corba.ee.ActivationIDL.ServerNotRegistered;
import com.sun.corba.ee.internal.Activation.CommandHandler;
import com.sun.corba.ee.internal.Activation.ServerTool;
import com.sun.corba.ee.internal.orbutil.CorbaResourceUtil;
import java.io.PrintStream;
import java.util.logging.Level;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.IDLEntity;

class UnRegisterServer
implements CommandHandler {
    static final int illegalServerId = -1;

    UnRegisterServer() {
    }

    public String getCommandName() {
        return "unregister";
    }

    public void printCommandHelp(PrintStream printStream, boolean bl) {
        if (!bl) {
            printStream.println(CorbaResourceUtil.getText("servertool.unregister"));
        } else {
            printStream.println(CorbaResourceUtil.getText("servertool.unregister1"));
        }
    }

    public boolean processCommand(String[] stringArray, ORB oRB, PrintStream printStream) {
        int n = -1;
        try {
            IDLEntity iDLEntity;
            if (stringArray.length == 2) {
                if (stringArray[0].equals("-serverid")) {
                    n = Integer.valueOf(stringArray[1]);
                } else if (stringArray[0].equals("-applicationName")) {
                    n = ServerTool.getServerIdForAlias(oRB, stringArray[1]);
                }
            }
            if (n == -1) {
                return true;
            }
            try {
                iDLEntity = ActivatorHelper.narrow(oRB.resolve_initial_references("ServerActivator"));
                iDLEntity.uninstall(n);
            }
            catch (ServerHeldDown serverHeldDown) {
                // empty catch block
            }
            iDLEntity = RepositoryHelper.narrow(oRB.resolve_initial_references("ServerRepository"));
            iDLEntity.unregisterServer(n);
            printStream.println(CorbaResourceUtil.getText("servertool.unregister2"));
        }
        catch (ServerNotRegistered serverNotRegistered) {
            LogWrap.logger.log(Level.FINE, CorbaResourceUtil.getText("servertool.nosuchserver"), serverNotRegistered);
            printStream.println(CorbaResourceUtil.getText("servertool.nosuchserver"));
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.WARNING, "", exception);
        }
        return false;
    }
}

