/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.Activation;

import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.ee.ActivationIDL._ServerImplBase;
import com.sun.corba.ee.internal.Activation.ServerMain;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.omg.CORBA.ORB;

class ServerCallback
extends _ServerImplBase {
    private ORB orb;
    private Method installMethod;
    private Method uninstallMethod;
    private Method shutdownMethod;
    private Object[] methodArgs;

    ServerCallback(ORB oRB, Method method, Method method2, Method method3) {
        this.orb = oRB;
        this.installMethod = method;
        this.uninstallMethod = method2;
        this.shutdownMethod = method3;
        oRB.connect(this);
        this.methodArgs = new Object[]{oRB};
    }

    private void invokeMethod(Method method) {
        if (method != null) {
            try {
                method.invoke(null, this.methodArgs);
            }
            catch (Exception exception) {
                LogWrap.logger.log(Level.WARNING, "iiop.method_invocation_failure", new Object[]{method.getName()});
                LogWrap.logger.log(Level.WARNING, "", exception);
                ServerMain.logError("could not invoke " + method.getName() + " method: " + exception.getMessage());
            }
        }
    }

    public void shutdown() {
        ServerMain.logInformation("Shutdown starting");
        this.invokeMethod(this.shutdownMethod);
        this.orb.shutdown(true);
        ServerMain.logTerminal("Shutdown completed", 0);
    }

    public void install() {
        ServerMain.logInformation("Install starting");
        this.invokeMethod(this.installMethod);
        ServerMain.logInformation("Install completed");
    }

    public void uninstall() {
        ServerMain.logInformation("uninstall starting");
        this.invokeMethod(this.uninstallMethod);
        ServerMain.logInformation("uninstall completed");
    }
}

