/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.util.cache;

import com.sun.appserv.util.cache.BaseCache;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

public class LruCache
extends BaseCache {
    public static final long NO_TIMEOUT = -1L;
    protected LruCacheItem head;
    protected LruCacheItem tail;
    protected int trimCount;
    protected int listSize;
    protected long timeout = -1L;
    protected int defaultMaxEntries = 8192;
    protected boolean isUnbounded = false;

    public LruCache() {
    }

    public LruCache(int n) {
        this.defaultMaxEntries = n;
    }

    public void init(int n, long l, float f, Properties properties) {
        if (n <= 0) {
            n = this.defaultMaxEntries;
            this.isUnbounded = true;
        }
        if (l > 0L) {
            this.timeout = l;
        }
        super.init(n, f, properties);
    }

    protected BaseCache.CacheItem createItem(int n, Object object, Object object2, int n2) {
        return new LruCacheItem(n, object, object2, n2);
    }

    protected BaseCache.CacheItem trimLru(long l) {
        LruCacheItem lruCacheItem = this.tail;
        if (this.tail != this.head) {
            this.tail = lruCacheItem.lPrev;
            if (this.tail == null) {
                this.head = null;
                this.tail = null;
            } else {
                this.tail.lNext = null;
                lruCacheItem.lPrev = null;
            }
        } else {
            this.head = null;
            this.tail = null;
        }
        if (lruCacheItem != null) {
            lruCacheItem.isTrimmed = true;
            lruCacheItem.lPrev = null;
            ++this.trimCount;
            --this.listSize;
        }
        return lruCacheItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseCache.CacheItem itemAdded(BaseCache.CacheItem cacheItem) {
        boolean bl = false;
        BaseCache.CacheItem cacheItem2 = null;
        LruCacheItem lruCacheItem = (LruCacheItem)cacheItem;
        lruCacheItem.lastAccessed = System.currentTimeMillis();
        LruCache lruCache = this;
        synchronized (lruCache) {
            if (this.head != null) {
                this.head.lPrev = lruCacheItem;
                lruCacheItem.lNext = this.head;
                lruCacheItem.lPrev = null;
                this.head = lruCacheItem;
            } else {
                this.head = this.tail = lruCacheItem;
                lruCacheItem.lNext = null;
                lruCacheItem.lPrev = null;
            }
            ++this.listSize;
            if (this.isThresholdReached()) {
                if (!this.isUnbounded) {
                    cacheItem2 = this.trimLru(lruCacheItem.lastAccessed);
                } else {
                    bl = true;
                }
            }
        }
        if (bl) {
            super.handleOverflow();
        }
        return cacheItem2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemAccessed(BaseCache.CacheItem cacheItem) {
        LruCacheItem lruCacheItem = (LruCacheItem)cacheItem;
        LruCache lruCache = this;
        synchronized (lruCache) {
            if (lruCacheItem.isTrimmed) {
                return;
            }
            lruCacheItem.lastAccessed = System.currentTimeMillis();
            LruCacheItem lruCacheItem2 = lruCacheItem.lPrev;
            LruCacheItem lruCacheItem3 = lruCacheItem.lNext;
            if (lruCacheItem2 != null) {
                lruCacheItem.lPrev = null;
                lruCacheItem.lNext = this.head;
                this.head.lPrev = lruCacheItem;
                this.head = lruCacheItem;
                lruCacheItem2.lNext = lruCacheItem3;
                if (lruCacheItem3 != null) {
                    lruCacheItem3.lPrev = lruCacheItem2;
                } else {
                    this.tail = lruCacheItem2;
                }
            }
        }
    }

    protected void itemRefreshed(BaseCache.CacheItem cacheItem, int n) {
        this.itemAccessed(cacheItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemRemoved(BaseCache.CacheItem cacheItem) {
        LruCacheItem lruCacheItem = (LruCacheItem)cacheItem;
        LruCache lruCache = this;
        synchronized (lruCache) {
            LruCacheItem lruCacheItem2 = lruCacheItem.lPrev;
            LruCacheItem lruCacheItem3 = lruCacheItem.lNext;
            if (lruCacheItem.isTrimmed) {
                return;
            }
            if (lruCacheItem2 != null) {
                lruCacheItem2.lNext = lruCacheItem3;
            } else {
                this.head = lruCacheItem3;
            }
            if (lruCacheItem3 != null) {
                lruCacheItem3.lPrev = lruCacheItem2;
            } else {
                this.tail = lruCacheItem2;
            }
            lruCacheItem.lNext = null;
            lruCacheItem.lPrev = null;
            --this.listSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimExpiredEntries(int n) {
        long l = System.currentTimeMillis();
        ArrayList<LruCacheItem> arrayList = new ArrayList<LruCacheItem>();
        LruCache lruCache = this;
        synchronized (lruCache) {
            int n2;
            LruCacheItem lruCacheItem = this.tail;
            for (n2 = 0; lruCacheItem != null && n2 < n && this.timeout != -1L && lruCacheItem.lastAccessed + this.timeout <= l; ++n2) {
                lruCacheItem.isTrimmed = true;
                arrayList.add(lruCacheItem);
                lruCacheItem = lruCacheItem.lPrev;
            }
            if (lruCacheItem != this.tail) {
                if (lruCacheItem != null) {
                    lruCacheItem.lNext = null;
                } else {
                    this.head = null;
                }
                this.tail = lruCacheItem;
            }
            this.listSize -= n2;
            this.trimCount += n2;
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            this.trimItem((LruCacheItem)arrayList.get(i));
        }
    }

    public Object getStatByName(String string) {
        Object object = super.getStatByName(string);
        if (object == null && string != null) {
            if (string.equals("cache.LruCache.stat_lruListLength")) {
                object = new Integer(this.listSize);
            } else if (string.equals("cache.LruCache.stat_trimCount")) {
                object = new Integer(this.trimCount);
            }
        }
        return object;
    }

    public Map getStats() {
        Map map = super.getStats();
        map.put("cache.LruCache.stat_lruListLength", new Integer(this.listSize));
        map.put("cache.LruCache.stat_trimCount", new Integer(this.trimCount));
        return map;
    }

    protected static class LruCacheItem
    extends BaseCache.CacheItem {
        protected LruCacheItem lNext;
        protected LruCacheItem lPrev;
        protected boolean isTrimmed;
        protected long lastAccessed;

        protected LruCacheItem(int n, Object object, Object object2, int n2) {
            super(n, object, object2, n2);
        }
    }
}

