/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.util;

import java.net.InetAddress;
import java.rmi.server.UID;
import java.security.SecureRandom;

public class UuidUtil {
    static final String _inetAddr = UuidUtil.initInetAddr();
    private static SecureRandom _seeder = new SecureRandom();

    public static String generateUuidMM() {
        return new StringBuffer(new UID().toString()).reverse().append(':').append(_inetAddr).toString();
    }

    public static String generateUuid() {
        return UuidUtil.generateUuid(new Object());
    }

    public static String generateUuid(Object object) {
        long l = System.currentTimeMillis();
        int n = (int)l & 0xFFFFFFFF;
        String string = UuidUtil.formatHexString(n);
        String string2 = UuidUtil.getNextRandomString();
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(string);
        stringBuffer.append(UuidUtil.getIdentityHashCode(object));
        stringBuffer.append(UuidUtil.addRandomTo(_inetAddr));
        stringBuffer.append(UuidUtil.getNextRandomString());
        return stringBuffer.toString();
    }

    private static String initInetAddr() {
        try {
            byte[] byArray = InetAddress.getLocalHost().getAddress();
            StringBuffer stringBuffer = new StringBuffer();
            String string = null;
            for (int i = 0; i < byArray.length; ++i) {
                string = Integer.toHexString(byArray[i]);
                if (byArray[i] < 0) {
                    stringBuffer.append(string.substring(string.length() - 2));
                    continue;
                }
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "a48eb993";
        }
    }

    private static String addRandomTo(String string) {
        long l = UuidUtil.convertToLong(string);
        int n = UuidUtil.getNextInt();
        long l2 = l + (long)n;
        String string2 = Long.toHexString(l2);
        return string2;
    }

    private static String getIdentityHashCode(Object object) {
        Object var1_1 = null;
        try {
            int n = System.identityHashCode(object);
            return UuidUtil.formatHexString(n);
        }
        catch (Exception exception) {
            return "8AF5182";
        }
    }

    private static String formatHexString(int n) {
        String string = null;
        String string2 = Integer.toHexString(n);
        string = string2.length() < 8 ? string2 : string2.substring(0, 7);
        return string;
    }

    private static synchronized int getNextInt() {
        return _seeder.nextInt();
    }

    private static String getNextRandomString() {
        int n = UuidUtil.getNextInt();
        return UuidUtil.formatHexString(n);
    }

    private static long convertToLong(String string) {
        long l = 0L;
        try {
            l = Long.valueOf(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l;
    }

    public static void main(String[] stringArray) {
        System.out.println(UuidUtil.generateUuidMM());
        System.out.println(UuidUtil.generateUuid());
        System.out.println(UuidUtil.generateUuid(new Object()));
    }
}

