/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.naming;

import com.sun.appserv.naming.LoadBalancingPolicy;
import com.sun.jndi.cosnaming.IiopUrl;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Level;
import org.omg.CORBA.ORB;

public class RoundRobinPolicy
extends LoadBalancingPolicy {
    private static final String NO_OF_ORB_CONNECTION_PROPERTY = "com.sun.appserv.iiop.orbconnections";
    int numberOfORBs = 1;
    private Hashtable precreatedORBStore = new Hashtable();
    private Hashtable dynamicORBStore = new Hashtable();
    private Object[] precreatedORBEntries = null;
    private HashMap names = new HashMap();
    private Object storesLock = new Object();
    static Random rand = new Random((int)System.currentTimeMillis());
    private boolean random = false;

    private void init() {
        String string = System.getProperty(NO_OF_ORB_CONNECTION_PROPERTY);
        if (string != null) {
            this.numberOfORBs = Integer.parseInt(string);
        }
    }

    public RoundRobinPolicy(String[] stringArray, boolean bl) {
        this(stringArray);
        if (bl) {
            this.random = true;
        } else {
            Properties properties = new Properties();
            int n = this.getRandom(this.precreatedORBStore.size());
            Enumeration enumeration = this.precreatedORBStore.keys();
            for (int i = 0; i < n; ++i) {
                String string = (String)enumeration.nextElement();
                LoadBalancingPolicy.ORBDataElement oRBDataElement = (LoadBalancingPolicy.ORBDataElement)this.precreatedORBStore.get(string);
                oRBDataElement.setAccessCount(oRBDataElement.getAccessCount() + 1);
            }
        }
    }

    public RoundRobinPolicy(String[] stringArray) {
        this.init();
        String[] stringArray2 = null;
        if (stringArray != null && stringArray.length > 0) {
            stringArray2 = this.getAddressPortList(stringArray);
        } else {
            String string = System.getProperty("java.naming.provider.url");
            if (string != null) {
                try {
                    IiopUrl iiopUrl = new IiopUrl(string);
                    stringArray2 = this.getAddressPortList(iiopUrl);
                }
                catch (MalformedURLException malformedURLException) {
                    _logger.log(Level.WARNING, "Bad provider URL String: " + string);
                }
            } else {
                String string2;
                String string3 = System.getProperty("org.omg.CORBA.ORBInitialHost");
                if (string3 != null && (string2 = System.getProperty("org.omg.CORBA.ORBInitialPort")) != null) {
                    stringArray2 = this.getAddressPortList(string3, string2);
                }
            }
        }
        if (stringArray2 != null) {
            this.growORBStore(this.precreatedORBStore, stringArray2);
            return;
        }
    }

    public HashMap getNames() {
        return this.names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORB getORB(Hashtable hashtable) {
        Object object;
        ORB oRB = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String string = (String)hashtable.get("java.naming.provider.url");
        if (string != null) {
            try {
                object = new IiopUrl(string);
                stringArray = this.getAddressPortList((IiopUrl)object);
            }
            catch (MalformedURLException malformedURLException) {
                _logger.log(Level.WARNING, "Bad provider URL String: " + string);
            }
        } else {
            stringArray2 = (String[])hashtable.get("com.sun.appserv.ee.iiop.endpointslist");
            if (stringArray2 != null) {
                stringArray = this.getAddressPortList(stringArray2);
            } else {
                String string2;
                String string3 = (String)hashtable.get("org.omg.CORBA.ORBInitialHost");
                if (string3 != null && (string2 = (String)hashtable.get("org.omg.CORBA.ORBInitialPort")) != null) {
                    stringArray = this.getAddressPortList(string3, string2);
                }
            }
        }
        object = null;
        if (stringArray == null) {
            object = this.getLeastAccessedElement(this.precreatedORBStore, null);
        } else {
            Object object2 = this.storesLock;
            synchronized (object2) {
                String[] stringArray3;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (this.precreatedORBStore.containsKey(this.makeStorageKey(stringArray[i])) || this.dynamicORBStore.containsKey(this.makeStorageKey(stringArray[i]))) continue;
                    stringArray3 = new String[]{stringArray[i]};
                    this.growORBStore(this.dynamicORBStore, stringArray3);
                    LoadBalancingPolicy.ORBDataElement oRBDataElement = (LoadBalancingPolicy.ORBDataElement)this.dynamicORBStore.get(this.makeStorageKey(stringArray[i]));
                    if (oRBDataElement == null) continue;
                    return oRBDataElement.getORB();
                }
                LoadBalancingPolicy.ORBDataElement oRBDataElement = this.getLeastAccessedElement(this.precreatedORBStore, stringArray);
                stringArray3 = this.getLeastAccessedElement(this.dynamicORBStore, stringArray);
                object = oRBDataElement != null && stringArray3 != null ? (oRBDataElement.getAccessCount() <= stringArray3.getAccessCount() ? oRBDataElement : stringArray3) : (stringArray3 == null ? oRBDataElement : stringArray3);
            }
        }
        if (object != null) {
            int n = ((LoadBalancingPolicy.ORBDataElement)object).getNextORBIndex();
            oRB = ((LoadBalancingPolicy.ORBDataElement)object).getORB();
        }
        return oRB;
    }

    private String makeStorageKey(String string) {
        return string.trim().toLowerCase();
    }

    private void growORBStore(Hashtable hashtable, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Object object;
                String[] stringArray2 = stringArray[i].split(":");
                String string = stringArray2[0].trim();
                String string2 = stringArray2[1].trim();
                ORB[] oRBArray = new ORB[this.numberOfORBs];
                for (int j = 0; j < this.numberOfORBs; ++j) {
                    object = this.createORB(string, string2, string + "_" + string2 + "_" + j);
                    this.names.put(object, this.makeStorageKey(stringArray[i]));
                    oRBArray[j] = object;
                }
                LoadBalancingPolicy.ORBDataElement oRBDataElement = new LoadBalancingPolicy.ORBDataElement(oRBArray, "ORB with nameservice at " + stringArray[i]);
                if (!this.random && (object = this.getLeastAccessedElement(hashtable, null)) != null) {
                    oRBDataElement.setAccessCount(((LoadBalancingPolicy.ORBDataElement)object).getAccessCount());
                }
                hashtable.put(this.makeStorageKey(stringArray[i]), oRBDataElement);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (hashtable == this.precreatedORBStore) {
            this.precreatedORBEntries = hashtable.entrySet().toArray();
        }
    }

    private int getRandom(int n) {
        return Math.abs(rand.nextInt()) % n;
    }

    private LoadBalancingPolicy.ORBDataElement getLeastAccessedElement(Hashtable hashtable, String[] stringArray) {
        if (hashtable == null) {
            return null;
        }
        LoadBalancingPolicy.ORBDataElement oRBDataElement = null;
        if (this.random) {
            if (stringArray == null) {
                Object[] objectArray = hashtable == this.precreatedORBStore ? this.precreatedORBEntries : hashtable.entrySet().toArray();
                return (LoadBalancingPolicy.ORBDataElement)((Map.Entry)objectArray[this.getRandom(objectArray.length)]).getValue();
            }
            return (LoadBalancingPolicy.ORBDataElement)hashtable.get(this.makeStorageKey(stringArray[this.getRandom(stringArray.length)]));
        }
        if (stringArray == null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                LoadBalancingPolicy.ORBDataElement oRBDataElement2 = (LoadBalancingPolicy.ORBDataElement)hashtable.get(string);
                if (oRBDataElement != null && oRBDataElement2.getAccessCount() >= oRBDataElement.getAccessCount()) continue;
                oRBDataElement = oRBDataElement2;
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                LoadBalancingPolicy.ORBDataElement oRBDataElement3 = (LoadBalancingPolicy.ORBDataElement)hashtable.get(this.makeStorageKey(stringArray[i]));
                if (oRBDataElement3 == null || oRBDataElement != null && oRBDataElement3.getAccessCount() >= oRBDataElement.getAccessCount()) continue;
                oRBDataElement = oRBDataElement3;
            }
        }
        return oRBDataElement;
    }

    public boolean setDirty(String string) {
        if (string == null) {
            return false;
        }
        LoadBalancingPolicy.ORBDataElement oRBDataElement = (LoadBalancingPolicy.ORBDataElement)this.precreatedORBStore.remove(this.makeStorageKey(string));
        return (LoadBalancingPolicy.ORBDataElement)this.dynamicORBStore.remove(this.makeStorageKey(string)) != null || oRBDataElement != null;
    }

    private String[] getAddressPortList(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                IiopUrl iiopUrl = new IiopUrl("iiop://" + stringArray[i]);
                String[] stringArray2 = this.getAddressPortList(iiopUrl);
                for (int j = 0; j < stringArray2.length; ++j) {
                    vector.addElement(stringArray2[j]);
                }
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                _logger.log(Level.WARNING, "Bad host:port entry: " + stringArray[i]);
            }
        }
        String[] stringArray3 = new String[vector.size()];
        for (int i = 0; i < stringArray3.length; ++i) {
            stringArray3[i] = (String)vector.elementAt(i);
        }
        return stringArray3;
    }

    private String[] getAddressPortList(IiopUrl iiopUrl) {
        IiopUrl.Address address = (IiopUrl.Address)iiopUrl.getAddresses().elementAt(0);
        String string = address.host;
        int n = address.port;
        String string2 = Integer.toString(n);
        return this.getAddressPortList(string, string2);
    }

    private String[] getAddressPortList(String string, String string2) {
        try {
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
            String[] stringArray = new String[inetAddressArray.length];
            for (int i = 0; i < inetAddressArray.length; ++i) {
                stringArray[i] = inetAddressArray[i].getHostAddress() + ":" + string2;
            }
            return stringArray;
        }
        catch (UnknownHostException unknownHostException) {
            _logger.log(Level.WARNING, "Uknown host: " + string);
            return null;
        }
    }
}

