/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web.util;

import com.iplanet.ias.tools.common.dd.webapp.LocaleCharsetMap;
import com.sun.logging.LogDomains;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.util.RequestUtil;

public final class I18NParseUtil {
    public static Logger _logger = null;
    private static boolean _debugLog;

    public static String parseParametersUsingLCInfo(Map map, byte[] byArray, byte[] byArray2, LocaleCharsetMap[] localeCharsetMapArray, String string, HttpServletRequest httpServletRequest) throws UnsupportedEncodingException {
        LinkedList linkedList = new LinkedList();
        String string2 = I18NParseUtil.processBufferWithHiddenField(map, byArray, string, linkedList, null, null);
        if (string2 != null) {
            if (_debugLog) {
                _logger.fine("Got charset from queryString, hidden field name = " + string + ", hidden field value = " + string2);
            }
            RequestUtil.parseParameters(map, byArray2, string2);
            return string2;
        }
        LinkedList linkedList2 = new LinkedList();
        string2 = I18NParseUtil.processBufferWithHiddenField(map, byArray2, string, linkedList2, byArray, linkedList);
        if (string2 != null) {
            if (_debugLog) {
                _logger.fine("Got charset from POST data, hidden field name = " + string + ", hidden field value = " + string2);
            }
            return string2;
        }
        String string3 = null;
        if (localeCharsetMapArray != null) {
            string2 = string3 = I18NParseUtil.getLocaleCharsetEncoding(httpServletRequest, localeCharsetMapArray);
        }
        if (string3 == null) {
            string3 = "ISO-8859-1";
            if (_debugLog) {
                _logger.fine("Using default encoding to parse params: " + string3);
            }
        }
        I18NParseUtil.processLinkedList(map, byArray, linkedList, string3);
        I18NParseUtil.processLinkedList(map, byArray2, linkedList2, string3);
        return string2;
    }

    public static String processBufferWithHiddenField(Map map, byte[] byArray, String string, LinkedList linkedList, byte[] byArray2, LinkedList linkedList2) throws UnsupportedEncodingException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        String string4 = null;
        if (byArray == null) {
            return null;
        }
        block6: while (n2 < byArray.length) {
            byte by = byArray[n2++];
            switch ((char)by) {
                case '&': {
                    if (string2 != null) {
                        if (bl) {
                            string3 = new String(byArray, n, n3 - n, string4);
                            I18NParseUtil.putMapEntry(map, string2, string3);
                        } else if (string2.equals(string)) {
                            string4 = new String(byArray, n, n3 - n, "ISO-8859-1");
                            if (linkedList2 != null) {
                                I18NParseUtil.processLinkedList(map, byArray2, linkedList2, string4);
                            }
                            I18NParseUtil.processLinkedList(map, byArray, linkedList, string4);
                            I18NParseUtil.putMapEntry(map, string2, string4);
                            bl = true;
                        } else {
                            Object[] objectArray = new Object[]{string2, new Integer(n), new Integer(n3)};
                            linkedList.add(objectArray);
                        }
                        string2 = null;
                    }
                    n = n2;
                    n3 = n2;
                    continue block6;
                }
                case '=': {
                    if (string2 == null) {
                        string2 = new String(byArray, n, n3 - n, "ISO-8859-1");
                        n3 = n2;
                        n = n2;
                        continue block6;
                    }
                    byArray[n3++] = by;
                    continue block6;
                }
                case '+': {
                    byArray[n3++] = 32;
                    continue block6;
                }
                case '%': {
                    byArray[n3++] = (byte)((I18NParseUtil.convertHexDigit(byArray[n2++]) << 4) + I18NParseUtil.convertHexDigit(byArray[n2++]));
                    continue block6;
                }
            }
            byArray[n3++] = by;
        }
        if (string2 != null) {
            if (bl) {
                string3 = new String(byArray, n, n3 - n, string4);
                I18NParseUtil.putMapEntry(map, string2, string3);
            } else if (string2.equals(string)) {
                string4 = new String(byArray, n, n3 - n, "ISO-8859-1");
                if (linkedList2 != null) {
                    I18NParseUtil.processLinkedList(map, byArray2, linkedList2, string4);
                }
                I18NParseUtil.processLinkedList(map, byArray, linkedList, string4);
                I18NParseUtil.putMapEntry(map, string2, string4);
                bl = true;
            } else {
                Object[] objectArray = new Object[]{string2, new Integer(n), new Integer(n3)};
                linkedList.add(objectArray);
            }
        }
        return string4;
    }

    public static void processLinkedList(Map map, byte[] byArray, LinkedList linkedList, String string) throws UnsupportedEncodingException {
        if (byArray == null || linkedList == null) {
            return;
        }
        ListIterator listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            Object[] objectArray = (Object[])listIterator.next();
            String string2 = (String)objectArray[0];
            int n = (Integer)objectArray[1];
            int n2 = (Integer)objectArray[2];
            String string3 = new String(byArray, n, n2 - n, string);
            I18NParseUtil.putMapEntry(map, string2, string3);
        }
        linkedList.clear();
    }

    public static String getLocaleCharsetEncoding(HttpServletRequest httpServletRequest, LocaleCharsetMap[] localeCharsetMapArray) {
        if (localeCharsetMapArray == null) {
            return null;
        }
        String string = httpServletRequest.getLocale().toString();
        if (string == null) {
            return null;
        }
        String string2 = httpServletRequest.getHeader("user-agent");
        for (int i = 0; i < localeCharsetMapArray.length; ++i) {
            String string3;
            LocaleCharsetMap localeCharsetMap = localeCharsetMapArray[i];
            String string4 = localeCharsetMap.getAttributeValue("Locale");
            if (!string4.equals(string) || (string3 = localeCharsetMap.getAttributeValue("Agent")) != null && string3.length() != 0 && string2 != null && !string3.equals(string2)) continue;
            String string5 = localeCharsetMap.getAttributeValue("Charset");
            if (_debugLog) {
                _logger.fine("Got charset in locale-charset-map, locale=" + string + ", agent=" + string3 + ", charset=" + string5);
            }
            return string5;
        }
        return null;
    }

    private static void putMapEntry(Map map, String string, String string2) {
        String[] stringArray = null;
        String[] stringArray2 = (String[])map.get(string);
        if (stringArray2 == null) {
            stringArray = new String[]{string2};
        } else {
            stringArray = new String[stringArray2.length + 1];
            System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
            stringArray[stringArray2.length] = string2;
        }
        map.put(string, stringArray);
    }

    private static byte convertHexDigit(byte by) {
        if (by >= 48 && by <= 57) {
            return (byte)(by - 48);
        }
        if (by >= 97 && by <= 102) {
            return (byte)(by - 97 + 10);
        }
        if (by >= 65 && by <= 70) {
            return (byte)(by - 65 + 10);
        }
        return 0;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
        _debugLog = _logger.isLoggable(Level.FINE);
    }
}

