/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web.connector.nsapi;

import com.iplanet.ias.web.connector.nsapi.NSAPIConnector;
import com.iplanet.ias.web.connector.nsapi.NSAPIRequest;
import com.iplanet.ias.web.connector.nsapi.NSAPIResponse;
import com.iplanet.ias.web.connector.nsapi.NSAPIResponseStream;
import com.sun.logging.LogDomains;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardWrapper;

public final class NSAPIProcessor {
    private NSAPIConnector _connector = new NSAPIConnector();
    private NSAPIRequest _request = (NSAPIRequest)this._connector.createRequest();
    private NSAPIResponse _response = (NSAPIResponse)this._connector.createResponse();
    private boolean _invokeFromWrapper = false;
    private static Logger _logger = null;
    private static boolean _debugLog;

    public NSAPIProcessor() {
        String string = System.getProperty("com.iplanet.ias.web.connector.nsapi.useWrapper");
        boolean bl = this._invokeFromWrapper = string != null && string.equalsIgnoreCase("true");
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
            _debugLog = _logger.isLoggable(Level.FINE);
        }
    }

    public int process(StandardHost standardHost, String[] stringArray, byte[][] byArray, int[] nArray, StandardContext standardContext, String string, StandardWrapper standardWrapper, String string2, String string3) {
        int n = -1;
        this._request.setContext(standardContext);
        this._request.setContextPath(string);
        this._connector.setContainer(standardHost);
        this._request.initialize(stringArray, byArray, nArray);
        this._request.setResponse(this._response);
        int n2 = this._request.getNativeStreamSize();
        this._connector.setInitialSize(n2);
        this._response.setBufferSize(n2);
        this._response.setRequest(this._request);
        NSAPIResponseStream nSAPIResponseStream = new NSAPIResponseStream(this._connector);
        this._response.setStream((OutputStream)((Object)nSAPIResponseStream));
        if (_debugLog) {
            _logger.fine("context = " + standardContext);
            _logger.fine("contextPath = " + string);
            _logger.fine("wrapper = " + standardWrapper);
            _logger.fine("servletPath = " + string2);
            _logger.fine("pathInfo = " + string3);
        }
        if (standardWrapper != null) {
            this._request.setWrapper(standardWrapper);
            this._request.setServletPath(string2);
            this._request.setPathInfo(string3);
        }
        try {
            if (this._invokeFromWrapper) {
                if (standardWrapper != null) {
                    if (_debugLog) {
                        _logger.fine("===> Invoking using Wrapper .. ");
                    }
                    standardWrapper.getPipeline().invoke(this._request, this._response);
                } else {
                    if (_debugLog) {
                        _logger.fine("===> Invoking using Context .. ");
                    }
                    standardContext.getPipeline().invoke(this._request, this._response);
                }
            } else {
                standardHost.getPipeline().invoke(this._request, this._response);
            }
            nSAPIResponseStream.setNativeStreamFlushMode(false);
            this._response.finishResponse();
            this._request.finishRequest();
            n = 0;
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "nsapiProcessor.serviceError", exception);
        }
        this._request.recycle();
        this._response.recycle();
        this._connector.recycle();
        return n;
    }

    public NSAPIConnector getConnector() {
        return this._connector;
    }
}

