/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web;

import com.iplanet.ias.admin.event.AdminEventListenerRegistry;
import com.iplanet.ias.admin.event.ApplicationDeployEvent;
import com.iplanet.ias.admin.event.ApplicationDeployEventListener;
import com.iplanet.ias.admin.event.ModuleDeployEvent;
import com.iplanet.ias.admin.event.ModuleDeployEventListener;
import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.Applications;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.HttpService;
import com.iplanet.ias.config.serverbeans.J2eeApplication;
import com.iplanet.ias.config.serverbeans.LogService;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.VirtualServerClass;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.server.ApplicationRegistry;
import com.iplanet.ias.server.ServerContext;
import com.iplanet.ias.server.StandaloneWebModulesManager;
import com.iplanet.ias.tools.common.dd.webapp.CookieProperties;
import com.iplanet.ias.tools.common.dd.webapp.ManagerProperties;
import com.iplanet.ias.tools.common.dd.webapp.SessionConfig;
import com.iplanet.ias.tools.common.dd.webapp.SessionManager;
import com.iplanet.ias.tools.common.dd.webapp.SessionProperties;
import com.iplanet.ias.tools.common.dd.webapp.StoreProperties;
import com.iplanet.ias.tools.common.dd.webapp.SunWebApp;
import com.iplanet.ias.tools.common.dd.webapp.WebProperty;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.web.ConnectionShutdownUtil;
import com.iplanet.ias.web.DebugMonitor;
import com.iplanet.ias.web.DeployHistoryEntry;
import com.iplanet.ias.web.EmbeddedWebContainer;
import com.iplanet.ias.web.PersistenceStrategyBuilder;
import com.iplanet.ias.web.PersistenceStrategyBuilderFactory;
import com.iplanet.ias.web.SSOFactory;
import com.iplanet.ias.web.ServerConfigLookup;
import com.iplanet.ias.web.SessionPurgeUtil;
import com.iplanet.ias.web.VirtualServer;
import com.iplanet.ias.web.WebContainerTimer;
import com.iplanet.ias.web.WebDebugMonitor;
import com.iplanet.ias.web.WebModule;
import com.iplanet.ias.web.WebModuleConfig;
import com.iplanet.ias.web.connector.nsapi.NSAPIConnector;
import com.iplanet.ias.web.connector.nsapi.NSAPIProcessor;
import com.iplanet.ias.web.logger.IASLogger;
import com.iplanet.ias.web.session.PersistenceType;
import com.iplanet.ias.web.session.SessionCookieConfig;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.logging.LogDomains;
import com.sun.web.security.RealmAdapter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.connector.RequestBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.RequestUtil;

public final class WebContainer
implements Lifecycle,
ApplicationDeployEventListener,
ModuleDeployEventListener {
    public static final String SSO_ENABLED = "sso-enabled";
    public static final String SSO_MAX_IDLE = "sso-max-inactive-seconds";
    public static final String SSO_REAP_INTERVAL = "sso-reap-interval-seconds";
    public static final String DISPATCHER_MAX_DEPTH = "dispatcher-max-depth";
    public static final String NULL_STRING = "null";
    private static Hashtable deployHistory = new Hashtable();
    private EmbeddedWebContainer _embedded;
    private Engine _engine;
    private ServerContext _serverContext;
    private Server _serverBean;
    private String _id;
    private static Logger _logger = null;
    private static ResourceBundle _rb = null;
    private Level _logLevel;
    private int _debug;
    private String _modulesWorkRoot;
    private String _modulesRoot;
    private String _appsWorkRoot;
    private boolean _reloadingEnabled;
    private int _pollInterval;
    private StandaloneWebModulesManager _reloadManager;
    private LifecycleSupport _lifecycle;
    private boolean _started;
    private static Hashtable _instances = new Hashtable();
    private static boolean debugMonitoring = false;
    private static long debugMonitoringPeriodMS = 30000L;
    private static WebContainerTimer _timer = new WebContainerTimer();

    private WebContainer(String string, ServerContext serverContext) {
        block17: {
            this._embedded = null;
            this._engine = null;
            this._serverContext = null;
            this._serverBean = null;
            this._id = null;
            this._logLevel = null;
            this._debug = 0;
            this._modulesWorkRoot = null;
            this._modulesRoot = null;
            this._appsWorkRoot = null;
            this._reloadingEnabled = false;
            this._pollInterval = 2;
            this._reloadManager = null;
            this._lifecycle = new LifecycleSupport(this);
            this._started = false;
            this._id = string;
            this._serverContext = serverContext;
            String string2 = this._serverContext.getInstallRoot();
            String string3 = this._serverContext.getInstanceName();
            InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string2, string3);
            this._modulesWorkRoot = instanceEnvironment.getWebModuleCompileJspPath();
            this._appsWorkRoot = instanceEnvironment.getApplicationCompileJspPath();
            this._modulesRoot = instanceEnvironment.getModuleRepositoryPath();
            if (_logger == null) {
                _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
                _rb = _logger.getResourceBundle();
            }
            try {
                ElementProperty elementProperty;
                this._serverBean = this._serverContext.getConfigBean();
                this.getDynamicReloadingSettings(this._serverBean.getApplications());
                Level level = Level.SEVERE;
                this.setLogLevel(level);
                LogService logService = this._serverBean.getLogService();
                if (logService != null) {
                    try {
                        level = Level.parse(logService.getLevel());
                        this.setLogLevel(level);
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                try {
                    level = Level.parse(this._serverBean.getWebContainer().getLogLevel());
                    this.setLogLevel(level);
                }
                catch (NullPointerException nullPointerException) {
                    if (this._debug > 0) {
                        _logger.finest("Defaulting <web-container> log-level");
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (this._debug > 0) {
                    _logger.fine("Web container log level: " + this._logLevel);
                }
                if ((elementProperty = this._serverBean.getWebContainer().getElementPropertyByName(DISPATCHER_MAX_DEPTH)) == null || elementProperty.getValue() == null) break block17;
                int n = -1;
                try {
                    n = Integer.parseInt(elementProperty.getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n > 0) {
                    RequestBase.setMaxDispatchDepth(n);
                    if (this._debug > 0) {
                        _logger.fine("Maximum depth for nested request dispatches set to " + elementProperty.getValue());
                    }
                }
            }
            catch (ConfigException configException) {
                _logger.log(Level.SEVERE, "webcontainer.configError", configException);
            }
        }
        this._embedded = new EmbeddedWebContainer();
        this._embedded.setUseNaming(false);
        if (this._debug > 1) {
            this._embedded.setDebug(this._debug);
        }
        this._embedded.setLogger(new IASLogger(_logger));
        this._engine = this._embedded.createEngine();
        this._embedded.addEngine(this._engine);
    }

    public String getID() {
        return this._id;
    }

    public void registerAdminEvents() {
        _logger.finest("In WebContainer >> registerAdminEvents");
        AdminEventListenerRegistry.addApplicationDeployEventListener(this);
        AdminEventListenerRegistry.addModuleDeployEventListener(this);
    }

    public void unregisterAdminEvents() {
        _logger.finest("In WebContainer >> unregisterAdminEvents");
        AdminEventListenerRegistry.removeEventListener(this);
    }

    public void applicationDeployed(ApplicationDeployEvent applicationDeployEvent) {
        String string = applicationDeployEvent.getApplicationName();
        _logger.finest("applicationDeployed:" + string);
        String string2 = "App_" + string;
        boolean bl = this.checkDeployHistoryEntry(string2, "deployed");
        this.setDeployHistoryEntry(string2, "deployed", System.currentTimeMillis());
        if (bl) {
            _logger.finest("Returning from MIDDLE of applicationDeployed");
            return;
        }
        SessionPurgeUtil sessionPurgeUtil = new SessionPurgeUtil(_instances);
        _logger.finest("about to call SessionPurgeUtil for" + string);
        string = "/" + string;
        System.gc();
        _logger.finest("Returning from END of applicationDeployed");
    }

    public void applicationUndeployed(ApplicationDeployEvent applicationDeployEvent) {
        String string = applicationDeployEvent.getApplicationName();
        _logger.finest("applicationUndeployed:" + string);
        String string2 = "App_" + string;
        boolean bl = this.checkDeployHistoryEntry(string2, "undeployed");
        this.setDeployHistoryEntry(string2, "undeployed", System.currentTimeMillis());
        if (bl) {
            _logger.finest("Returning from MIDDLE of applicationUndeployed");
            return;
        }
        SessionPurgeUtil sessionPurgeUtil = new SessionPurgeUtil(_instances);
        _logger.finest("about to call SessionPurgeUtil for" + string);
        string = "/" + string;
        sessionPurgeUtil.purgeSessionsForApp(string);
        System.gc();
        _logger.finest("Returning from END of applicationUndeployed");
    }

    public void applicationRedeployed(ApplicationDeployEvent applicationDeployEvent) {
        String string = applicationDeployEvent.getApplicationName();
        _logger.finest("applicationRedeployed:" + string);
        String string2 = "App_" + string;
        boolean bl = this.checkDeployHistoryEntry(string2, "redeployed");
        this.setDeployHistoryEntry(string2, "redeployed", System.currentTimeMillis());
        if (bl) {
            _logger.finest("Returning from MIDDLE of applicationRedeployed");
            return;
        }
        SessionPurgeUtil sessionPurgeUtil = new SessionPurgeUtil(_instances);
        _logger.finest("about to call SessionPurgeUtil for" + string);
        string = "/" + string;
        sessionPurgeUtil.purgeSessionsForApp(string);
        System.gc();
        _logger.finest("Returning from END of applicationRedeployed");
    }

    public void applicationEnabled(ApplicationDeployEvent applicationDeployEvent) {
    }

    public void applicationDisabled(ApplicationDeployEvent applicationDeployEvent) {
    }

    public void moduleDeployed(ModuleDeployEvent moduleDeployEvent) {
        String string = moduleDeployEvent.getModuleName();
        _logger.finest("moduleDeployed:" + string);
        String string2 = "Mod_" + string;
        boolean bl = this.checkDeployHistoryEntry(string2, "deployed");
        this.setDeployHistoryEntry(string2, "deployed", System.currentTimeMillis());
        if (bl) {
            _logger.finest("Returning from MIDDLE of moduleDeployed");
            return;
        }
        ConnectionShutdownUtil connectionShutdownUtil = new ConnectionShutdownUtil(_instances);
        System.out.println("IN WebContainer>>moduleDeployed: " + string + "about to close all connections");
        connectionShutdownUtil.runCloseAllConnections();
        System.gc();
        _logger.finest("Returning from END of moduleDeployed");
    }

    public void moduleUndeployed(ModuleDeployEvent moduleDeployEvent) {
        String string = moduleDeployEvent.getModuleName();
        _logger.finest("moduleUndeployed:" + string);
        String string2 = "Mod_" + string;
        boolean bl = this.checkDeployHistoryEntry(string2, "undeployed");
        this.setDeployHistoryEntry(string2, "undeployed", System.currentTimeMillis());
        if (bl) {
            _logger.finest("Returning from MIDDLE of moduleUndeployed");
            return;
        }
        SessionPurgeUtil sessionPurgeUtil = new SessionPurgeUtil(_instances);
        _logger.finest("about to call SessionPurgeUtil for" + string);
        string = "/" + string;
        sessionPurgeUtil.purgeSessionsForApp(string);
        ConnectionShutdownUtil connectionShutdownUtil = new ConnectionShutdownUtil(_instances);
        System.out.println("IN WebContainer>>moduleUndeployed: " + string + "about to close all connections");
        connectionShutdownUtil.runCloseAllConnections();
        System.gc();
        _logger.finest("Returning from END of moduleUndeployed");
    }

    public void moduleRedeployed(ModuleDeployEvent moduleDeployEvent) {
        String string = moduleDeployEvent.getModuleName();
        _logger.finest("moduleRedeployed:" + string);
        String string2 = "Mod_" + string;
        boolean bl = this.checkDeployHistoryEntry(string2, "redeployed");
        this.setDeployHistoryEntry(string2, "redeployed", System.currentTimeMillis());
        if (bl) {
            _logger.finest("Returning from MIDDLE of moduleRedeployed");
            return;
        }
        SessionPurgeUtil sessionPurgeUtil = new SessionPurgeUtil(_instances);
        _logger.finest("about to call SessionPurgeUtil for" + string);
        string = "/" + string;
        sessionPurgeUtil.purgeSessionsForApp(string);
        ConnectionShutdownUtil connectionShutdownUtil = new ConnectionShutdownUtil(_instances);
        System.out.println("IN WebContainer>>moduleRedeployed: " + string + "about to close all connections");
        connectionShutdownUtil.runCloseAllConnections();
        System.gc();
        _logger.finest("Returning from END of moduleRedeployed");
    }

    public void moduleEnabled(ModuleDeployEvent moduleDeployEvent) {
    }

    public void moduleDisabled(ModuleDeployEvent moduleDeployEvent) {
    }

    public StandardHost createVS(long l, String string, String string2) {
        Object object;
        VirtualServer virtualServer = (VirtualServer)this._embedded.createHost(string, string2);
        virtualServer.setJNIVirtualServer(l);
        com.iplanet.ias.config.serverbeans.VirtualServer virtualServer2 = this.findVirtalServerBean(string);
        if (virtualServer2 != null) {
            if (!this.isSSOEnabled(virtualServer2)) {
                object = new Object[]{virtualServer.getID()};
                _logger.log(Level.INFO, "webcontainer.ssodisabled", (Object[])object);
            } else {
                try {
                    ElementProperty elementProperty;
                    ElementProperty elementProperty2;
                    SSOFactory sSOFactory = SSOFactory.getInstance(virtualServer2);
                    if (sSOFactory != null) {
                        object = sSOFactory.createSingleSignOnValve();
                    } else {
                        _logger.log(Level.WARNING, "SSOfactory initialization failed so defaulting to SSO");
                        object = new SingleSignOn();
                    }
                    if (this._debug > 1) {
                        ((SingleSignOn)object).setDebug(this._debug);
                    }
                    if ((elementProperty2 = virtualServer2.getElementPropertyByName(SSO_MAX_IDLE)) != null && elementProperty2.getValue() != null) {
                        _logger.fine("SSO entry max idle time set to: " + elementProperty2.getValue());
                        int n = Integer.parseInt(elementProperty2.getValue());
                        ((SingleSignOn)object).setMaxInactive(n);
                    }
                    if ((elementProperty = virtualServer2.getElementPropertyByName(SSO_REAP_INTERVAL)) != null && elementProperty.getValue() != null) {
                        _logger.fine("SSO expire thread interval set to : " + elementProperty.getValue());
                        int n = Integer.parseInt(elementProperty.getValue());
                        ((SingleSignOn)object).setReapInterval(n);
                    }
                    virtualServer.addValve((Valve)object);
                }
                catch (Exception exception) {
                    _logger.log(Level.WARNING, "webcontainer.ssobadconfig", exception.getMessage());
                    _logger.log(Level.WARNING, "webcontainer.ssodisabled", virtualServer.getID());
                }
            }
        }
        if ((object = this._engine.getDefaultHost()) == null && this._engine instanceof StandardEngine) {
            ((StandardEngine)this._engine).setDefaultHost(string);
        }
        this._engine.addChild(virtualServer);
        return virtualServer;
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this._lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this._lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void start() throws LifecycleException {
        int n;
        if (this._started) {
            String string = _rb.getString("webcontainer.alreadyStarted");
            throw new LifecycleException(string);
        }
        this.registerAdminEvents();
        Container[] containerArray = this._engine.findChildren();
        for (n = 0; n < containerArray.length; ++n) {
            this.loadWebModules((VirtualServer)containerArray[n]);
        }
        this.loadAllJ2EEApplicationWebModules();
        this.loadSystemDefaultWebModules();
        this._lifecycle.fireLifecycleEvent("start", null);
        this._started = true;
        this._embedded.start();
        for (n = 0; n < containerArray.length; ++n) {
            ((VirtualServer)containerArray[n]).handleCoreMappings();
        }
        if (this._reloadingEnabled) {
            com.iplanet.ias.config.serverbeans.WebModule[] webModuleArray;
            Applications applications = this._serverBean.getApplications();
            this._reloadManager = new StandaloneWebModulesManager(this._id, this._modulesRoot);
            if (applications != null && (webModuleArray = applications.getWebModule()) != null && webModuleArray.length > 0) {
                this._reloadManager.start(webModuleArray, this._pollInterval);
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this._started) {
            String string = _rb.getString("webcontainer.notStarted");
            throw new LifecycleException(string);
        }
        this.unregisterAdminEvents();
        this._started = false;
        this._embedded.stop();
        if (this._reloadManager != null) {
            this._reloadManager.stop();
            this._reloadManager = null;
        }
    }

    public static WebContainer createInstance(long l, ServerContext serverContext) {
        WebContainer webContainer = new WebContainer(Long.toString(l), serverContext);
        _instances.put(new Long(l), webContainer);
        return webContainer;
    }

    public static WebContainer getInstance(long l) {
        Long l2 = new Long(l);
        WebContainer webContainer = (WebContainer)_instances.get(l2);
        if (webContainer == null) {
            _logger.fine("Cound not find web container associated with the configuration: " + l);
        }
        return webContainer;
    }

    public static void startInstance(long l) throws ServerLifecycleException {
        WebContainer webContainer = WebContainer.getInstance(l);
        if (webContainer != null) {
            try {
                webContainer.start();
            }
            catch (LifecycleException lifecycleException) {
                Throwable throwable = lifecycleException.getThrowable();
                if (throwable == null) {
                    throwable = lifecycleException;
                }
                String string = _rb.getString("webcontainer.startError");
                throw new ServerLifecycleException(string, throwable);
            }
        } else {
            String string = _rb.getString("webcontainer.notFound");
            throw new ServerLifecycleException(string);
        }
    }

    public static void stopInstance(long l) throws ServerLifecycleException {
        WebContainer webContainer = WebContainer.getInstance(l);
        if (webContainer != null) {
            _instances.remove(new Long(l));
            try {
                webContainer.stop();
            }
            catch (LifecycleException lifecycleException) {
                Throwable throwable = lifecycleException.getThrowable();
                if (throwable == null) {
                    throwable = lifecycleException;
                }
                String string = _rb.getString("webcontainer.stopError");
                throw new ServerLifecycleException(string, throwable);
            }
        } else {
            String string = _rb.getString("webcontainer.notFound");
            throw new ServerLifecycleException(string);
        }
    }

    public static void stopAllInstances() throws ServerLifecycleException {
        System.out.println("SHUTDOWN-about to gather shutdownCleanupCapables");
        ConnectionShutdownUtil connectionShutdownUtil = new ConnectionShutdownUtil(_instances);
        ArrayList arrayList = new ArrayList();
        try {
            arrayList = connectionShutdownUtil.runGetShutdownCapables();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Enumeration enumeration = _instances.keys();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Long l = (Long)enumeration.nextElement();
                WebContainer.stopInstance(l);
            }
        }
        connectionShutdownUtil.clearoutJDBCPool();
        System.out.println("SHUTDOWN-about to close connections");
        connectionShutdownUtil.runShutdownCleanupFromShutdownCleanupCapableList(arrayList);
    }

    public static int service(long l, NSAPIProcessor nSAPIProcessor, StandardHost standardHost, String[] stringArray, byte[][] byArray, int[] nArray, StandardContext standardContext, String string, StandardWrapper standardWrapper, String string2, String string3) {
        boolean bl = false;
        if (nSAPIProcessor == null) {
            nSAPIProcessor = new NSAPIProcessor();
            bl = true;
        }
        NSAPIConnector nSAPIConnector = nSAPIProcessor.getConnector();
        nSAPIConnector.setContainer(standardHost);
        nSAPIConnector.setJNIConnector(l);
        if (bl) {
            nSAPIConnector.jniSetThreadLocalData(nSAPIProcessor);
        }
        if (System.getProperty("J2EEDecodeURI") != null) {
            stringArray[3] = RequestUtil.URLDecode(stringArray[3]);
        }
        nSAPIProcessor.process(standardHost, stringArray, byArray, nArray, standardContext, string, standardWrapper, string2, string3);
        return 0;
    }

    private void loadWebModules(VirtualServer virtualServer) {
        Vector<WebModuleConfig> vector = virtualServer.getWebModules(this._serverBean, this._modulesRoot);
        WebModuleConfig webModuleConfig = virtualServer.getUserDefaultWebModuleConfig(this._serverBean);
        if (webModuleConfig != null) {
            if (vector == null) {
                vector = new Vector<WebModuleConfig>();
            }
            vector.add(0, webModuleConfig);
        }
        if (vector != null && vector.size() > 0) {
            ListIterator listIterator = vector.listIterator();
            while (listIterator.hasNext()) {
                webModuleConfig = (WebModuleConfig)listIterator.next();
                this.loadStandaloneWebModule(virtualServer, webModuleConfig);
            }
        }
    }

    private void loadSystemDefaultWebModules() {
        Container[] containerArray = this._engine.findChildren();
        for (int i = 0; i < containerArray.length; ++i) {
            VirtualServer virtualServer;
            WebModuleConfig webModuleConfig;
            if (!(containerArray[i] instanceof VirtualServer) || (webModuleConfig = (virtualServer = (VirtualServer)containerArray[i]).createSystemDefaultWebModuleIfNecessary()) == null) continue;
            this.loadStandaloneWebModule(virtualServer, webModuleConfig);
        }
    }

    private void loadStandaloneWebModule(VirtualServer virtualServer, WebModuleConfig webModuleConfig) {
        String string = webModuleConfig.getName();
        if (string.indexOf(":") != -1) {
            webModuleConfig.setWorkDirBase(this._appsWorkRoot);
        } else {
            webModuleConfig.setWorkDirBase(this._modulesWorkRoot);
        }
        try {
            this.loadWebModule(virtualServer, webModuleConfig);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{string, virtualServer.getID(), exception};
            _logger.log(Level.SEVERE, "webcontainer.loadError", objectArray);
            _logger.log(Level.SEVERE, "Error loading web module " + string, exception);
        }
    }

    private void loadAllJ2EEApplicationWebModules() {
        J2eeApplication[] j2eeApplicationArray;
        Applications applications = this._serverBean.getApplications();
        if (applications != null && (j2eeApplicationArray = applications.getJ2eeApplication()) != null) {
            for (int i = 0; i < j2eeApplicationArray.length; ++i) {
                this.loadJ2EEApplicationWebModules(j2eeApplicationArray[i]);
            }
        }
    }

    private void loadJ2EEApplicationWebModules(J2eeApplication j2eeApplication) {
        if (j2eeApplication != null && j2eeApplication.isEnabled()) {
            String string = j2eeApplication.getName();
            String string2 = j2eeApplication.getLocation();
            ApplicationRegistry applicationRegistry = ApplicationRegistry.getInstance();
            ClassLoader classLoader = applicationRegistry.getClassLoaderForApplication(string);
            if (classLoader != null) {
                Application application = applicationRegistry.getApplication(classLoader);
                if (application == null) {
                    Object[] objectArray = new Object[]{string};
                    _logger.log(Level.SEVERE, "webcontainer.notLoaded", objectArray);
                } else {
                    Set set = application.getWebBundleDescriptors();
                    WebBundleDescriptor webBundleDescriptor = null;
                    com.iplanet.ias.config.serverbeans.WebModule webModule = null;
                    WebModuleConfig webModuleConfig = null;
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        StringBuffer stringBuffer = new StringBuffer(string2);
                        webBundleDescriptor = (WebBundleDescriptor)iterator.next();
                        String string3 = webBundleDescriptor.getArchivist().getArchiveUri();
                        stringBuffer.append(File.separator);
                        stringBuffer.append(FileUtils.makeFriendlyFilename(string3));
                        webModule = new com.iplanet.ias.config.serverbeans.WebModule();
                        webModule.setName(string3);
                        webModule.setContextRoot(webBundleDescriptor.getContextRoot());
                        webModule.setLocation(stringBuffer.toString());
                        webModule.setVirtualServers(j2eeApplication.getVirtualServers());
                        webModule.setEnabled(true);
                        webModuleConfig = new WebModuleConfig();
                        webModuleConfig.setBean(webModule);
                        webModuleConfig.setWorkDirBase(this._appsWorkRoot);
                        webModuleConfig.setDescriptor(webBundleDescriptor);
                        webModuleConfig.setParentLoader(classLoader);
                        this.loadWebModule(webModuleConfig);
                    }
                }
            }
        }
    }

    private void loadWebModule(WebModuleConfig webModuleConfig) {
        String string = webModuleConfig.getVirtualServers();
        List list = StringUtils.parseStringList((String)string, (String)" ,");
        boolean bl = list == null || list.size() == 0;
        Container[] containerArray = this._engine.findChildren();
        for (int i = 0; i < containerArray.length; ++i) {
            if (!(containerArray[i] instanceof VirtualServer)) continue;
            VirtualServer virtualServer = (VirtualServer)containerArray[i];
            if (!bl && !list.contains(virtualServer.getID())) continue;
            try {
                this.loadWebModule(virtualServer, webModuleConfig);
                continue;
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{webModuleConfig.getName(), virtualServer.getID(), exception};
                _logger.log(Level.SEVERE, "webcontainer.appLoadError", objectArray);
                _logger.log(Level.SEVERE, "Error loading web module " + webModuleConfig.getName(), exception);
            }
        }
    }

    private void loadWebModule(VirtualServer virtualServer, WebModuleConfig webModuleConfig) throws NamingException, MalformedURLException, IllegalArgumentException {
        Object[] objectArray;
        Object object;
        Object object2;
        String string = webModuleConfig.getName();
        String string2 = webModuleConfig.getContextPath();
        String string3 = null;
        string3 = string2.equals("") ? "/" : string2;
        if (virtualServer.findChild(string2) != null) {
            Object[] objectArray2 = new Object[]{virtualServer.getID(), string3, string};
            _logger.log(Level.SEVERE, "webcontainer.duplicateContextRoot", objectArray2);
            return;
        }
        Object[] objectArray3 = new Object[]{string, virtualServer.getID(), string3};
        if (string.equals("default-web-module")) {
            _logger.log(Level.FINE, "webcontainer.loadModule", objectArray3);
        } else {
            _logger.log(Level.INFO, "webcontainer.loadModule", objectArray3);
        }
        Context context = this._embedded.createContext(string2, webModuleConfig.getLocation());
        ((StandardContext)context).setCachingAllowed(true);
        StringBuffer stringBuffer = new StringBuffer(webModuleConfig.getWorkDir());
        if (string.equals("default-web-module")) {
            stringBuffer.append("-");
            stringBuffer.append(FileUtils.makeFriendlyFilename(virtualServer.getID()));
        }
        ((StandardContext)context).setWorkDir(stringBuffer.toString());
        ClassLoader classLoader = webModuleConfig.getParentLoader();
        if (classLoader == null) {
            classLoader = this._serverContext.getCommonClassLoader();
        }
        context.setParentClassLoader(classLoader);
        WebBundleDescriptor webBundleDescriptor = null;
        webBundleDescriptor = webModuleConfig.getDescriptor();
        if (webBundleDescriptor != null && (object2 = webBundleDescriptor.getArchivist().getExternalDescriptorArchiveUri()) != null) {
            object = webModuleConfig.getLocation() + "/..";
            object2 = ((String)object2).startsWith("/") ? (String)object + ((String)object2).trim() : (String)object + "/" + ((String)object2).trim();
            objectArray = new Object[]{object2, string};
            _logger.log(Level.INFO, "webcontainer.altDDName", objectArray);
            ((StandardContext)context).setAltDDName((String)object2);
        }
        object2 = null;
        if (webBundleDescriptor != null) {
            object2 = webBundleDescriptor.getIasWebApp();
        }
        object = (WebModule)context;
        ((WebModule)object).setIasWebAppConfigBean((SunWebApp)((Object)object2));
        ((WebModule)object).setID(string);
        this.configureLoader(context, (SunWebApp)((Object)object2));
        this.configureMiscSettings(context, (SunWebApp)((Object)object2), virtualServer.getID(), string3);
        this.configureSessionSettings(context, (SunWebApp)((Object)object2), webBundleDescriptor);
        ((WebModule)object).setI18nInfo();
        objectArray = Switch.getSwitch();
        if (webBundleDescriptor != null) {
            context.setRealm(new RealmAdapter(webBundleDescriptor));
            objectArray.setDescriptorFor(context, webBundleDescriptor);
            objectArray.getNamingManager().bindObjects(webBundleDescriptor);
        }
        virtualServer.addChild(context);
        if (webBundleDescriptor != null) {
            objectArray.setDescriptorFor(context, webBundleDescriptor);
        }
    }

    private void configureLoader(Context context, SunWebApp sunWebApp) {
        Object object;
        Loader loader = this._embedded.createLoader(context.getParentClassLoader());
        boolean bl = false;
        List list = null;
        if (sunWebApp != null && sunWebApp.isClassLoader()) {
            object = sunWebApp.getAttributeValue("ClassLoader", "delegate");
            if (object != null) {
                bl = ConfigBean.toBoolean((String)object);
            }
            if ((object = sunWebApp.getAttributeValue("ClassLoader", "extra-class-path")) != null) {
                list = StringUtils.parseStringList((String)object, (String)";:");
            }
        }
        if (this._debug > 0) {
            _logger.fine("WebModule[" + context.getPath() + "]: Setting delegate to " + bl);
        }
        loader.setDelegate(bl);
        if (list != null) {
            object = list.listIterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (this._debug > 0) {
                    _logger.fine("WebModule[" + context.getPath() + "]: Adding " + string + " to the classpath");
                }
                try {
                    URL uRL = new File(string).toURI().toURL();
                    loader.addRepository(uRL.toString());
                }
                catch (MalformedURLException malformedURLException) {
                    String string2 = _rb.getString("webcontainer.classpathError");
                    Object[] objectArray = new Object[]{string};
                    string2 = MessageFormat.format(string2, objectArray);
                    _logger.log(Level.SEVERE, string2, malformedURLException);
                }
            }
        }
        if (this._reloadingEnabled) {
            if (this._debug > 0) {
                _logger.fine("WebModule[" + context.getPath() + "]: Dynamic reloading enabled (poll interval = " + this._pollInterval + " second(s))");
            }
            context.setReloadable(true);
            ((WebappLoader)loader).setCheckInterval(this._pollInterval);
        }
        context.setLoader(loader);
    }

    private void configureMiscSettings(Context context, SunWebApp sunWebApp, String string, String string2) {
        if (sunWebApp != null && sunWebApp.sizeWebProperty() > 0) {
            WebProperty[] webPropertyArray = sunWebApp.getWebProperty();
            for (int i = 0; i < webPropertyArray.length; ++i) {
                Object[] objectArray;
                String string3 = webPropertyArray[i].getAttributeValue("name");
                String string4 = webPropertyArray[i].getAttributeValue("value");
                if (string3.equalsIgnoreCase("singleThreadedServletPoolSize")) {
                    try {
                        int n = Integer.parseInt(string4);
                        if (n <= 0) continue;
                        ((StandardContext)context).setSTMPoolSize(n);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (string3.equalsIgnoreCase("tempdir")) {
                    ((StandardContext)context).setWorkDir(string4);
                    continue;
                }
                if (string3.equalsIgnoreCase("crossContextAllowed")) {
                    boolean bl = ConfigBean.toBoolean(string4);
                    ((StandardContext)context).setCrossContext(bl);
                    continue;
                }
                if (string3.equalsIgnoreCase("reuseSessionID")) {
                    boolean bl = ConfigBean.toBoolean(string4);
                    context.setReuseSessionID(bl);
                    if (!bl) continue;
                    objectArray = new Object[]{string2, string};
                    _logger.log(Level.WARNING, "webcontainer.sessionIDsReused", objectArray);
                    continue;
                }
                if (string3.equalsIgnoreCase("useResponseCTForHeaders")) {
                    if (!string4.equalsIgnoreCase("true")) continue;
                    WebModule webModule = (WebModule)context;
                    webModule.setResponseCTForHeaders();
                    continue;
                }
                if (string3.equalsIgnoreCase("encodeCookies")) {
                    boolean bl = ConfigBean.toBoolean(string4);
                    objectArray = (Object[])context;
                    objectArray.setEncodeCookies(bl);
                    continue;
                }
                if (string3.equalsIgnoreCase("relativeRedirectAllowed")) {
                    boolean bl = ConfigBean.toBoolean(string4);
                    context.setAllowRelativeRedirect(bl);
                    continue;
                }
                Object[] objectArray2 = new Object[]{string3, string4};
                _logger.log(Level.INFO, "webcontainer.invalidProperty", objectArray2);
            }
        }
    }

    private void configureSessionSettingsLastGood(Context context, SunWebApp sunWebApp) {
        SessionConfig sessionConfig = null;
        SessionManager sessionManager = null;
        SessionProperties sessionProperties = null;
        CookieProperties cookieProperties = null;
        if (sunWebApp != null) {
            sessionConfig = sunWebApp.getSessionConfig();
        }
        if (sessionConfig != null) {
            sessionManager = sessionConfig.getSessionManager();
        }
        if (sessionConfig != null) {
            sessionProperties = sessionConfig.getSessionProperties();
        }
        if (sessionConfig != null) {
            cookieProperties = sessionConfig.getCookieProperties();
        }
        this.configureSessionManagerLastGood(context, sessionManager);
        this.configureSessionLastGood(context, sessionProperties);
        this.configureCookieProperties(context, cookieProperties);
    }

    private void configureSessionSettings(Context context, SunWebApp sunWebApp, WebBundleDescriptor webBundleDescriptor) {
        SessionConfig sessionConfig = null;
        SessionManager sessionManager = null;
        SessionProperties sessionProperties = null;
        CookieProperties cookieProperties = null;
        if (sunWebApp != null) {
            sessionConfig = sunWebApp.getSessionConfig();
        }
        if (sessionConfig != null) {
            sessionManager = sessionConfig.getSessionManager();
        }
        if (sessionConfig != null) {
            sessionProperties = sessionConfig.getSessionProperties();
        }
        if (sessionConfig != null) {
            cookieProperties = sessionConfig.getCookieProperties();
        }
        this.configureSessionManager(context, sessionManager, webBundleDescriptor);
        this.configureSession(context, sessionProperties, webBundleDescriptor);
        this.configureCookieProperties(context, cookieProperties);
    }

    public String getApplicationId(Context context) {
        WebModule webModule = (WebModule)context;
        return webModule.getID();
    }

    public Engine privateGetEngine() {
        return this._engine;
    }

    private void configureSessionManager(Context context, SessionManager sessionManager, WebBundleDescriptor webBundleDescriptor) {
        Object object;
        Object object2;
        String string;
        PersistenceType persistenceType;
        boolean bl = false;
        boolean bl2 = false;
        if (webBundleDescriptor != null) {
            bl = webBundleDescriptor.isDistributable();
        }
        _logger.finest("Web App Distributable (" + this.getApplicationId(context) + "): " + bl);
        PersistenceType persistenceType2 = PersistenceType.MEMORY;
        String string2 = null;
        String string3 = null;
        ServerConfigLookup serverConfigLookup = new ServerConfigLookup();
        String string4 = this.getApplicationId(context);
        if (!string4.equals("default-web-module")) {
            bl2 = this.checkForAvailabilityEnabled(serverConfigLookup, string4);
        }
        _logger.finest("AvailabilityGloballyEnabled = " + bl2);
        if (bl2) {
            persistenceType2 = PersistenceType.HA;
            string2 = "time-based";
            string3 = "session";
        }
        if ((persistenceType = serverConfigLookup.getPersistenceTypeFromConfig()) != null) {
            persistenceType2 = persistenceType;
            string2 = serverConfigLookup.getPersistenceFrequencyFromConfig();
            string3 = serverConfigLookup.getPersistenceScopeFromConfig();
        }
        String string5 = null;
        if (persistenceType2 != null) {
            string5 = persistenceType2.getType();
        }
        _logger.finest("instance-level persistence-type = " + string5);
        _logger.finest("instance-level persistenceFrequency = " + string2);
        _logger.finest("instance-level persistenceScope = " + string3);
        String string6 = null;
        String string7 = null;
        if (sessionManager != null) {
            string = sessionManager.getAttributeValue("persistence-type");
            persistenceType2 = PersistenceType.parseType(string, persistenceType2);
            string6 = this.getPersistenceFrequency(sessionManager);
            _logger.finest("webAppLevelPersistenceFrequency = " + string6);
            string7 = this.getPersistenceScope(sessionManager);
            _logger.finest("webAppLevelPersistenceScope = " + string7);
        }
        if (string6 != null) {
            string2 = string6;
        }
        if (string7 != null) {
            string3 = string7;
        }
        _logger.finest("IN WebContainer>>ConfigureSessionManager");
        _logger.finest("PERSISTENCE-TYPE IS = " + persistenceType2.getType());
        _logger.finest("PERSISTENCE_FREQUENCY IS = " + string2);
        _logger.finest("PERSISTENCE_SCOPE IS = " + string3);
        string = null;
        String string8 = null;
        if (!(persistenceType2 == PersistenceType.MEMORY | persistenceType2 == PersistenceType.FILE | persistenceType2 == PersistenceType.CUSTOM)) {
            string = string2;
            string8 = string3;
        }
        if (!bl && persistenceType2 != PersistenceType.MEMORY) {
            object2 = this.getApplicationId(context);
            if (!((String)object2).equals("default-web-module")) {
                object = new Object[]{this.getApplicationId(context), persistenceType2.getType(), string, string8};
                _logger.log(Level.INFO, "webcontainer.invalidSessionManagerConfig2", (Object[])object);
            }
            persistenceType2 = PersistenceType.MEMORY;
            string = null;
            string8 = null;
        }
        if (!bl2) {
            persistenceType2 = PersistenceType.MEMORY;
            string = null;
            string8 = null;
        }
        _logger.finest("IN WebContainer>>ConfigureSessionManager before builder factory");
        _logger.finest("FINAL_PERSISTENCE-TYPE IS = " + persistenceType2.getType());
        _logger.finest("FINAL_PERSISTENCE_FREQUENCY IS = " + string);
        _logger.finest("FINAL_PERSISTENCE_SCOPE IS = " + string8);
        object2 = new PersistenceStrategyBuilderFactory();
        object = ((PersistenceStrategyBuilderFactory)object2).createPersistenceStrategyBuilder(persistenceType2.getType(), string, string8, context);
        _logger.finest("PersistenceStrategyBuilder class = " + object.getClass().getName());
        object.setLogger(_logger);
        object.initializePersistenceStrategy(context, sessionManager);
    }

    private void configureSessionManagerLastGood(Context context, SessionManager sessionManager) {
        String string;
        PersistenceType persistenceType = PersistenceType.MEMORY;
        String string2 = null;
        String string3 = null;
        ServerConfigLookup serverConfigLookup = new ServerConfigLookup();
        PersistenceType persistenceType2 = serverConfigLookup.getPersistenceTypeFromConfig();
        if (persistenceType2 != null) {
            persistenceType = persistenceType2;
        }
        string2 = serverConfigLookup.getPersistenceFrequencyFromConfig();
        _logger.finest("instance-level persistenceFrequency = " + string2);
        string3 = serverConfigLookup.getPersistenceScopeFromConfig();
        _logger.finest("instance-level persistenceScope = " + string3);
        String string4 = null;
        String string5 = null;
        if (sessionManager != null) {
            string = sessionManager.getAttributeValue("persistence-type");
            persistenceType = PersistenceType.parseType(string, persistenceType);
            string4 = this.getPersistenceFrequency(sessionManager);
            _logger.finest("webAppLevelPersistenceFrequency = " + string4);
            string5 = this.getPersistenceScope(sessionManager);
            _logger.finest("webAppLevelPersistenceScope = " + string5);
        }
        if (string4 != null) {
            string2 = string4;
        }
        if (string5 != null) {
            string3 = string5;
        }
        _logger.finest("IN WebContainer>>ConfigureSessionManager");
        _logger.finest("PERSISTENCE-TYPE IS = " + persistenceType.getType());
        _logger.finest("PERSISTENCE_FREQUENCY IS = " + string2);
        _logger.finest("PERSISTENCE_SCOPE IS = " + string3);
        string = null;
        String string6 = null;
        if (!(persistenceType == PersistenceType.MEMORY | persistenceType == PersistenceType.FILE | persistenceType == PersistenceType.CUSTOM)) {
            string = string2;
            string6 = string3;
        }
        PersistenceStrategyBuilderFactory persistenceStrategyBuilderFactory = new PersistenceStrategyBuilderFactory();
        PersistenceStrategyBuilder persistenceStrategyBuilder = persistenceStrategyBuilderFactory.createPersistenceStrategyBuilder(persistenceType.getType(), string, string6);
        _logger.finest("PersistenceStrategyBuilder class = " + persistenceStrategyBuilder.getClass().getName());
        persistenceStrategyBuilder.setLogger(_logger);
        persistenceStrategyBuilder.initializePersistenceStrategy(context, sessionManager);
    }

    private String getPersistenceScope(SessionManager sessionManager) {
        String string = null;
        StoreProperties storeProperties = sessionManager.getStoreProperties();
        if (storeProperties != null && storeProperties.sizeWebProperty() > 0) {
            WebProperty[] webPropertyArray = storeProperties.getWebProperty();
            for (int i = 0; i < webPropertyArray.length; ++i) {
                String string2 = webPropertyArray[i].getAttributeValue("name");
                String string3 = webPropertyArray[i].getAttributeValue("value");
                if (!string2.equalsIgnoreCase("persistenceScope")) continue;
                string = string3;
            }
        }
        return string;
    }

    private String getPersistenceFrequency(SessionManager sessionManager) {
        String string = null;
        ManagerProperties managerProperties = sessionManager.getManagerProperties();
        if (managerProperties != null && managerProperties.sizeWebProperty() > 0) {
            WebProperty[] webPropertyArray = managerProperties.getWebProperty();
            for (int i = 0; i < webPropertyArray.length; ++i) {
                String string2 = webPropertyArray[i].getAttributeValue("name");
                String string3 = webPropertyArray[i].getAttributeValue("value");
                if (!string2.equalsIgnoreCase("persistenceFrequency")) continue;
                string = string3;
            }
        }
        return string;
    }

    private void configureSession(Context context, SessionProperties sessionProperties, WebBundleDescriptor webBundleDescriptor) {
        boolean bl = false;
        int n = 60;
        boolean bl2 = true;
        if (sessionProperties != null && sessionProperties.sizeWebProperty() > 0) {
            WebProperty[] webPropertyArray = sessionProperties.getWebProperty();
            for (int i = 0; i < webPropertyArray.length; ++i) {
                String string = webPropertyArray[i].getAttributeValue("name");
                String string2 = webPropertyArray[i].getAttributeValue("value");
                if (string.equalsIgnoreCase("timeoutSeconds")) {
                    try {
                        n = Integer.parseInt(string2);
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (string.equalsIgnoreCase("enableCookies")) {
                    bl2 = ConfigBean.toBoolean(string2);
                    continue;
                }
                Object[] objectArray = new Object[]{string};
                _logger.log(Level.INFO, "webcontainer.notYet", objectArray);
            }
        }
        int n2 = -1;
        if (webBundleDescriptor != null) {
            n2 = webBundleDescriptor.getSessionTimeout() * 60;
        }
        if (n2 != -1 && n2 != 1800) {
            context.getManager().setMaxInactiveInterval(n2);
        } else if (bl) {
            context.getManager().setMaxInactiveInterval(n);
        }
        context.setCookies(bl2);
    }

    private void configureSessionLastGood(Context context, SessionProperties sessionProperties) {
        boolean bl = false;
        int n = 60;
        boolean bl2 = true;
        if (sessionProperties != null && sessionProperties.sizeWebProperty() > 0) {
            WebProperty[] webPropertyArray = sessionProperties.getWebProperty();
            for (int i = 0; i < webPropertyArray.length; ++i) {
                String string = webPropertyArray[i].getAttributeValue("name");
                String string2 = webPropertyArray[i].getAttributeValue("value");
                if (string.equalsIgnoreCase("timeoutSeconds")) {
                    try {
                        n = Integer.parseInt(string2);
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (string.equalsIgnoreCase("enableCookies")) {
                    bl2 = ConfigBean.toBoolean(string2);
                    continue;
                }
                Object[] objectArray = new Object[]{string};
                _logger.log(Level.INFO, "webcontainer.notYet", objectArray);
            }
        }
        if (bl) {
            context.getManager().setMaxInactiveInterval(n);
        }
        context.setCookies(bl2);
    }

    private void configureCookieProperties(Context context, CookieProperties cookieProperties) {
        WebProperty[] webPropertyArray;
        if (cookieProperties != null && (webPropertyArray = cookieProperties.getWebProperty()) != null) {
            SessionCookieConfig sessionCookieConfig = new SessionCookieConfig();
            for (int i = 0; i < webPropertyArray.length; ++i) {
                String string = webPropertyArray[i].getAttributeValue("name");
                String string2 = webPropertyArray[i].getAttributeValue("value");
                if (string.equalsIgnoreCase("cookieName")) {
                    sessionCookieConfig.setName(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("cookiePath")) {
                    sessionCookieConfig.setPath(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("cookieMaxAgeSeconds")) {
                    try {
                        sessionCookieConfig.setMaxAge(Integer.parseInt(string2));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (string.equalsIgnoreCase("cookieDomain")) {
                    sessionCookieConfig.setDomain(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("cookieComment")) {
                    sessionCookieConfig.setComment(string2);
                    continue;
                }
                Object[] objectArray = new Object[]{string, string2};
                _logger.log(Level.INFO, "webcontainer.invalidProperty", objectArray);
            }
            if (webPropertyArray.length > 0) {
                if (this._debug > 0) {
                    _logger.fine("WebModule[" + context.getPath() + "]: " + sessionCookieConfig);
                }
                WebModule webModule = (WebModule)context;
                webModule.setSessionCookieConfig(sessionCookieConfig);
            }
        }
    }

    private void getDynamicReloadingSettings(Applications applications) {
        if (applications != null) {
            this._reloadingEnabled = applications.isDynamicReloadEnabled();
            String string = applications.getDynamicReloadPollIntervalInSeconds();
            if (string != null) {
                try {
                    this._pollInterval = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private void setLogLevel(Level level) {
        this._logLevel = level;
        _logger.setLevel(this._logLevel);
        this._debug = level.equals(Level.FINE) ? 1 : (level.equals(Level.FINER) ? 2 : (level.equals(Level.FINEST) ? 5 : 0));
    }

    private boolean isSSOEnabled(com.iplanet.ias.config.serverbeans.VirtualServer virtualServer) {
        ElementProperty elementProperty = virtualServer.getElementPropertyByName(SSO_ENABLED);
        return elementProperty == null || elementProperty.getValue() == null || ConfigBean.toBoolean(elementProperty.getValue());
    }

    private com.iplanet.ias.config.serverbeans.VirtualServer findVirtalServerBean(String string) {
        HttpService httpService = this._serverBean.getHttpService();
        if (httpService == null) {
            return null;
        }
        VirtualServerClass[] virtualServerClassArray = httpService.getVirtualServerClass();
        if (virtualServerClassArray == null) {
            return null;
        }
        for (int i = 0; i < virtualServerClassArray.length; ++i) {
            com.iplanet.ias.config.serverbeans.VirtualServer[] virtualServerArray = virtualServerClassArray[i].getVirtualServer();
            if (virtualServerArray == null) {
                return null;
            }
            for (int j = 0; j < virtualServerArray.length; ++j) {
                if (!string.equals(virtualServerArray[j].getId())) continue;
                return virtualServerArray[j];
            }
        }
        return null;
    }

    private boolean checkDeployHistoryEntry(String string, String string2) {
        DeployHistoryEntry deployHistoryEntry = (DeployHistoryEntry)deployHistory.get(string);
        if (deployHistoryEntry == null) {
            return false;
        }
        String string3 = deployHistoryEntry.value;
        return string3.equals(string2) && System.currentTimeMillis() - deployHistoryEntry.lat < 60000L;
    }

    private void setDeployHistoryEntry(String string, String string2, long l) {
        DeployHistoryEntry deployHistoryEntry = (DeployHistoryEntry)deployHistory.get(string);
        if (deployHistoryEntry == null) {
            deployHistory.put(string, new DeployHistoryEntry(string2, l));
        } else {
            deployHistoryEntry.value = string2;
            deployHistoryEntry.lat = l;
        }
    }

    private boolean checkForAvailabilityEnabled(ServerConfigLookup serverConfigLookup, String string) {
        boolean bl = serverConfigLookup.getAvailabilityEnabledFromConfig();
        if (bl) {
            Applications applications;
            com.iplanet.ias.config.serverbeans.WebContainer webContainer = this._serverBean.getWebContainer();
            String string2 = webContainer.getAvailabilityEnabled();
            if (string2 != null && !string2.equalsIgnoreCase(NULL_STRING)) {
                bl = com.iplanet.ias.config.serverbeans.WebContainer.toBoolean(string2);
            }
            if (bl && (applications = this._serverBean.getApplications()) != null) {
                int n = string.indexOf(":");
                if (n < 0) {
                    com.iplanet.ias.config.serverbeans.WebModule webModule = applications.getWebModuleByName(string);
                    if (webModule != null && (string2 = webModule.getAvailabilityEnabled()) != null && !string2.equalsIgnoreCase(NULL_STRING)) {
                        bl = com.iplanet.ias.config.serverbeans.WebModule.toBoolean(string2);
                    }
                } else {
                    String string3 = string.substring(0, n);
                    J2eeApplication j2eeApplication = applications.getJ2eeApplicationByName(string3);
                    if (j2eeApplication != null && (string2 = j2eeApplication.getAvailabilityEnabled()) != null && !string2.equalsIgnoreCase(NULL_STRING)) {
                        bl = J2eeApplication.toBoolean(string2);
                    }
                }
            }
        }
        return bl;
    }

    static {
        WebDebugMonitor webDebugMonitor = new WebDebugMonitor();
        HashMap hashMap = webDebugMonitor.getDebugMonitoringDetails();
        debugMonitoring = (Boolean)hashMap.get("debugMonitoring");
        debugMonitoringPeriodMS = (Long)hashMap.get("debugMonitoringPeriodMS");
        if (debugMonitoring) {
            _timer.schedule((TimerTask)new DebugMonitor(_instances), 0L, debugMonitoringPeriodMS);
        }
    }
}

