/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web;

import com.iplanet.ias.web.ShutdownCleanupCapable;
import com.iplanet.ias.web.WebContainer;
import com.iplanet.ias.web.WebModule;
import com.sun.logging.LogDomains;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Manager;
import org.apache.catalina.session.PersistentManagerBase;

public class SessionPurgeUtil {
    private Hashtable _instances = null;
    private WebContainer webContainer = null;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");

    public SessionPurgeUtil() {
    }

    public SessionPurgeUtil(Hashtable hashtable) {
        this._instances = hashtable;
    }

    public String getApplicationId(Context context) {
        WebModule webModule = (WebModule)context;
        return webModule.getID();
    }

    public String getApplicationName(Context context) {
        return context.getName();
    }

    public String getApplicationName(WebContainer webContainer, Context context) {
        String string = webContainer.getApplicationId(context);
        int n = string.indexOf(":");
        String string2 = null;
        string2 = n > 1 ? string.substring(0, n) : string;
        string2 = "/" + string2;
        _logger.finest("getApplication name returning   =" + string2 + "        appname" + string);
        return string2;
    }

    public void purgeSessionsForApp(String string) {
        _logger.finest("IN SessionPurgeUtil:purgeSessionsForApp" + string);
        try {
            Enumeration enumeration = this._instances.elements();
            if (null == enumeration) {
                _logger.log(Level.SEVERE, "SHUTDOWN:: No containers available to report monitoring stats");
            }
            while (enumeration.hasMoreElements()) {
                this.webContainer = (WebContainer)enumeration.nextElement();
                Engine engine = this.webContainer.privateGetEngine();
                Container[] containerArray = engine.findChildren();
                for (int i = 0; i < containerArray.length; ++i) {
                    Container container = containerArray[i];
                    Container[] containerArray2 = container.findChildren();
                    for (int j = 0; j < containerArray2.length; ++j) {
                        Container container2 = containerArray2[j];
                        Context context = (Context)container2;
                        String string2 = this.getApplicationName(this.webContainer, context);
                        Manager manager = container2.getManager();
                        _logger.finest("webAppName = " + string2 + ", appName = " + string);
                        if (string2 == null || !string2.equals(string)) continue;
                        _logger.finest("found our manager:" + manager.getClass().getName());
                        if (!(manager instanceof PersistentManagerBase)) continue;
                        ((PersistentManagerBase)manager).clearSessions();
                        ((PersistentManagerBase)manager).clearStore();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            _logger.log(Level.SEVERE, "Exception thrown", throwable);
        }
    }

    public void closeCachedConnectionForApp(String string) {
        _logger.finest("IN SessionPurgeUtil:closeCachedConnectionForApp" + string);
        try {
            Enumeration enumeration = this._instances.elements();
            if (null == enumeration) {
                _logger.log(Level.SEVERE, "SHUTDOWN:: No containers available to report monitoring stats");
            }
            while (enumeration.hasMoreElements()) {
                this.webContainer = (WebContainer)enumeration.nextElement();
                Engine engine = this.webContainer.privateGetEngine();
                Container[] containerArray = engine.findChildren();
                for (int i = 0; i < containerArray.length; ++i) {
                    Container container = containerArray[i];
                    Container[] containerArray2 = container.findChildren();
                    for (int j = 0; j < containerArray2.length; ++j) {
                        Container container2 = containerArray2[j];
                        Context context = (Context)container2;
                        String string2 = this.getApplicationName(this.webContainer, context);
                        Manager manager = container2.getManager();
                        _logger.finest("webAppName = " + string2 + ", appName = " + string);
                        if (!string2.equals(string)) continue;
                        _logger.finest("found our manager:" + manager.getClass().getName());
                        if (!(manager instanceof ShutdownCleanupCapable)) continue;
                        ShutdownCleanupCapable shutdownCleanupCapable = (ShutdownCleanupCapable)((Object)manager);
                        shutdownCleanupCapable.doCloseCachedConnection();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            _logger.log(Level.SEVERE, "Exception thrown", throwable);
        }
    }
}

