/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web;

import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.AvailabilityService;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.JdbcConnectionPool;
import com.iplanet.ias.config.serverbeans.JdbcResource;
import com.iplanet.ias.config.serverbeans.Resources;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.SessionManager;
import com.iplanet.ias.config.serverbeans.SessionProperties;
import com.iplanet.ias.server.ApplicationServer;
import com.iplanet.ias.server.ServerContext;
import com.iplanet.ias.web.session.PersistenceType;
import com.sun.appserv.util.UuidGenerator;
import com.sun.appserv.util.UuidGeneratorImpl;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;

public class ServerConfigLookup {
    protected final String HADB_CONNECTION_URL_PREFIX = "jdbc:sun:hadb:";
    protected final String CLUSTER_ID_XPATH_STRING = "/server/availability-service/persistence-store/property[@name='cluster-id']";
    protected final String DEFAULT_CLUSTER_ID = "cluster1";
    protected final String AVAILABILITY_SERVICE_XPATH_STRING = "/server/availability-service";
    protected final String HADB_STORE_POOL_JNDI_NAME_XPATH_STRING = "/server/availability-service/persistence-store/property[@name='store-pool-jndi-name']";
    protected final String HADB_CONNECTION_XPATH_STRING = "/server/availability-service/persistence-store/property[@name='hadb-connection-url']";
    protected final String HADB_CONNECTION_USER_XPATH_STRING = "/server/availability-service/persistence-store/property[@name='hadb-connection-user']";
    protected final String HADB_CONNECTION_PASSWD_XPATH_STRING = "/server/availability-service/persistence-store/property[@name='hadb-connection-passwd']";
    protected final String PERSISTENCE_SCOPE_XPATH_STRING = "/server/web-container/session-config/session-manager/store-properties/property[@name='persistenceScope']";
    protected final String PERSISTENCE_FREQUENCY_XPATH_STRING = "/server/web-container/session-config/session-manager/manager-properties/property[@name='persistenceFrequency']";
    protected final String SESSION_MANAGER_XPATH_STRING = "/server/web-container/session-config/session-manager";
    protected final String SERVER_XPATH_STRING = "/server";
    protected final String SESSION_PROPERTIES_XPATH_STRING = "/server/web-container/session-config/session-properties";
    protected final String UUID_GENERATOR_CLASS_XPATH_STRING = "/server/availability-service/persistence-store/property[@name='uuid-impl-class']";
    protected final String DEFAULT_UUID_GENERATOR_CLASS = "com.sun.appserv.util.UuidGeneratorImpl";
    protected final String EE_BUILDER_PATH_XPATH_STRING = "/server/availability-service/persistence-store/property[@name='ee-builder-path']";
    protected final String DEFAULT_EE_BUILDER_PATH = "com.sun.appserv.ee.web.initialization";
    protected final String SESSION_MAX_INACTIVE_INTERVAL_XPATH_STRING = "/server/web-container/session-config/session-manager/session-properties/property[@name='maxInactiveInterval']";
    private static Logger _logger = null;

    public ServerConfigLookup() {
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
        }
    }

    public PersistenceType getPersistenceTypeFromConfig() {
        _logger.finest("in ServerConfigLookup>>getPersistenceTypeFromConfig");
        String string = null;
        PersistenceType persistenceType = null;
        SessionManager sessionManager = this.getInstanceSessionManager();
        if (sessionManager != null) {
            string = sessionManager.getPersistenceType();
        }
        if (string != null) {
            persistenceType = PersistenceType.parseType(string);
        }
        if (persistenceType != null) {
            _logger.finest("SERVER.XML persistenceType= " + persistenceType.getType());
        } else {
            _logger.finest("SERVER.XML persistenceType missing");
        }
        return persistenceType;
    }

    public String getPersistenceFrequencyFromConfig() {
        _logger.finest("in ServerConfigLookup>>getPersistenceFrequencyFromConfig");
        return this.getServerConfigValue("/server/web-container/session-config/session-manager/manager-properties/property[@name='persistenceFrequency']", null);
    }

    public String getPersistenceScopeFromConfig() {
        _logger.finest("in ServerConfigLookup>>getPersistenceScopeFromConfig");
        return this.getServerConfigValue("/server/web-container/session-config/session-manager/store-properties/property[@name='persistenceScope']", null);
    }

    public String getClusterIdFromConfig() {
        _logger.finest("in ServerConfigLookup>>getClusterIdFromConfig");
        return this.getServerConfigValue("/server/availability-service/persistence-store/property[@name='cluster-id']", "cluster1");
    }

    public boolean getAvailabilityEnabledFromConfig(Server server) {
        AvailabilityService availabilityService = server.getAvailabilityService();
        boolean bl = availabilityService.isAvailabilityEnabled();
        System.out.println("ServerConfigLookup : AvailabilityGloballyEnabled = " + bl);
        return bl;
    }

    public boolean getAvailabilityEnabledFromConfig() {
        _logger.finest("in ServerConfigLookup>>getAvailabilityEnabledFromConfig");
        AvailabilityService availabilityService = this.getAvailabilityService();
        if (availabilityService == null) {
            return false;
        }
        return availabilityService.isAvailabilityEnabled();
    }

    public AvailabilityService getAvailabilityService() {
        ServerContext serverContext = ApplicationServer.getServerContext();
        ConfigContext configContext = serverContext.getConfigContext();
        AvailabilityService availabilityService = null;
        try {
            availabilityService = ((Server)configContext.getRootConfigBean()).getAvailabilityService();
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        return availabilityService;
    }

    public String getHaStorePoolJndiNameFromConfig() {
        String string = "jdbc/hastore";
        String string2 = this.getServerConfigValue("/server/availability-service/persistence-store/property[@name='store-pool-jndi-name']", string);
        if (string2.trim().length() < 1) {
            string2 = string;
        }
        return string2;
    }

    public String getConnectionURLFromConfigPrevious() {
        return this.getServerConfigValue("/server/availability-service/persistence-store/property[@name='hadb-connection-url']", null);
    }

    public String getConnectionUserFromConfigPrevious() {
        return this.getServerConfigValue("/server/availability-service/persistence-store/property[@name='hadb-connection-user']", "system");
    }

    public String getConnectionPasswordFromConfigPrevious() {
        return this.getServerConfigValue("/server/availability-service/persistence-store/property[@name='hadb-connection-passwd']", "super");
    }

    public String getEEBuilderPathFromConfig() {
        return this.getServerConfigValue("/server/availability-service/persistence-store/property[@name='ee-builder-path']", "com.sun.appserv.ee.web.initialization");
    }

    private String getUuidGeneratorImplClassFromConfig() {
        return this.getServerConfigValue("/server/availability-service/persistence-store/property[@name='uuid-impl-class']", "com.sun.appserv.util.UuidGeneratorImpl");
    }

    public UuidGenerator getUuidGeneratorFromConfig() {
        UuidGenerator uuidGenerator = new UuidGeneratorImpl();
        String string = this.getUuidGeneratorImplClassFromConfig();
        try {
            uuidGenerator = (UuidGenerator)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uuidGenerator;
    }

    public String getServerConfigValue(String string, String string2) {
        _logger.finest("in ServerConfigLookup>>getServerConfigValue:xpath=" + string + " defaultValue= " + string2);
        ServerContext serverContext = ApplicationServer.getServerContext();
        if (serverContext == null) {
            return string2;
        }
        ConfigContext configContext = serverContext.getConfigContext();
        ConfigBean configBean = null;
        String string3 = null;
        String string4 = string2;
        try {
            configBean = configContext.exactLookup(string);
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        if (configBean != null) {
            string3 = configBean.getAttributeValue("value");
        }
        if (string3 != null) {
            string4 = string3;
        }
        _logger.finest("RETURNED CONFIG VALUE FOR XPATH:" + string + " = " + string4);
        return string4;
    }

    public int getServerConfigValue(String string, int n) {
        _logger.finest("in getServerConfigValue:xpath=" + string + " defaultValue= " + n);
        ServerContext serverContext = ApplicationServer.getServerContext();
        ConfigContext configContext = serverContext.getConfigContext();
        ConfigBean configBean = null;
        String string2 = null;
        int n2 = n;
        try {
            configBean = configContext.exactLookup(string);
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        if (configBean != null) {
            string2 = configBean.getAttributeValue("value");
        }
        if (string2 != null) {
            try {
                n2 = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                _logger.finest("Using Default Value = " + n);
            }
        }
        _logger.finest("RETURNED CONFIG VALUE FOR XPATH:" + string + " = " + n2);
        return n2;
    }

    public SessionManager getInstanceSessionManager() {
        ServerContext serverContext = ApplicationServer.getServerContext();
        ConfigContext configContext = serverContext.getConfigContext();
        SessionManager sessionManager = null;
        try {
            sessionManager = (SessionManager)configContext.exactLookup("/server/web-container/session-config/session-manager");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        return sessionManager;
    }

    public SessionProperties getInstanceSessionProperties() {
        ServerContext serverContext = ApplicationServer.getServerContext();
        ConfigContext configContext = serverContext.getConfigContext();
        SessionProperties sessionProperties = null;
        try {
            sessionProperties = (SessionProperties)configContext.exactLookup("/server/web-container/session-config/session-properties");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        return sessionProperties;
    }

    public String getConnectionUserFromConfig() {
        String string = null;
        JdbcConnectionPool jdbcConnectionPool = this.getHadbJdbcConnectionPoolFromConfig();
        if (jdbcConnectionPool == null) {
            return null;
        }
        if (jdbcConnectionPool.sizeElementProperty() > 0) {
            ElementProperty[] elementPropertyArray = jdbcConnectionPool.getElementProperty();
            for (int i = 0; i < elementPropertyArray.length; ++i) {
                String string2 = elementPropertyArray[i].getAttributeValue("name");
                String string3 = elementPropertyArray[i].getAttributeValue("value");
                if (!string2.equalsIgnoreCase("username")) continue;
                string = string3;
            }
        }
        _logger.finest("IN NEW getConnectionUserFromConfig: user=" + string);
        return string;
    }

    public String getConnectionPasswordFromConfig() {
        String string = null;
        JdbcConnectionPool jdbcConnectionPool = this.getHadbJdbcConnectionPoolFromConfig();
        if (jdbcConnectionPool == null) {
            return null;
        }
        if (jdbcConnectionPool.sizeElementProperty() > 0) {
            ElementProperty[] elementPropertyArray = jdbcConnectionPool.getElementProperty();
            for (int i = 0; i < elementPropertyArray.length; ++i) {
                String string2 = elementPropertyArray[i].getAttributeValue("name");
                String string3 = elementPropertyArray[i].getAttributeValue("value");
                if (!string2.equalsIgnoreCase("password")) continue;
                string = string3;
            }
        }
        _logger.finest("IN NEW getConnectionPasswordFromConfig: password=" + string);
        return string;
    }

    public String getConnectionURLFromConfig() {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        JdbcConnectionPool jdbcConnectionPool = this.getHadbJdbcConnectionPoolFromConfig();
        if (jdbcConnectionPool == null) {
            return null;
        }
        if (jdbcConnectionPool.sizeElementProperty() > 0) {
            ElementProperty[] elementPropertyArray = jdbcConnectionPool.getElementProperty();
            for (int i = 0; i < elementPropertyArray.length; ++i) {
                String string2 = elementPropertyArray[i].getAttributeValue("name");
                String string3 = elementPropertyArray[i].getAttributeValue("value");
                if (!string2.equalsIgnoreCase("serverList")) continue;
                stringBuffer.append("jdbc:sun:hadb:");
                stringBuffer.append(string3);
                string = stringBuffer.toString();
            }
        }
        _logger.finest("IN NEW getConnectionURLFromConfig: url=" + string);
        return string;
    }

    public String getConnectionURLFromConfigForOracle() {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        JdbcConnectionPool jdbcConnectionPool = this.getHadbJdbcConnectionPoolFromConfig();
        if (jdbcConnectionPool == null) {
            return null;
        }
        if (jdbcConnectionPool.sizeElementProperty() > 0) {
            ElementProperty[] elementPropertyArray = jdbcConnectionPool.getElementProperty();
            for (int i = 0; i < elementPropertyArray.length; ++i) {
                String string2 = elementPropertyArray[i].getAttributeValue("name");
                String string3 = elementPropertyArray[i].getAttributeValue("value");
                if (!string2.equalsIgnoreCase("URL")) continue;
                stringBuffer.append(string3);
                string = stringBuffer.toString();
            }
        }
        _logger.finest("IN NEW getConnectionURLFromConfig: url=" + string);
        return string;
    }

    public JdbcConnectionPool getHadbJdbcConnectionPoolFromConfig() {
        String string = this.getHaStorePoolJndiNameFromConfig();
        if (string == null) {
            return null;
        }
        ServerContext serverContext = ApplicationServer.getServerContext();
        ConfigContext configContext = serverContext.getConfigContext();
        Server server = null;
        try {
            server = (Server)configContext.exactLookup("/server");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        if (server == null) {
            return null;
        }
        Resources resources = server.getResources();
        JdbcResource jdbcResource = resources.getJdbcResourceByJndiName(string);
        if (jdbcResource == null) {
            return null;
        }
        String string2 = jdbcResource.getPoolName();
        JdbcConnectionPool jdbcConnectionPool = resources.getJdbcConnectionPoolByName(string2);
        return jdbcConnectionPool;
    }

    public String getHadbJdbcConnectionPoolNameFromConfig() {
        String string = this.getHaStorePoolJndiNameFromConfig();
        if (string == null) {
            return null;
        }
        ServerContext serverContext = ApplicationServer.getServerContext();
        ConfigContext configContext = serverContext.getConfigContext();
        Server server = null;
        try {
            server = (Server)configContext.exactLookup("/server");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        if (server == null) {
            return null;
        }
        Resources resources = server.getResources();
        JdbcResource jdbcResource = resources.getJdbcResourceByJndiName(string);
        if (jdbcResource == null) {
            return null;
        }
        String string2 = jdbcResource.getPoolName();
        return string2;
    }
}

