/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web;

import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.VirtualServer;
import com.iplanet.ias.web.ServerConfigLookup;
import com.iplanet.ias.web.SingleSignOnFactory;
import org.apache.catalina.authenticator.SingleSignOn;

public abstract class SSOFactory {
    public static final String SSO_FAILOVER_ENABLED = "sso-failover-enabled";
    protected static final String SSO_EE_FACTORY = "com.sun.appserv.ee.web.initialization.HASingleSignOnFactory";

    public static SSOFactory getInstance(VirtualServer virtualServer) {
        SSOFactory sSOFactory = new SingleSignOnFactory();
        if (SSOFactory.getAvailabilityEnabled()) {
            try {
                sSOFactory = (SSOFactory)Class.forName(SSO_EE_FACTORY).newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return sSOFactory;
    }

    private static boolean isSSOFailoverEnabled(VirtualServer virtualServer) {
        ElementProperty elementProperty = virtualServer.getElementPropertyByName(SSO_FAILOVER_ENABLED);
        if (elementProperty != null && elementProperty.getValue() != null && ConfigBean.toBoolean(elementProperty.getValue())) {
            System.out.println("SSOFactory.isSSOFailoverEnabled SSO() Failover is enabled");
            return true;
        }
        System.out.println("SSOFactory.isSSOFailoverEnabled() SSO Failover is Disabled");
        return false;
    }

    private static boolean getAvailabilityEnabled() {
        ServerConfigLookup serverConfigLookup = new ServerConfigLookup();
        boolean bl = serverConfigLookup.getAvailabilityEnabledFromConfig();
        return bl;
    }

    public abstract SingleSignOn createSingleSignOnValve();
}

