/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web;

import com.iplanet.ias.web.ServerConfigLookup;
import com.iplanet.ias.web.ShutdownCleanupCapable;
import com.iplanet.ias.web.WebContainer;
import com.iplanet.ias.web.WebModule;
import com.sun.enterprise.Switch;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Manager;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;

public class ConnectionShutdownUtil {
    private Hashtable _instances = null;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private WebContainer webContainer = null;

    public ConnectionShutdownUtil() {
    }

    public ConnectionShutdownUtil(Hashtable hashtable) {
        this._instances = hashtable;
    }

    public String getApplicationId(Context context) {
        WebModule webModule = (WebModule)context;
        return webModule.getID();
    }

    public String getApplicationName(Context context) {
        return context.getName();
    }

    public ArrayList runGetShutdownCapables() {
        _logger.finest("IN ConnectionShutdownUtil:runGetShutdownCapables");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this._instances == null) {
            _logger.log(Level.SEVERE, "GetShutdownCapables:: No containers available");
            return arrayList;
        }
        try {
            Enumeration enumeration = this._instances.elements();
            if (null == enumeration) {
                _logger.log(Level.SEVERE, "GetShutdownCapables:: No containers available");
                return arrayList;
            }
            while (enumeration.hasMoreElements()) {
                this.webContainer = (WebContainer)enumeration.nextElement();
                Engine engine = this.webContainer.privateGetEngine();
                Container[] containerArray = engine.findChildren();
                for (int i = 0; i < containerArray.length; ++i) {
                    Object object;
                    Container container = containerArray[i];
                    Container[] containerArray2 = container.findChildren();
                    for (int j = 0; j < containerArray2.length; ++j) {
                        Container container2 = containerArray2[j];
                        object = (Context)container2;
                        String string = this.getApplicationId((Context)object);
                        Manager manager = container2.getManager();
                        if (!(manager instanceof ShutdownCleanupCapable)) continue;
                        _logger.finest("found a shutdown capable manager:" + manager.getClass().getName());
                        arrayList.add(manager);
                    }
                    _logger.finest("1) shutdownCapablesList Size = " + arrayList.size());
                    Valve[] valveArray = ((ContainerBase)container).getValves();
                    for (int j = 0; j < valveArray.length; ++j) {
                        object = valveArray[j];
                        _logger.finest("VALVE = " + object.getClass().getName());
                        if (!(object instanceof ShutdownCleanupCapable)) continue;
                        _logger.finest("found a shutdown capable valve");
                        arrayList.add(object);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            _logger.log(Level.SEVERE, "Exception thrown", throwable);
        }
        _logger.finest("1) shutdownCapablesList Size = " + arrayList.size());
        return arrayList;
    }

    public ArrayList runGetShutdownCapablesForAppName(String string) {
        _logger.finest("IN ConnectionShutdownUtil:runGetShutdownCapablesForAppName");
        ArrayList<Manager> arrayList = new ArrayList<Manager>();
        try {
            Enumeration enumeration = this._instances.elements();
            if (null == enumeration) {
                _logger.log(Level.SEVERE, "SHUTDOWN:: No containers available to report monitoring stats");
                return arrayList;
            }
            while (enumeration.hasMoreElements()) {
                this.webContainer = (WebContainer)enumeration.nextElement();
                Engine engine = this.webContainer.privateGetEngine();
                Container[] containerArray = engine.findChildren();
                for (int i = 0; i < containerArray.length; ++i) {
                    Container container = containerArray[i];
                    Container[] containerArray2 = container.findChildren();
                    for (int j = 0; j < containerArray2.length; ++j) {
                        Container container2 = containerArray2[j];
                        Context context = (Context)container2;
                        String string2 = this.getApplicationName(context);
                        Manager manager = container2.getManager();
                        if (!(manager instanceof ShutdownCleanupCapable) || !string2.equals(string)) continue;
                        _logger.finest("found a shutdown capable manager:" + manager.getClass().getName());
                        arrayList.add(manager);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            _logger.log(Level.SEVERE, "Exception thrown", throwable);
        }
        _logger.finest("1) shutdownCapablesList Size = " + arrayList.size());
        return arrayList;
    }

    public void runShutdownCleanupFromShutdownCleanupCapableList(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            ShutdownCleanupCapable shutdownCleanupCapable = (ShutdownCleanupCapable)arrayList.get(i);
            shutdownCleanupCapable.doShutdownCleanup();
        }
    }

    public void runCloseAllConnections() {
        ArrayList arrayList = this.runGetShutdownCapables();
        this.runShutdownCleanupFromShutdownCleanupCapableList(arrayList);
    }

    public void runCloseCachedConnectionForApp(String string) {
        ArrayList arrayList = this.runGetShutdownCapablesForAppName(string);
        this.runCloseCachedConnectionFromShutdownCleanupCapableList(arrayList, string);
    }

    public void runCloseCachedConnectionFromShutdownCleanupCapableList(ArrayList arrayList, String string) {
        for (int i = 0; i < arrayList.size(); ++i) {
            ShutdownCleanupCapable shutdownCleanupCapable = (ShutdownCleanupCapable)arrayList.get(i);
            shutdownCleanupCapable.doCloseCachedConnection();
        }
    }

    public void clearoutJDBCPool() {
        String string = this.getHadbJdbcConnectionPoolNameFromConfig();
        if (string == null) {
            return;
        }
        ResourceSpec resourceSpec = new ResourceSpec(string, 1);
        if (resourceSpec == null) {
            return;
        }
        Switch.getSwitch().getPoolManager().emptyResourcePool(resourceSpec);
        resourceSpec = new ResourceSpec(string, 0);
        if (resourceSpec == null) {
            return;
        }
        Switch.getSwitch().getPoolManager().emptyResourcePool(resourceSpec);
    }

    private String getHadbJdbcConnectionPoolNameFromConfig() {
        ServerConfigLookup serverConfigLookup = new ServerConfigLookup();
        return serverConfigLookup.getHadbJdbcConnectionPoolNameFromConfig();
    }
}

