/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web;

import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.ManagerProperties;
import com.iplanet.ias.config.serverbeans.SessionProperties;
import com.iplanet.ias.tools.common.dd.webapp.SessionManager;
import com.iplanet.ias.tools.common.dd.webapp.WebProperty;
import com.iplanet.ias.web.PersistenceStrategyBuilder;
import com.iplanet.ias.web.ServerConfigLookup;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Context;
import org.apache.catalina.core.StandardContext;

public abstract class BasePersistenceStrategyBuilder
implements PersistenceStrategyBuilder {
    protected Logger _logger = null;
    protected String directory = null;
    protected String sessionFilename = null;
    protected String _persistenceFrequency = null;
    protected String _persistenceScope = null;
    protected int maxSessions = -1;
    protected final int DEFAULT_REAP_INTERVAL = 60;
    protected int reapInterval = 60;
    protected int storeReapInterval = 60;
    protected final int DEFAULT_SESSION_TIMEOUT = 1800;
    protected int sessionMaxInactiveInterval = 1800;

    public BasePersistenceStrategyBuilder(Logger logger) {
        this._logger = logger;
    }

    public BasePersistenceStrategyBuilder() {
    }

    public void initializePersistenceStrategy(Context context, SessionManager sessionManager) {
        this.setDefaultParams(context, sessionManager);
        this.readInstanceLevelParams();
        this.readWebAppParams(context, sessionManager);
    }

    public void setDefaultParams(Context context, SessionManager sessionManager) {
        this.reapInterval = 60;
        this.maxSessions = -1;
        this.sessionFilename = null;
        this.storeReapInterval = 60;
        this.directory = ((StandardContext)context).getWorkDir();
    }

    public void readInstanceLevelParams() {
        Object[] objectArray;
        String string;
        int n;
        ElementProperty[] elementPropertyArray;
        ConfigBean configBean;
        ServerConfigLookup serverConfigLookup = new ServerConfigLookup();
        com.iplanet.ias.config.serverbeans.SessionManager sessionManager = serverConfigLookup.getInstanceSessionManager();
        if (sessionManager != null) {
            configBean = sessionManager.getManagerProperties();
            if (configBean != null && ((ManagerProperties)configBean).sizeElementProperty() > 0) {
                elementPropertyArray = ((ManagerProperties)configBean).getElementProperty();
                for (n = 0; n < elementPropertyArray.length; ++n) {
                    String string2 = elementPropertyArray[n].getAttributeValue("name");
                    string = elementPropertyArray[n].getAttributeValue("value");
                    if (string2.equalsIgnoreCase("reapIntervalSeconds")) {
                        try {
                            this.reapInterval = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (string2.equalsIgnoreCase("maxSessions")) {
                        try {
                            this.maxSessions = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (string2.equalsIgnoreCase("sessionFilename")) {
                        this.sessionFilename = string;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("persistenceFrequency")) {
                        this._persistenceFrequency = string;
                        continue;
                    }
                    objectArray = new Object[]{string2};
                    this._logger.log(Level.INFO, "webcontainer.notYet", objectArray);
                }
            }
            if ((elementPropertyArray = sessionManager.getStoreProperties()) != null && elementPropertyArray.sizeElementProperty() > 0) {
                ElementProperty[] elementPropertyArray2 = elementPropertyArray.getElementProperty();
                for (int i = 0; i < elementPropertyArray2.length; ++i) {
                    string = elementPropertyArray2[i].getAttributeValue("name");
                    objectArray = elementPropertyArray2[i].getAttributeValue("value");
                    if (string.equalsIgnoreCase("reapIntervalSeconds")) {
                        try {
                            this.storeReapInterval = Integer.parseInt((String)objectArray);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (string.equalsIgnoreCase("directory")) {
                        this.directory = objectArray;
                        continue;
                    }
                    if (string.equalsIgnoreCase("persistenceScope")) {
                        this._persistenceScope = objectArray;
                        continue;
                    }
                    Object[] objectArray2 = new Object[]{string};
                    this._logger.log(Level.INFO, "webcontainer.notYet", objectArray2);
                }
            }
        }
        if ((configBean = serverConfigLookup.getInstanceSessionProperties()) != null && ((SessionProperties)configBean).sizeElementProperty() > 0) {
            elementPropertyArray = ((SessionProperties)configBean).getElementProperty();
            for (n = 0; n < elementPropertyArray.length; ++n) {
                String string3 = elementPropertyArray[n].getAttributeValue("name");
                string = elementPropertyArray[n].getAttributeValue("value");
                if (string3.equalsIgnoreCase("timeoutSeconds")) {
                    try {
                        this.sessionMaxInactiveInterval = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                objectArray = new Object[]{string3};
                this._logger.log(Level.INFO, "webcontainer.notYet", objectArray);
            }
        }
    }

    public void readWebAppParams(Context context, SessionManager sessionManager) {
        if (sessionManager != null) {
            Object[] objectArray;
            String string;
            WebProperty[] webPropertyArray;
            com.iplanet.ias.tools.common.dd.webapp.ManagerProperties managerProperties = sessionManager.getManagerProperties();
            if (managerProperties != null && managerProperties.sizeWebProperty() > 0) {
                webPropertyArray = managerProperties.getWebProperty();
                for (int i = 0; i < webPropertyArray.length; ++i) {
                    String string2 = webPropertyArray[i].getAttributeValue("name");
                    string = webPropertyArray[i].getAttributeValue("value");
                    if (string2.equalsIgnoreCase("reapIntervalSeconds")) {
                        try {
                            this.reapInterval = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (string2.equalsIgnoreCase("maxSessions")) {
                        try {
                            this.maxSessions = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (string2.equalsIgnoreCase("sessionFilename")) {
                        this.sessionFilename = string;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("persistenceFrequency")) {
                        this._persistenceFrequency = string;
                        continue;
                    }
                    objectArray = new Object[]{string2};
                    this._logger.log(Level.INFO, "webcontainer.notYet", objectArray);
                }
            }
            if ((webPropertyArray = sessionManager.getStoreProperties()) != null && webPropertyArray.sizeWebProperty() > 0) {
                WebProperty[] webPropertyArray2 = webPropertyArray.getWebProperty();
                for (int i = 0; i < webPropertyArray2.length; ++i) {
                    string = webPropertyArray2[i].getAttributeValue("name");
                    objectArray = webPropertyArray2[i].getAttributeValue("value");
                    if (string.equalsIgnoreCase("reapIntervalSeconds")) {
                        try {
                            this.storeReapInterval = Integer.parseInt((String)objectArray);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (string.equalsIgnoreCase("directory")) {
                        this.directory = objectArray;
                        continue;
                    }
                    if (string.equalsIgnoreCase("persistenceScope")) {
                        this._persistenceScope = objectArray;
                        continue;
                    }
                    Object[] objectArray2 = new Object[]{string};
                    this._logger.log(Level.INFO, "webcontainer.notYet", objectArray2);
                }
            }
        }
    }

    protected String prependContextPathTo(String string, Context context) {
        if (string == null) {
            return string;
        }
        String string2 = this.getFilePartOf(string);
        if (string2 == null || string2.equals("")) {
            return null;
        }
        String string3 = this.stripNonAlphaNumerics(context.getPath());
        String string4 = string3 + string2;
        int n = string.lastIndexOf("/");
        String string5 = null;
        if (n == -1) {
            string5 = string4;
        } else {
            String string6 = string.substring(0, n);
            string5 = string6 + "/" + string4;
        }
        return string5;
    }

    protected String getFilePartOf(String string) {
        if (string == null) {
            return string;
        }
        int n = string.lastIndexOf("/");
        String string2 = null;
        string2 = n == -1 ? this.stripNonAlphaNumerics(string) : this.stripNonAlphaNumerics(string.substring(n + 1, string.length()));
        return string2;
    }

    protected String stripNonAlphas(String string) {
        StringBuffer stringBuffer = new StringBuffer(50);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isLetter(c)) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    protected String stripNonAlphaNumerics(String string) {
        StringBuffer stringBuffer = new StringBuffer(50);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isLetterOrDigit(c)) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    public String getPersistenceFrequency() {
        return this._persistenceFrequency;
    }

    public void setPersistenceFrequency(String string) {
        this._persistenceFrequency = string;
    }

    public String getPersistenceScope() {
        return this._persistenceScope;
    }

    public void setPersistenceScope(String string) {
        this._persistenceScope = string;
    }
}

