/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.threadpool;

import com.iplanet.ias.util.MonitorTask;
import com.iplanet.ias.util.collection.QueueClosedException;
import com.iplanet.ias.util.collection.TimedOutException;
import com.iplanet.ias.util.collection.TooManyTasksException;
import com.iplanet.ias.util.threadpool.Servicable;
import com.iplanet.ias.util.threadpool.TaskFactory;
import com.iplanet.ias.util.threadpool.TaskQueue;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FastThreadPool {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    protected boolean bDebug = false;
    private PoolProperties poolProps;
    private TaskQueue taskQueue;
    private int waitCount = 0;
    private int totalThreadCreatedCount = 0;
    private int totalThreadDestroyedCount = 0;
    private int numMessages = 0;

    public FastThreadPool(String string, int n, int n2, long l, int n3, TaskFactory taskFactory) {
        this(new ThreadGroup(string), n, n2, l, new TaskQueue(n3, taskFactory));
    }

    public FastThreadPool(ThreadGroup threadGroup, int n, int n2, long l, int n3, TaskFactory taskFactory) {
        this(threadGroup, n, n2, l, new TaskQueue(n3, taskFactory));
    }

    public FastThreadPool(ThreadGroup threadGroup, int n, int n2, long l, TaskQueue taskQueue) {
        this.taskQueue = taskQueue;
        this.poolProps = new PoolProperties(n, n2, l, this.taskQueue, threadGroup);
    }

    public void start() {
        this.poolProps.createdCount = this.poolProps.minThreadCount;
        for (int i = 0; i < this.poolProps.minThreadCount; ++i) {
            new ThreadPoolThread(this.poolProps);
        }
        MonitorTask.addORBMonitorable(this);
    }

    public TaskQueue getTaskQueue() {
        return this.taskQueue;
    }

    public boolean setTaskQueue(TaskQueue taskQueue) {
        if (this.taskQueue != null) {
            return false;
        }
        this.taskQueue = taskQueue;
        return true;
    }

    public void addFirst(Servicable servicable) throws TooManyTasksException, QueueClosedException {
        this.taskQueue.addFirst(servicable);
    }

    public void addLast(Servicable servicable) throws TooManyTasksException, QueueClosedException {
        this.taskQueue.addLast(servicable);
    }

    public void add(int n, Servicable servicable) throws TooManyTasksException, QueueClosedException {
        this.taskQueue.add(n, servicable);
    }

    public void shutdown() {
        this.taskQueue.shutdown();
    }

    public void abort() {
        this.taskQueue.abort();
    }

    public int getPoolSize() {
        return this.poolProps != null ? this.poolProps.createdCount : -1;
    }

    public int getWaitCount() {
        return this.waitCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getMonitoredValues() {
        PoolProperties poolProperties = this.poolProps;
        synchronized (poolProperties) {
            int[] nArray = new int[]{this.poolProps != null ? this.poolProps.createdCount : -1, this.waitCount};
            return nArray;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FastThreadPool [CS=").append(this.poolProps.createdCount);
        stringBuffer.append(", TC=").append(this.totalThreadCreatedCount);
        stringBuffer.append(", TD=").append(this.totalThreadDestroyedCount);
        stringBuffer.append(", Min=").append(this.poolProps.minThreadCount);
        stringBuffer.append(", Max=").append(this.poolProps.maxThreadCount);
        stringBuffer.append(", MaxIdle=").append(this.poolProps.maxIdleTime);
        stringBuffer.append(", Msgs=").append(this.numMessages);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private class ThreadPoolThread
    implements Runnable {
        PoolProperties poolProps;

        ThreadPoolThread(PoolProperties poolProperties) {
            this.poolProps = poolProperties;
            Thread thread = new Thread(poolProperties.threadGroup, this);
            if (poolProperties.threadGroup != null && poolProperties.threadGroup.isDaemon()) {
                thread.setDaemon(true);
            }
            thread.start();
            FastThreadPool.this.totalThreadCreatedCount++;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Servicable servicable = null;
            try {
                while (true) {
                    boolean bl = false;
                    do {
                        PoolProperties poolProperties = this.poolProps;
                        synchronized (poolProperties) {
                            FastThreadPool.this.waitCount++;
                        }
                        servicable = null;
                        try {
                            servicable = (Servicable)FastThreadPool.this.taskQueue.remove(this.poolProps.maxIdleTime);
                            poolProperties = this.poolProps;
                            synchronized (poolProperties) {
                                FastThreadPool.this.waitCount--;
                                boolean bl2 = bl = FastThreadPool.this.waitCount == 0 && this.poolProps.createdCount < this.poolProps.maxThreadCount;
                                if (bl) {
                                    ++this.poolProps.createdCount;
                                }
                                FastThreadPool.this.numMessages++;
                            }
                        }
                        catch (TimedOutException timedOutException) {
                            PoolProperties poolProperties2 = this.poolProps;
                            synchronized (poolProperties2) {
                                if (this.poolProps.createdCount > this.poolProps.minThreadCount) {
                                    --this.poolProps.createdCount;
                                    FastThreadPool.this.totalThreadDestroyedCount++;
                                    return;
                                }
                                continue;
                            }
                        }
                        if (bl) {
                            new ThreadPoolThread(this.poolProps);
                        }
                        try {
                            servicable.prolog();
                            servicable.service();
                            servicable.epilog();
                        }
                        catch (Throwable throwable) {
                            _logger.log(Level.SEVERE, "iplanet_util.generic_exception", throwable);
                        }
                    } while (servicable != null);
                }
            }
            catch (QueueClosedException queueClosedException) {
                _logger.log(Level.FINE, "Queue closed. Exitting....");
                PoolProperties poolProperties = this.poolProps;
                synchronized (poolProperties) {
                    --this.poolProps.createdCount;
                }
                FastThreadPool.this.totalThreadDestroyedCount++;
                return;
            }
            catch (InterruptedException interruptedException) {
                _logger.log(Level.SEVERE, "iplanet_util.generic_exception", interruptedException);
                PoolProperties poolProperties = this.poolProps;
                synchronized (poolProperties) {
                    --this.poolProps.createdCount;
                }
                FastThreadPool.this.totalThreadDestroyedCount++;
                return;
            }
        }
    }

    private class PoolProperties {
        int minThreadCount;
        int maxThreadCount;
        long maxIdleTime;
        TaskQueue taskQueue;
        ThreadGroup threadGroup;
        int createdCount;

        PoolProperties(int n, int n2, long l, TaskQueue taskQueue, ThreadGroup threadGroup) {
            this.minThreadCount = n;
            this.maxThreadCount = n2;
            this.maxIdleTime = l;
            this.taskQueue = taskQueue;
            this.threadGroup = threadGroup;
            this.createdCount = 0;
        }
    }
}

