/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.sync;

import com.iplanet.ias.util.pool.TimedoutException;

public class Lock {
    private Thread owner = null;
    private int lockCount = 0;

    public synchronized void acquireLock() throws InterruptedException {
        while (!this.tryGetLock()) {
            this.wait();
        }
    }

    public synchronized void acquireLock(long l) throws InterruptedException, TimedoutException {
        if (!this.tryGetLock() && l != 0L) {
            if (l == -1L) {
                while (!this.tryGetLock()) {
                    this.wait();
                }
            } else {
                boolean bl = true;
                long l2 = System.currentTimeMillis();
                long l3 = l;
                while (bl) {
                    this.wait(l3);
                    if (this.tryGetLock()) {
                        return;
                    }
                    l3 = l2 + l - System.currentTimeMillis();
                    bl = l3 > 0L;
                }
                throw new TimedoutException();
            }
        }
    }

    private boolean tryGetLock() {
        Thread thread = Thread.currentThread();
        if (this.owner == null) {
            this.owner = thread;
            this.lockCount = 1;
            return true;
        }
        if (this.owner == thread) {
            ++this.lockCount;
            return true;
        }
        return false;
    }

    public synchronized void releaseLock() {
        if (!this.owner.equals(Thread.currentThread())) {
            throw new IllegalMonitorStateException();
        }
        if (--this.lockCount == 0) {
            this.owner = null;
            this.notify();
        }
    }

    public synchronized boolean isLocked() {
        return this.owner != null;
    }

    public Thread getOwner() {
        return this.owner;
    }
}

