/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.pool.test;

import com.iplanet.ias.util.collection.FastStack;
import com.iplanet.ias.util.pool.BoundedPool;
import com.iplanet.ias.util.pool.ObjectFactory;
import com.iplanet.ias.util.pool.PoolProperties;

public class PoolTest {
    public static void main(String[] stringArray) throws Exception {
        FastStack fastStack = new FastStack();
        PoolProperties poolProperties = new PoolProperties();
        poolProperties.setInitialSize(2);
        poolProperties.setMinimumSize(4);
        poolProperties.setMaxStrongRefs(7);
        poolProperties.setLowWaterMark(5);
        poolProperties.setHiWaterMark(10);
        poolProperties.setPoolLimit(15);
        poolProperties.setMaxIdleTime(10000L);
        ObjectFactory objectFactory = new ObjectFactory(){
            private int count = 0;

            public Object create(long l) {
                return new byte[100000];
            }

            public Object create(Object object) {
                return new byte[100000];
            }

            public Object create() {
                return new byte[100000];
            }

            public void destroy(Object object) {
            }
        };
        BoundedPool boundedPool = new BoundedPool(objectFactory, 0, 100, 360000L, 0);
        long l = System.currentTimeMillis();
        for (int i = 0; i < 15; ++i) {
            fastStack.push(boundedPool.getObject(true, null));
        }
        long l2 = System.currentTimeMillis();
        System.in.read();
        for (int i = 0; i < 15; ++i) {
            boundedPool.returnObject(fastStack.pop());
        }
        System.out.println("get/put took: " + (double)(l2 - l) / 1000.0);
        System.in.read();
        System.in.read();
        System.in.read();
        System.in.read();
        System.in.read();
    }
}

