/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.pool;

import java.util.Properties;

public class PoolProperties {
    public static final String FACTORY_CLASS_NAME = "pool.factory.class";
    public static final String MINIMUM_SIZE = "pool.minsize";
    public static final String INITIAL_SIZE = "pool.initialsize";
    public static final String LOW_WATER_MARK = "pool.lowwatermark";
    public static final String HI_WATER_MARK = "pool.hiwatermark";
    public static final String MAX_STRONG_REFERENCES = "pool.maxstrongrefs";
    public static final String POOL_LIMIT = "pool.limit";
    public static final String MAX_IDLE_TIME = "pool.maxidletime";
    public long key;
    public String factoryClassName;
    public int minimumSize;
    public int initialSize;
    public int lowWaterMark;
    public int hiWaterMark;
    public int maxStrongRefs;
    public int poolLimit;
    public long maxIdleTime;

    public PoolProperties() {
    }

    public PoolProperties(int n, int n2) {
        this.minimumSize = n;
        this.poolLimit = n2;
    }

    public PoolProperties(Properties properties) {
        this.factoryClassName = properties.getProperty(FACTORY_CLASS_NAME);
        this.minimumSize = this.getIntProperty(properties, MINIMUM_SIZE, 0);
        this.initialSize = this.getIntProperty(properties, INITIAL_SIZE, 0);
        this.lowWaterMark = this.getIntProperty(properties, LOW_WATER_MARK, 0);
        this.hiWaterMark = this.getIntProperty(properties, HI_WATER_MARK, 0);
        this.poolLimit = this.getIntProperty(properties, POOL_LIMIT, 0);
        this.maxIdleTime = this.getLongProperty(properties, MAX_IDLE_TIME, 60000L);
    }

    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    public void setFactoryClassName(String string) {
        this.factoryClassName = string;
    }

    public int getMinimumSize() {
        return this.minimumSize;
    }

    public void setMinimumSize(int n) {
        this.minimumSize = n;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int n) {
        this.initialSize = n;
    }

    public int getLowWaterMark() {
        return this.lowWaterMark;
    }

    public void setLowWaterMark(int n) {
        this.lowWaterMark = n;
    }

    public int getHiWaterMark() {
        return this.hiWaterMark;
    }

    public void setHiWaterMark(int n) {
        this.hiWaterMark = n;
    }

    public int getMaxStrongRefs() {
        return this.maxStrongRefs;
    }

    public void setMaxStrongRefs(int n) {
        this.maxStrongRefs = n;
    }

    public int getPoolLimit() {
        return this.poolLimit;
    }

    public void setPoolLimit(int n) {
        this.poolLimit = n;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(long l) {
        this.maxIdleTime = l;
    }

    private int getIntProperty(Properties properties, String string, int n) {
        try {
            return Integer.parseInt(properties.getProperty(string));
        }
        catch (Throwable throwable) {
            return n;
        }
    }

    private long getLongProperty(Properties properties, String string, long l) {
        try {
            return Long.parseLong(properties.getProperty(string));
        }
        catch (Throwable throwable) {
            return l;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("key: ").append(this.key).append("; min: ").append(this.minimumSize).append("; init: ").append(this.initialSize).append("; lowWM: ").append(this.lowWaterMark).append("; hiWM: ").append(this.hiWaterMark).append("; maxSRefs: ").append(this.maxStrongRefs).append("; limit: ").append(this.poolLimit);
        return stringBuffer.toString();
    }
}

