/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.pool;

import com.iplanet.ias.util.collection.DList;
import com.iplanet.ias.util.collection.DListNode;
import com.iplanet.ias.util.collection.FastStack;
import com.iplanet.ias.util.pool.AbstractPool;
import com.iplanet.ias.util.pool.ObjectFactory;
import com.iplanet.ias.util.scheduler.PeriodicallyServicable;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectPool
extends AbstractPool
implements PeriodicallyServicable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    protected DList list;
    protected int minSize;
    protected int initialSize;
    protected int maxLimit;
    protected long maxIdleTime;
    protected Boolean isBounded;

    public ObjectPool(ObjectFactory objectFactory, int n, int n2, long l) {
        this.factory = objectFactory;
        this.minSize = n;
        this.initialSize = n2;
        this.maxIdleTime = l;
        this.setMaxLimit(-1);
        this.initPool();
    }

    public ObjectPool(ObjectFactory objectFactory, int n, int n2, int n3, long l) {
        this.factory = objectFactory;
        this.minSize = n;
        this.maxIdleTime = l;
        this.initialSize = n2;
        this.setMaxLimit(n3);
        this.initPool();
    }

    public int getMaxLimit() {
        return this.maxLimit;
    }

    public void setMaxLimit(int n) {
        if (n <= 0 || n >= 0x7FFFFFFE) {
            this.isBounded = null;
        } else {
            this.isBounded = new Boolean(true);
            this.maxLimit = n;
        }
    }

    private void initPool() {
        this.list = new DList();
        this.collection = this.list;
        super.preload(this.minSize < this.initialSize ? this.initialSize : this.minSize);
        this.scheduler.addTimeRepeatableTask(this, (int)this.maxIdleTime);
    }

    protected boolean canCreate() {
        return this.isBounded == null ? true : this.createdCount < this.maxLimit;
    }

    protected Object checkin(Object object) {
        this.list.addAsLastNode(new TimeStampedDListNode(object, _clock.getTime()));
        return this;
    }

    private Object obtainObject(Object object) {
        TimeStampedDListNode timeStampedDListNode = (TimeStampedDListNode)this.list.delinkLastNode();
        return timeStampedDListNode.object;
    }

    protected Object checkout(Object object) {
        return this.obtainObject(object);
    }

    public void prolog() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service() {
        int n = 0;
        long l = _clock.getTime();
        long l2 = l - this.maxIdleTime;
        TimeStampedDListNode timeStampedDListNode = null;
        FastStack fastStack = new FastStack();
        Object object = this.collection;
        synchronized (object) {
            Object object2 = null;
            while (object2 == null) {
                timeStampedDListNode = (TimeStampedDListNode)this.list.getFirstDListNode();
                if (timeStampedDListNode == null) {
                    object2 = new Object();
                    continue;
                }
                if (timeStampedDListNode.timeStamp <= l2) {
                    this.list.delink(timeStampedDListNode);
                    fastStack.push(timeStampedDListNode.object);
                    ++n;
                    continue;
                }
                object2 = new Object();
            }
            this.createdCount -= n;
            if (this.createdCount < this.minSize) {
                super.preload(this.minSize - this.createdCount);
            }
            if (this.waitCount > 0) {
                if (n == 1) {
                    this.collection.notify();
                } else {
                    this.collection.notifyAll();
                }
            }
        }
        while (!fastStack.isEmpty()) {
            object = fastStack.pop();
            this.beforeDestroy(object);
            this.factory.destroy(object);
        }
        _logger.log(Level.FINE, "Leaving service after killing " + n + " (idle) objects. Now size: " + this.list.size());
    }

    public void epilog() {
    }

    public long getFrequency() {
        return this.maxIdleTime;
    }

    public boolean getExecuteIfMissed() {
        return true;
    }

    public boolean getExecutionTolerance(long l) {
        return true;
    }

    public String toString() {
        return "";
    }

    class TimeStampedDListNode
    extends DListNode {
        long timeStamp;

        public TimeStampedDListNode(Object object, long l) {
            super(object);
            this.timeStamp = l;
        }

        public String toString() {
            return "TSDListNode: " + this.object;
        }
    }
}

