/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.orbutil;

import com.iplanet.ias.util.MonitorTask;
import com.iplanet.ias.util.orbutil.IdentityHashtable;

public final class IdentityHashtableSet {
    private IdentityHashtable[] tables;
    private int size;

    public IdentityHashtableSet(int n) {
        this.size = n;
        this.tables = new IdentityHashtable[n];
        for (int i = 0; i < n; ++i) {
            this.tables[i] = new IdentityHashtable();
        }
        MonitorTask.addORBMonitorable(this);
    }

    public final int getIndex(int n) {
        return (n & Integer.MAX_VALUE) % this.size;
    }

    public final IdentityHashtable getTableIndex(int n) {
        return this.tables[n];
    }

    public final IdentityHashtable getTable(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.size;
        return this.tables[n2];
    }

    public final int getSize() {
        return this.size;
    }

    public final String toString() {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IdentityHashTableSet [Buckets=").append(this.getSize());
        for (int i = 0; i < this.size; ++i) {
            stringBuffer.append("(").append(i).append(")=").append(this.tables[i].size());
            n += this.tables[i].size();
        }
        stringBuffer.append("total=").append(n);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

