/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.net;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;

public class NetUtils {
    private static final String LOCALHOST_IP = "127.0.0.1";

    private NetUtils() {
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static InetAddress[] getHostAddresses() {
        try {
            String string = NetUtils.getHostName();
            if (string == null) {
                return null;
            }
            return InetAddress.getAllByName(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String[] getHostIPs() {
        try {
            InetAddress[] inetAddressArray = NetUtils.getHostAddresses();
            if (inetAddressArray == null) {
                return null;
            }
            String[] stringArray = new String[inetAddressArray.length];
            for (int i = 0; i < inetAddressArray.length; ++i) {
                String string;
                stringArray[i] = string = NetUtils.trimIP(inetAddressArray[i].toString());
            }
            return stringArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String trimIP(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            return string.substring(++n);
        }
        return string;
    }

    public static byte[] ip2bytes(String string) {
        try {
            string = NetUtils.trimIP(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            byte[] byArray = new byte[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n2 = Integer.parseInt(string2);
                byArray[n] = (byte)n2;
                ++n;
            }
            return byArray;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static boolean isLocalHost(String string) {
        if (string == null) {
            return false;
        }
        string = NetUtils.trimIP(string);
        return string.equals(LOCALHOST_IP);
    }

    public static boolean isLocal(String string) {
        if (string == null) {
            return false;
        }
        if (NetUtils.isLocalHost(string = NetUtils.trimIP(string))) {
            return true;
        }
        String[] stringArray = NetUtils.getHostIPs();
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isRemote(String string) {
        return !NetUtils.isLocal(string);
    }

    public static boolean isPortFree(int n) {
        if (n <= 0 || n > 65535) {
            return false;
        }
        try {
            Socket socket = new Socket(NetUtils.getHostName(), n);
            OutputStream outputStream = socket.getOutputStream();
            InputStream inputStream = socket.getInputStream();
            outputStream.close();
            outputStream = null;
            inputStream.close();
            inputStream = null;
            socket.close();
            socket = null;
        }
        catch (Exception exception) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getFreePort() {
        int n = 0;
        boolean bl = false;
        ServerSocket serverSocket = null;
        Class clazz = NetUtils.class;
        synchronized (clazz) {
            try {
                try {
                    serverSocket = new ServerSocket(0);
                    n = serverSocket.getLocalPort();
                    bl = true;
                }
                catch (Exception exception) {
                    Object var6_5 = null;
                    if (!bl) {
                        n = 0;
                    }
                    try {
                        if (serverSocket == null) return n;
                        serverSocket.close();
                        if (serverSocket.isClosed()) return n;
                        throw new Exception("local exception ...");
                    }
                    catch (Exception exception2) {
                        return 0;
                    }
                }
                Object var6_4 = null;
                if (!bl) {
                    n = 0;
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (!bl) {
                    n = 0;
                }
                try {}
                catch (Exception exception) {
                    return 0;
                }
                if (serverSocket == null) return n;
                serverSocket.close();
                if (serverSocket.isClosed()) return n;
                throw new Exception("local exception ...");
            }
            try {}
            catch (Exception exception) {
                return 0;
            }
            if (serverSocket == null) return n;
            serverSocket.close();
            if (serverSocket.isClosed()) return n;
            throw new Exception("local exception ...");
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("80: " + NetUtils.isPortFree(80));
        System.out.println("777: " + NetUtils.isPortFree(777));
        System.out.println("8000: " + NetUtils.isPortFree(8000));
    }
}

