/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.io;

import com.iplanet.ias.util.OS;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.diagnostics.Reporter;
import com.iplanet.ias.util.io.FileListerRelative;
import com.sun.logging.LogDomains;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileUtils {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private static final char[] ILLEGAL_FILENAME_CHARS = new char[]{'/', '\\', ':', '*', '?', '\"', '<', '>', '|'};
    private static final String ILLEGAL_FILENAME_STRING = "\\/:*?\"<>|";
    private static final char REPLACEMENT_CHAR = '_';
    private static final char BLANK = ' ';
    private static final char DOT = '.';
    private static String TMPFILENAME = "scratch";

    private FileUtils() {
    }

    public static boolean safeIsDirectory(File file) {
        return file != null && file.exists() && file.isDirectory();
    }

    public static boolean safeIsRealDirectory(String string) {
        return FileUtils.safeIsRealDirectory(new File(string));
    }

    public static boolean safeIsRealDirectory(File file) {
        String string;
        if (!FileUtils.safeIsDirectory(file)) {
            return false;
        }
        String string2 = FileUtils.safeGetCanonicalPath(file);
        if (string2.equals(string = file.getAbsolutePath())) {
            return true;
        }
        return OS.isWindows() && string2.equalsIgnoreCase(string);
    }

    public static boolean safeIsDirectory(String string) {
        return FileUtils.safeIsDirectory(new File(string));
    }

    public static String safeGetCanonicalPath(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    public static File safeGetCanonicalFile(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file.getAbsoluteFile();
        }
    }

    public static boolean isEar(String string) {
        return FileUtils.hasExtension(string, ".ear");
    }

    public static boolean isJar(String string) {
        return FileUtils.hasExtension(string, ".jar");
    }

    public static boolean isZip(String string) {
        return FileUtils.hasExtensionIgnoreCase(string, ".zip");
    }

    public static boolean isWar(String string) {
        return FileUtils.hasExtension(string, ".war");
    }

    public static boolean isRar(String string) {
        return FileUtils.hasExtension(string, ".rar");
    }

    public static boolean isEar(File file) {
        return FileUtils.hasExtension(file, ".ear");
    }

    public static boolean isJar(File file) {
        return FileUtils.hasExtension(file, ".jar");
    }

    public static boolean isZip(File file) {
        return FileUtils.hasExtensionIgnoreCase(file, ".zip");
    }

    public static boolean isWar(File file) {
        return FileUtils.hasExtension(file, ".war");
    }

    public static boolean isRar(File file) {
        return FileUtils.hasExtension(file, ".rar");
    }

    public static boolean hasExtension(String string, String string2) {
        if (string == null || string.length() <= 0) {
            return false;
        }
        return string.endsWith(string2);
    }

    public static boolean hasExtension(File file, String string) {
        if (file == null || !file.exists()) {
            return false;
        }
        return file.getName().endsWith(string);
    }

    public static boolean hasExtensionIgnoreCase(String string, String string2) {
        if (string == null || string.length() <= 0) {
            return false;
        }
        return string.toLowerCase().endsWith(string2.toLowerCase());
    }

    public static boolean hasExtensionIgnoreCase(File file, String string) {
        if (file == null || !file.exists()) {
            return false;
        }
        return file.getName().toLowerCase().endsWith(string.toLowerCase());
    }

    public static boolean isLegalFilename(String string) {
        for (int i = 0; i < ILLEGAL_FILENAME_CHARS.length; ++i) {
            if (string.indexOf(ILLEGAL_FILENAME_CHARS[i]) < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isFriendlyFilename(String string) {
        if (string.indexOf(32) >= 0 || string.indexOf(46) >= 0) {
            return false;
        }
        return FileUtils.isLegalFilename(string);
    }

    public static String makeLegalFilename(String string) {
        if (FileUtils.isLegalFilename(string)) {
            return string;
        }
        for (int i = 0; i < ILLEGAL_FILENAME_CHARS.length; ++i) {
            string = string.replace(ILLEGAL_FILENAME_CHARS[i], '_');
        }
        return string;
    }

    public static String makeFriendlyFileName(String string) {
        return FileUtils.makeFriendlyFilename(string);
    }

    public static String makeFriendlyFilename(String string) {
        if (FileUtils.isFriendlyFilename(string)) {
            return string;
        }
        String string2 = FileUtils.makeLegalFilename(string).replace(' ', '_');
        string2 = string2.replace('.', '_');
        return string2;
    }

    public static String makeFriendlyFilenameNoExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        return FileUtils.makeFriendlyFilename(string);
    }

    public static String makeFriendlyFileNameNoExtension(String string) {
        return FileUtils.makeFriendlyFilenameNoExtension(string);
    }

    public static void liquidate(File file) {
        FileUtils.whack(file);
    }

    public static void whack(File file) {
        Reporter.insist(file);
        if (FileUtils.safeIsRealDirectory(file)) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    FileUtils.whack(file2);
                }
                if (file2.delete()) continue;
                file2.deleteOnExit();
            }
        }
        file.delete();
    }

    public static File getDirectory(File file) {
        String string = file.getAbsolutePath();
        return new File(new File(string).getParent());
    }

    public static File createTempFile(File file) {
        File file2 = null;
        try {
            file2 = File.createTempFile(TMPFILENAME, "jar", file);
        }
        catch (IOException iOException) {
            _logger.log(Level.SEVERE, "iplanet_util.io_exception", iOException);
        }
        file2.deleteOnExit();
        return file2;
    }

    public static File[] listAllFiles(File file, String string) {
        File[] fileArray = null;
        List list = FileUtils.searchDir(file, string);
        if (list != null && list.size() > 0) {
            fileArray = new File[list.size()];
            fileArray = list.toArray(fileArray);
        }
        return fileArray;
    }

    public static List searchDir(File file, String string) {
        ArrayList<File> arrayList = null;
        if (file.isDirectory()) {
            arrayList = new ArrayList<File>();
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    arrayList.addAll(FileUtils.searchDir(fileArray[i], string));
                    continue;
                }
                String string2 = fileArray[i].toString();
                if (!FileUtils.hasExtension(string2, string)) continue;
                arrayList.add(fileArray[i]);
            }
        }
        return arrayList;
    }

    public static void copy(String string, String string2) throws IOException {
        if (!StringUtils.ok((String)string) || !StringUtils.ok((String)string2)) {
            throw new IllegalArgumentException("null or empty filename argument");
        }
        File file = new File(string);
        File file2 = new File(string2);
        FileUtils.copy(file, file2);
    }

    public static void copy(File file, File file2) throws IOException {
        if (FileUtils.safeIsDirectory(file)) {
            FileUtils.copyTree(file, file2);
            return;
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File source doesn't exist");
        }
        if (!FileUtils.safeIsDirectory(file2.getParentFile())) {
            file2.getParentFile().mkdirs();
        }
        FileUtils.copy(new FileInputStream(file), new FileOutputStream(file2));
    }

    public static void copyTree(File file, File file2) throws IOException {
        if (!FileUtils.safeIsDirectory(file)) {
            throw new IllegalArgumentException("Source isn't a directory");
        }
        file2.mkdirs();
        if (!FileUtils.safeIsDirectory(file2)) {
            throw new IllegalArgumentException("Can't create destination directory");
        }
        FileListerRelative fileListerRelative = new FileListerRelative(file);
        String[] stringArray = fileListerRelative.getFiles();
        for (int i = 0; i < stringArray.length; ++i) {
            File file3 = new File(file, stringArray[i]);
            File file4 = new File(file2, stringArray[i]);
            FileUtils.copy(file3, file4);
            _logger.log(Level.FINE, ".");
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        FileUtils.copyWithoutClose(inputStream, outputStream);
        inputStream.close();
        outputStream.close();
    }

    public static void copyWithoutClose(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[1024];
        int n = 0;
        while (n != -1) {
            try {
                n = inputStream.read(byArray, 0, byArray.length);
            }
            catch (EOFException eOFException) {
                break;
            }
            if (n == -1) continue;
            outputStream.write(byArray, 0, n);
        }
    }

    public static String makeForwardSlashes(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null String FileUtils.makeForwardSlashes");
        }
        return string.replace('\\', '/');
    }

    public static String normalizePath(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '/' || string.charAt(i) == '\\') {
                if (bl) continue;
                bl = true;
                stringBuffer.append('/');
                continue;
            }
            bl = false;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
    }

    public static String getIllegalFilenameCharacters() {
        return ILLEGAL_FILENAME_STRING;
    }
}

