/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.diagnostics;

import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.diagnostics.FieldInfo;
import com.iplanet.ias.util.diagnostics.FieldInfoVector;
import com.iplanet.ias.util.diagnostics.ObjectAnalyzerException;
import com.iplanet.ias.util.diagnostics.Reporter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ObjectAnalyzer {
    private static final String fatal = "Fatal Error in ObjectAnalyzer.toString():  ";
    private static boolean useShortClassNames_ = true;
    private static Method setAccessibleMethod;
    static /* synthetic */ Class class$java$lang$Object;

    public static String getMethods(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return ObjectAnalyzer.getMethods(clazz, false);
        }
        catch (Exception exception) {
            return "Error loading class: " + exception.getMessage();
        }
    }

    public static String getMethods(Object object) {
        return ObjectAnalyzer.getMethods(object, false);
    }

    public static String getMethods(Object object, boolean bl) {
        try {
            Class clazz = ObjectAnalyzer.safeGetClass(object);
            return ObjectAnalyzer.getMethods(clazz, bl);
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public static String getMethods(Class clazz, boolean bl) {
        String string = new String();
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            boolean bl2 = method.getName().startsWith("set");
            if (bl && !bl2) continue;
            string = string + method.toString() + '\n';
        }
        return string;
    }

    public static String getSetters(Object object) {
        return ObjectAnalyzer.getMethods(object, true);
    }

    public static String getSetters(Class clazz) {
        return ObjectAnalyzer.getMethods(clazz, true);
    }

    public static String toString(Object object) {
        return ObjectAnalyzer.toString(object, false);
    }

    public static String toStringWithSuper(Object object) {
        return ObjectAnalyzer.toString(object, true);
    }

    public static boolean equals(Object object, Object object2) {
        Class<?> clazz = object.getClass();
        if (!clazz.equals(object2.getClass())) {
            return false;
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        ObjectAnalyzer.setAccessible(fieldArray);
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            try {
                if (field.get(object).equals(field.get(object2))) continue;
                return false;
            }
            catch (IllegalAccessException illegalAccessException) {
                return false;
            }
        }
        return true;
    }

    public static void useShortClassNames() {
        useShortClassNames_ = true;
    }

    public static void useLongClassNames() {
        useShortClassNames_ = false;
    }

    private static String toString(Object object, boolean bl) {
        try {
            return ObjectAnalyzer.getFieldInfo(object, bl).toString();
        }
        catch (ObjectAnalyzerException objectAnalyzerException) {
            return objectAnalyzerException.getMessage();
        }
    }

    private static Class safeGetClass(Object object) throws ObjectAnalyzerException {
        if (object == null) {
            throw new ObjectAnalyzerException("Fatal Error in ObjectAnalyzer.toString():  null Object parameter");
        }
        if (!(object instanceof Object)) {
            throw new ObjectAnalyzerException("Fatal Error in ObjectAnalyzer.toString():  Object parameter is not really a java.lang.Object");
        }
        Class<?> clazz = object.getClass();
        if (clazz == null) {
            throw new ObjectAnalyzerException("Fatal Error in ObjectAnalyzer.toString():  getClass() on parameter Object returned null");
        }
        return clazz;
    }

    private static Class safeGetSuperclass(Class clazz) throws ObjectAnalyzerException {
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 == null) {
            throw new ObjectAnalyzerException("getSuperclass() on parameter Object returned null");
        }
        return clazz2;
    }

    private static FieldInfoVector getFieldInfo(Object object, boolean bl) throws ObjectAnalyzerException {
        FieldInfoVector fieldInfoVector = new FieldInfoVector();
        Class clazz = ObjectAnalyzer.safeGetClass(object);
        if (!bl) {
            ObjectAnalyzer.getFieldInfo(clazz, object, fieldInfoVector);
            return fieldInfoVector;
        }
        Class clazz2 = clazz;
        while (clazz2 != null && !clazz2.equals(class$java$lang$Object == null ? ObjectAnalyzer.class$("java.lang.Object") : class$java$lang$Object)) {
            ObjectAnalyzer.getFieldInfo(clazz2, object, fieldInfoVector);
            clazz2 = ObjectAnalyzer.safeGetSuperclass(clazz2);
        }
        return fieldInfoVector;
    }

    private static void getFieldInfo(Class clazz, Object object, FieldInfoVector fieldInfoVector) throws ObjectAnalyzerException {
        Field[] fieldArray = null;
        try {
            fieldArray = clazz.getDeclaredFields();
        }
        catch (SecurityException securityException) {
            throw new ObjectAnalyzerException("got a SecurityException when calling getDeclaredFields() on " + clazz.getName());
        }
        if (fieldArray == null) {
            throw new ObjectAnalyzerException("calling getDeclaredFields() on " + clazz.getName() + " returned null");
        }
        ObjectAnalyzer.setAccessible(fieldArray);
        for (int i = 0; i < fieldArray.length; ++i) {
            String string;
            Field field = fieldArray[i];
            String string2 = Modifier.toString(field.getModifiers());
            String string3 = clazz.getName();
            if (useShortClassNames_) {
                string3 = StringUtils.toShortClassName((String)string3);
            }
            if (string2.length() <= 0) {
                string2 = "(package)";
            }
            try {
                Object object2 = field.get(object);
                string = object2 == null ? "<null>" : object2.toString();
            }
            catch (IllegalAccessException illegalAccessException) {
                string = "<IllegalAccessException>";
            }
            fieldInfoVector.addElement(new FieldInfo(string3, field, string, string2));
        }
    }

    private static void setAccessible(Field[] fieldArray) {
        if (setAccessibleMethod == null) {
            return;
        }
        try {
            Boolean bl = new Boolean(true);
            setAccessibleMethod.invoke(null, fieldArray, bl);
        }
        catch (Exception exception) {
            Reporter.warn("Got an exception invoking setAccessible: " + exception);
        }
    }

    private static void setupSetAccessibleMethod() {
        Class<?> clazz;
        setAccessibleMethod = null;
        try {
            clazz = Class.forName("java.lang.reflect.AccessibleObject");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Reporter.info("Can't find java.lang.reflect.AccessibleObject -- thus I can't show any private or protected variable values.  This must be pre JDK 1.2.x");
            return;
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!method.getName().equals("setAccessible") || method.getParameterTypes().length != 2) continue;
            Reporter.verbose("Found setAccessible: " + method);
            setAccessibleMethod = method;
            break;
        }
    }

    public static void main(String[] stringArray) {
        String string = new String("Hello!");
        System.out.println("Regular: \n" + ObjectAnalyzer.toString(string) + "\n\n");
        System.out.println("Super: \n" + ObjectAnalyzer.toStringWithSuper(string) + "\n\n");
    }

    static {
        ObjectAnalyzer.setupSetAccessibleMethod();
    }
}

