/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.collection;

import com.iplanet.ias.util.collection.Bucket;
import com.iplanet.ias.util.collection.SortedArrayListBucket;

public class LongHashMap {
    int maxBuckets = 0;
    Bucket[] buckets;

    public LongHashMap() {
        this(89);
    }

    public LongHashMap(int n) {
        this.maxBuckets = n;
        this.buckets = new Bucket[n];
        for (int i = 0; i < n; ++i) {
            this.buckets[i] = new SortedArrayListBucket();
        }
    }

    public LongHashMap(Bucket[] bucketArray) {
        this.buckets = bucketArray;
        this.maxBuckets = bucketArray.length;
    }

    public void put(long l, Object object) {
        int n = (int)Math.abs(l % (long)this.maxBuckets);
        this.buckets[n].put(l, object);
    }

    public Object get(long l) {
        int n = (int)Math.abs(l % (long)this.maxBuckets);
        return this.buckets[n].get(l);
    }

    public Object remove(long l) {
        int n = (int)Math.abs(l % (long)this.maxBuckets);
        return this.buckets[n].remove(l);
    }

    public void print() {
        for (int i = 0; i < this.maxBuckets; ++i) {
            System.out.println("Bucket[" + i + "]: " + this.buckets[i]);
        }
    }

    public static void main(String[] stringArray) {
        long l;
        int n = 20;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        String string = "SomeData_";
        LongHashMap longHashMap = new LongHashMap();
        for (l = 0L; l < (long)n; l += 5L) {
            longHashMap.put(l, string + l);
        }
        for (l = 1L; l < (long)n; l += 3L) {
            longHashMap.put(l, string + l);
        }
        for (l = 3L; l < (long)n; l += 4L) {
            longHashMap.put(l, string + l);
        }
        for (l = -23L; l < (long)n; l += 4L) {
            longHashMap.put(l, string + l);
        }
        for (l = -25L; l < 25L; ++l) {
            System.out.println("Key: " + l + "; val: " + longHashMap.get(l));
        }
        l4 = System.currentTimeMillis();
    }
}

