/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.collection;

import com.iplanet.ias.util.collection.Bucket;
import com.iplanet.ias.util.collection.SortedArrayListBucket;
import java.util.Iterator;

public class IntHashMap {
    int maxBuckets = 0;
    Bucket[] buckets;

    public IntHashMap() {
        this(89);
    }

    public IntHashMap(int n) {
        this.maxBuckets = n;
        this.buckets = new Bucket[n];
        for (int i = 0; i < n; ++i) {
            this.buckets[i] = new SortedArrayListBucket();
        }
    }

    public IntHashMap(Bucket[] bucketArray) {
        this.buckets = bucketArray;
        this.maxBuckets = bucketArray.length;
    }

    public void put(int n, Object object) {
        int n2 = Math.abs(n % this.maxBuckets);
        this.buckets[n2].put(n, object);
    }

    public Object get(int n) {
        int n2 = Math.abs(n % this.maxBuckets);
        return this.buckets[n2].get(n);
    }

    public boolean containsKey(int n) {
        return null != this.get(n);
    }

    public Object remove(int n) {
        int n2 = Math.abs(n % this.maxBuckets);
        return this.buckets[n2].remove(n);
    }

    public void print() {
        for (int i = 0; i < this.maxBuckets; ++i) {
            System.out.println("Bucket[" + i + "]: " + this.buckets[i]);
        }
    }

    public IntHashMapIterator iterator() {
        return new IntHashMapIterator();
    }

    public static void main(String[] stringArray) {
        int n;
        int n2 = 20;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        String string = "SomeData_";
        IntHashMap intHashMap = new IntHashMap();
        for (n = 0; n < n2; n += 5) {
            intHashMap.put(n, string + n);
        }
        for (n = 1; n < n2; n += 3) {
            intHashMap.put(n, string + n);
        }
        for (n = 3; n < n2; n += 4) {
            intHashMap.put(n, string + n);
        }
        for (n = -23; n < n2; n += 4) {
            intHashMap.put(n, string + n);
        }
        for (n = -25; n < 25; ++n) {
            System.out.println("Key: " + n + "; val: " + intHashMap.get(n));
        }
        l3 = System.currentTimeMillis();
        IntHashMapIterator intHashMapIterator = intHashMap.iterator();
        while (intHashMapIterator.hasNext()) {
            System.out.println("Got: " + intHashMapIterator.next());
        }
    }

    private class IntHashMapIterator
    implements Iterator {
        int bucketIndex = 0;
        Iterator iter = null;

        IntHashMapIterator() {
            this.iter = IntHashMap.this.buckets[0].iterator();
        }

        public boolean hasNext() {
            if (this.iter.hasNext()) {
                return true;
            }
            while (++this.bucketIndex < IntHashMap.this.maxBuckets) {
                this.iter = IntHashMap.this.buckets[this.bucketIndex].iterator();
                if (!this.iter.hasNext()) continue;
                return true;
            }
            return false;
        }

        public Object next() {
            return this.iter.next();
        }

        public void remove() {
        }
    }
}

