/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.cache.test;

import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HashtableTest {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private String[] keys;
    private int maxKeys;
    private int maxLoop;

    public HashtableTest(int n, int n2) {
        this.maxKeys = n;
        this.maxLoop = n2;
        this.keys = new String[n];
        for (int i = 0; i < n; ++i) {
            this.keys[i] = "" + i;
        }
    }

    public void testHashtable() {
        long l = 0L;
        long l2 = 0L;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < this.maxKeys; ++i) {
            hashtable.put(this.keys[i], this.keys[i]);
        }
        double d = 0.0;
        for (int i = 0; i < this.maxLoop; ++i) {
            l = System.currentTimeMillis();
            for (int j = this.maxKeys - 1; j > 0; --j) {
                String string = this.keys[j];
                if (hashtable.get(string).equals(string)) continue;
                _logger.log(Level.WARNING, "iplanet_util.lookup_fail", string);
            }
            l2 = System.currentTimeMillis();
            _logger.log(Level.FINE, "Hashtable lookup took: " + (double)(l2 - l) / 1000.0 + " seconds.");
            d += (double)(l2 - l);
        }
        _logger.log(Level.FINE, "Average Hashtable lookup took: " + d / (double)this.maxLoop / 1000.0 + " seconds.");
    }

    public static void main(String[] stringArray) {
        HashtableTest hashtableTest = new HashtableTest(200000, 10);
        hashtableTest.testHashtable();
    }
}

