/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.cache.test;

import com.iplanet.ias.util.cache.ConcurrentCache;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConcurrentCacheTest {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private String[] keys;
    private int maxKeys;
    private int maxLoop;

    public ConcurrentCacheTest(int n, int n2) {
        this.maxKeys = n;
        this.maxLoop = n2;
        this.keys = new String[n];
        for (int i = 0; i < n; ++i) {
            this.keys[i] = "" + i;
        }
    }

    public void testConcurrentCache() {
        int n = 0;
        n = this.maxKeys * 100 / 89;
        ConcurrentCache concurrentCache = new ConcurrentCache(n);
        for (int i = 0; i < this.maxKeys; ++i) {
            concurrentCache.putEntry(this.keys[i], this.keys[i]);
        }
        long l = 0L;
        long l2 = 0L;
        double d = 0.0;
        for (int i = 0; i < this.maxLoop; ++i) {
            l = System.currentTimeMillis();
            for (int j = 0; j < this.maxKeys; ++j) {
                String string = this.keys[j];
                if (concurrentCache.getEntry(string).equals(string)) continue;
                _logger.log(Level.WARNING, "iplanet_util.lookup_fail", string);
            }
            l2 = System.currentTimeMillis();
            _logger.log(Level.FINE, "ConcurrentMap lookup took: " + (double)(l2 - l) / 1000.0 + " seconds.");
            d += (double)(l2 - l);
        }
        _logger.log(Level.FINE, "Average ConcurrentCache lookup took: " + d / (double)this.maxLoop / 1000.0 + " seconds.");
        concurrentCache = null;
    }

    public static void main(String[] stringArray) {
        ConcurrentCacheTest concurrentCacheTest = new ConcurrentCacheTest(200000, 10);
        concurrentCacheTest.testConcurrentCache();
    }
}

