/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.cache;

import com.iplanet.ias.util.cache.CacheStore;
import com.iplanet.ias.util.cache.ConcurrentMap;
import com.iplanet.ias.util.scheduler.PeriodicEventScheduler;
import com.iplanet.ias.util.scheduler.PeriodicallyServicable;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileCacheStore
implements CacheStore,
PeriodicallyServicable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private static final long MAX_UNUSED_TIME = 60000L;
    File dir;
    ConcurrentMap map;
    private boolean debug = false;

    public FileCacheStore(String string) {
        try {
            this.dir = new File(string);
            this.dir.mkdirs();
            this.map = new ConcurrentMap(1024);
            PeriodicEventScheduler periodicEventScheduler = PeriodicEventScheduler.getInstance();
            PeriodicEventScheduler.getInstance().addTimeRepeatableTask(this, 1);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iplanet_util.fcstore_create_exception", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(Object object) {
        String string = (String)this.map.removeEntry(object);
        if (string == null) {
            return null;
        }
        File file = new File(this.dir, string);
        ObjectInputStream objectInputStream = null;
        try {
            Object object2;
            if (!file.exists()) {
                Object var5_5 = null;
                return var5_5;
            }
            objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            Object object3 = object2 = objectInputStream.readObject();
            return object3;
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iplanet_util.lookup_exception", exception);
        }
        finally {
            try {
                objectInputStream.close();
            }
            catch (IOException iOException) {}
            file.delete();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Object object, Object object2) {
        File file = null;
        try {
            String string = "" + object;
            this.map.putEntry(object, string);
            file = new File(this.dir, string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            objectOutputStream.writeObject(object2);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iplanet_util.store_exception", exception);
        }
        finally {
            file.deleteOnExit();
        }
    }

    public long getFrequency() {
        return 60000L;
    }

    public boolean getExecuteIfMissed() {
        return true;
    }

    public boolean getExecutionTolerance(long l) {
        return true;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void prolog() {
    }

    public void service() {
        Iterator iterator = this.map.keys();
        long l = System.currentTimeMillis() - 60000L;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            String string = (String)this.map.getEntry(e);
            File file = new File(this.dir, string);
            if (file.lastModified() >= l) continue;
            this.map.removeEntry(e);
            file.delete();
        }
    }

    public void epilog() {
    }
}

