/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.cache;

import com.iplanet.ias.util.cache.Cache;

public class ConcurrentCache
implements Cache {
    private int maxBuckets;
    private CBucket[] buckets;
    private int size;

    public ConcurrentCache(int n) {
        this.maxBuckets = n;
        this.buckets = new CBucket[n];
        for (int i = 0; i < n; ++i) {
            this.buckets[i] = new CBucket();
        }
        this.size = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        int n = object.hashCode();
        int n2 = (Integer.MAX_VALUE & n) % this.maxBuckets;
        CBucket cBucket = this.buckets[n2];
        synchronized (cBucket) {
            CMapNode cMapNode = this.buckets[n2].first;
            while (cMapNode != null) {
                if (cMapNode.keyHashCode == n && cMapNode.key.equals(object)) {
                    return true;
                }
                cMapNode = cMapNode.next;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getEntry(Object object) {
        CBucket cBucket;
        int n = object.hashCode();
        int n2 = (Integer.MAX_VALUE & n) % this.maxBuckets;
        CBucket cBucket2 = cBucket = this.buckets[n2];
        synchronized (cBucket2) {
            CMapNode cMapNode = cBucket.first;
            while (cMapNode != null) {
                if (cMapNode.keyHashCode == n && cMapNode.key.equals(object)) {
                    return cMapNode.object;
                }
                cMapNode = cMapNode.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putEntry(Object object, Object object2) {
        int n = object.hashCode();
        int n2 = (Integer.MAX_VALUE & n) % this.maxBuckets;
        CBucket cBucket = this.buckets[n2];
        synchronized (cBucket) {
            CMapNode cMapNode = this.buckets[n2].first;
            while (cMapNode != null) {
                if (cMapNode.keyHashCode == n && cMapNode.key.equals(object)) {
                    Object object3 = cMapNode.object;
                    cMapNode.object = object2;
                    return object3;
                }
                cMapNode = cMapNode.next;
            }
            this.buckets[n2].first = cMapNode = new CMapNode(object, n, object2, this.buckets[n2].first);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeEntry(Object object) {
        int n = object.hashCode();
        int n2 = (Integer.MAX_VALUE & n) % this.maxBuckets;
        CMapNode cMapNode = null;
        CMapNode cMapNode2 = null;
        CBucket cBucket = this.buckets[n2];
        synchronized (cBucket) {
            cMapNode2 = this.buckets[n2].first;
            while (cMapNode2 != null) {
                if (cMapNode2.keyHashCode == n && object.equals(cMapNode2.key)) {
                    if (cMapNode == null) {
                        this.buckets[n2].first = cMapNode2.next;
                    } else {
                        cMapNode.next = cMapNode2.next;
                    }
                    cMapNode2.next = null;
                    return cMapNode2.object;
                }
                cMapNode = cMapNode2;
                cMapNode2 = cMapNode2.next;
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName();
    }

    private static class CMapNode {
        Object key;
        Object object;
        int keyHashCode;
        CMapNode next;

        CMapNode() {
        }

        CMapNode(Object object, int n, Object object2, CMapNode cMapNode) {
            this.key = object;
            this.object = object2;
            this.keyHashCode = n;
            this.next = cMapNode;
        }
    }

    private static class CBucket {
        CMapNode first;

        private CBucket() {
        }
    }
}

