/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.transaction.monitor;

import com.iplanet.ias.admin.monitor.BaseMonitorMBean;
import com.iplanet.ias.admin.monitor.MonitoredObjectType;
import com.iplanet.ias.admin.monitor.types.Counter;
import com.iplanet.ias.admin.monitor.types.MonitoredAttributeType;
import com.iplanet.ias.admin.monitor.types.StringMonitoredAttributeType;
import com.iplanet.ias.transaction.TransactionAdminBean;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.Switch;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public class JTSMonitorMBean
extends BaseMonitorMBean {
    private static final String NUM_TRANSACTIONS_COMPLETED = "total-tx-completed";
    private static final String NUM_TRANSACTIONS_ROLLEDBACK = "total-tx-rolled-back";
    private static final String NUM_TRANSACTIONS_INFLIGHT = "total-tx-inflight";
    private static final String IS_FROZEN = "isFrozen";
    private static final String INFLIGHT_TRANSACTIONS = "inflight-tx";
    private static final String ROLLBACK = "rollback-list";
    private static final String FREEZE = "freeze";
    private static final int COLUMN_LENGTH = 25;
    private static StringManager sm = StringManager.getManager(JTSMonitorMBean.class);
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private static Object[][] attrNameTypeArray = new Object[][]{{"total-tx-completed", Counter.INTEGER}, {"total-tx-rolled-back", Counter.INTEGER}, {"total-tx-inflight", Counter.INTEGER}, {"isFrozen", StringMonitoredAttributeType.DEFAULT}, {"inflight-tx", StringMonitoredAttributeType.DEFAULT}};
    private static MBeanOperationInfo[] operationInfoArray = new MBeanOperationInfo[2];
    private J2EETransactionManager txnMgr;
    private Hashtable txnTable = null;
    private MonitoredObjectType type = MonitoredObjectType.TXNMGR;
    private boolean monitorOn = false;
    private static Map attrNameTypeMap = JTSMonitorMBean.createAttrNameTypeMap(attrNameTypeArray);
    private static MBeanInfo mBeanInfo;

    public JTSMonitorMBean() {
        this.txnMgr = Switch.getSwitch().getTransactionManager();
    }

    public Object getAttribute(String string) throws AttributeNotFoundException {
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("transaction.monitor.attribute_is_null")));
        }
        if (string.equals(NUM_TRANSACTIONS_COMPLETED)) {
            return new Integer(this.txnMgr.getNumberOfTransactionsCommitted());
        }
        if (string.equals(NUM_TRANSACTIONS_ROLLEDBACK)) {
            return new Integer(this.txnMgr.getNumberOfTransactionsRolledBack());
        }
        if (string.equals(NUM_TRANSACTIONS_INFLIGHT)) {
            return new Integer(this.txnMgr.getNumberOfActiveTransactions());
        }
        if (string.equals(IS_FROZEN)) {
            if (this.txnMgr.isFrozen()) {
                return "True";
            }
            return "False";
        }
        if (string.equals(INFLIGHT_TRANSACTIONS)) {
            ArrayList arrayList = this.txnMgr.getActiveTransactions();
            if (arrayList.isEmpty()) {
                return "No active transaction found.";
            }
            StringBuffer stringBuffer = new StringBuffer(1024);
            this.txnTable = new Hashtable();
            if (arrayList.size() > 0) {
                int n;
                String string2 = "Transaction Id";
                stringBuffer.append("\n\n");
                stringBuffer.append(string2);
                for (n = string2.length(); n < 40; ++n) {
                    stringBuffer.append(" ");
                }
                string2 = "Status";
                stringBuffer.append(string2);
                for (n = string2.length(); n < 25; ++n) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append("ElapsedTime(ms)\n");
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                int n;
                TransactionAdminBean transactionAdminBean = (TransactionAdminBean)arrayList.get(i);
                Transaction transaction = (Transaction)transactionAdminBean.getIdentifier();
                String string3 = transactionAdminBean.getId();
                this.txnTable.put(string3, transaction);
                stringBuffer.append("\n");
                stringBuffer.append(string3);
                for (n = string3.length(); n < 40; ++n) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(transactionAdminBean.getStatus());
                for (n = transactionAdminBean.getStatus().length(); n < 25; ++n) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(String.valueOf(transactionAdminBean.getElapsedTime()));
            }
            return stringBuffer.toString();
        }
        throw new AttributeNotFoundException(sm.getString("transaction.monitor.attribute_not_found", string));
    }

    public AttributeList getAttributes(String[] stringArray) {
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("transaction.monitor.attributes_not_null")));
        }
        AttributeList attributeList = new AttributeList();
        if (stringArray.length == 0) {
            return attributeList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Object object = this.getAttribute(stringArray[i]);
                attributeList.add(new Attribute(stringArray[i], object));
                continue;
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "transaction.monitor.error_while_getting_monitor_attr", exception);
            }
        }
        return attributeList;
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        if (string == null || string.equals("")) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("transaction.monitor.operation_name_is_null")));
        }
        if (objectArray == null) {
            return null;
        }
        AttributeList attributeList = new AttributeList();
        if (string.equals(ROLLBACK)) {
            for (int i = 0; i < objectArray.length; ++i) {
                String string2 = (String)objectArray[i];
                Object object = this.setRollback(string2);
                attributeList.add(new Attribute(string2, object));
            }
        } else if (string.equals(FREEZE)) {
            if (objectArray[0].equals("true")) {
                this.txnMgr.freeze();
                attributeList.add(new Attribute(FREEZE, "Successful"));
            } else {
                this.txnMgr.unfreeze();
                attributeList.add(new Attribute("unfreeze", "Successful"));
            }
        } else {
            throw new UnsupportedOperationException(UNSUPPORTED_ERRMSG);
        }
        return attributeList;
    }

    public Object setRollback(String string) {
        String string2 = "";
        if (this.txnTable == null || this.txnTable.get(string) == null) {
            string2 = "Invalid transaction Id or Transaction is over";
        } else {
            try {
                this.txnMgr.forceRollback((Transaction)this.txnTable.get(string));
                string2 = "Rollback successful";
            }
            catch (IllegalStateException illegalStateException) {
                string2 = "Rollback unsuccessful. Current Thread is not associated with the transaction";
            }
            catch (SecurityException securityException) {
                string2 = "Rollback unsuccessful. Thread is not allowed to rollback the transaction";
            }
            catch (SystemException systemException) {
                string2 = "Rollback unsuccessful. Unexpected error condition encountered by Transaction Manager.";
            }
        }
        return string2;
    }

    public void startMonitoring() {
        this.txnMgr.setMonitoringEnabled(true);
        this.monitorOn = true;
    }

    public void stopMonitoring() {
        this.txnMgr.setMonitoringEnabled(false);
        this.monitorOn = false;
    }

    public MBeanInfo getMBeanInfo() {
        return mBeanInfo;
    }

    public Map getMonitoringMetaData() {
        return attrNameTypeMap;
    }

    public MonitoredAttributeType getAttributeType(String string) {
        MonitoredAttributeType monitoredAttributeType = null;
        if (attrNameTypeMap != null && string != null) {
            monitoredAttributeType = (MonitoredAttributeType)attrNameTypeMap.get(string);
        }
        return monitoredAttributeType;
    }

    public MonitoredObjectType getMonitoredObjectType() {
        return this.type;
    }

    static {
        JTSMonitorMBean.operationInfoArray[0] = new MBeanOperationInfo(ROLLBACK, "rollback(String txnId): Marks the transaction for rollback", null, "void", 1);
        JTSMonitorMBean.operationInfoArray[1] = new MBeanOperationInfo(FREEZE, "freeze(): Freezes the transactions", null, "void", 1);
        mBeanInfo = JTSMonitorMBean.createMBeanInfo(attrNameTypeMap, operationInfoArray);
    }
}

