/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.transaction;

import com.iplanet.ias.transaction.XAResourceWrapper;
import com.iplanet.ias.util.i18n.StringManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class OracleXAResource
extends XAResourceWrapper {
    private static StringManager sm = StringManager.getManager(OracleXAResource.class);
    private static int called = 1;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public Xid[] recover(int n) throws XAException {
        ++called;
        if (n == 0x1000000) {
            return this.recoverList();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Xid[] recoverList() throws XAException {
        block14: {
            var1_1 = null;
            var2_2 = null;
            var3_3 = null;
            try {
                try {
                    var3_3 = this.m_xacon.getConnection();
                    if (null == var3_3) {
                        throw new XAException(OracleXAResource.sm.getString("transaction.oracle_xa_wrapper_connection_failed"));
                    }
                    var1_1 = var3_3.createStatement();
                    var2_2 = var1_1.executeQuery("select pending.local_tran_id from SYS.PENDING_TRANS$ pending, SYS.DBA_2PC_NEIGHBORS");
                    var2_2.close();
                    var2_2 = null;
                    var1_1.close();
                    var1_1 = null;
                    var4_4 = this.m_xacon.getXAResource().recover(0x1000000);
                    var6_7 = null;
                    if (null == var2_2) break block14;
                }
                catch (SQLException var4_5) {
                    throw new XAException(OracleXAResource.sm.getString("transaction.oracle_sqlexception_occurred", var4_5));
                }
                catch (Exception var4_6) {
                    throw new XAException(OracleXAResource.sm.getString("transaction.oracle_unknownexception_occurred", var4_6));
                }
            }
            catch (Throwable var5_11) {
                var6_8 = null;
                if (null != var2_2) {
                    try {
                        var2_2.close();
                    }
                    catch (SQLException var7_10) {
                        // empty catch block
                    }
                }
                if (null == var1_1) throw var5_11;
                try {
                    var1_1.close();
                    throw var5_11;
                }
                catch (SQLException var7_10) {
                    throw var5_11;
                }
            }
            ** try [egrp 2[TRYBLOCK] [4 : 148->157)] { 
lbl42:
            // 1 sources

            var2_2.close();
            break block14;
lbl44:
            // 1 sources

            catch (SQLException var7_9) {
                // empty catch block
            }
        }
        if (null == var1_1) return var4_4;
        try {}
        catch (SQLException var7_9) {
            // empty catch block
            return var4_4;
        }
        var1_1.close();
        return var4_4;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        this.doRecovery(xid, true);
    }

    public void rollback(Xid xid) throws XAException {
        this.doRecovery(xid, false);
    }

    /*
     * Loose catch block
     */
    private void doRecovery(Xid xid, boolean bl) throws XAException {
        block17: {
            SQLException sQLException2222;
            ResultSet resultSet;
            Statement statement;
            block16: {
                block15: {
                    statement = null;
                    resultSet = null;
                    Connection connection = null;
                    connection = this.m_xacon.getConnection();
                    if (null == connection) {
                        throw new XAException(sm.getString("transaction.oracle_xa_wrapper_connection_failed"));
                    }
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery("select pending.local_tran_id from SYS.PENDING_TRANS$ pending, SYS.DBA_2PC_NEIGHBORS dba where pending.global_foreign_id = '" + OracleXAResource.toHexString(xid.getGlobalTransactionId()) + "' and pending.local_tran_id = dba.local_tran_id and dba.branch = '" + OracleXAResource.toHexString(xid.getBranchQualifier()) + "' and pending.state = 'prepared'");
                    if (!resultSet.next()) break block15;
                    String string = resultSet.getString(1);
                    resultSet.close();
                    resultSet = null;
                    statement.executeUpdate((bl ? "commit force '" : "rollback force '") + string + "'");
                    statement.close();
                    statement = null;
                }
                Object var8_9 = null;
                if (null == resultSet) break block16;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException2222) {
                    // empty catch block
                }
            }
            if (null != statement) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException2222) {}
            }
            break block17;
            {
                catch (SQLException sQLException3) {
                    throw new XAException(sm.getString("transaction.oracle_sqlexception_occurred", sQLException3));
                }
                catch (Exception exception) {
                    throw new XAException(sm.getString("transaction.oracle_unknownexception_occurred", exception));
                }
            }
            catch (Throwable throwable) {
                SQLException sQLException42222;
                Object var8_10 = null;
                if (null != resultSet) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException42222) {
                        // empty catch block
                    }
                }
                if (null != statement) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException42222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != byArray && 0 < byArray.length) {
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(HEX_DIGITS[(byArray[i] & 0xF0) >> 4]);
                stringBuffer.append(HEX_DIGITS[byArray[i] & 0xF]);
            }
            return stringBuffer.toString();
        }
        return "";
    }
}

