/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.verifier.tests.ejb.ias;

import com.iplanet.ias.tools.common.dd.ejb.AsContext;
import com.iplanet.ias.tools.common.dd.ejb.Ejb;
import com.iplanet.ias.tools.common.dd.ejb.IorSecurityConfig;
import com.iplanet.ias.tools.common.dd.ejb.SasContext;
import com.iplanet.ias.tools.common.dd.ejb.SunEjbJar;
import com.iplanet.ias.tools.common.dd.ejb.TransportConfig;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;

public class ASEjbIORSecurityConfig
extends EjbTest
implements EjbCheck {
    boolean oneFailed = false;

    public Result check(EjbDescriptor ejbDescriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor componentNameConstructor = new ComponentNameConstructor(ejbDescriptor);
        SunEjbJar sunEjbJar = ejbDescriptor.getEjbBundleDescriptor().getIasEjbObject();
        if (sunEjbJar != null) {
            IorSecurityConfig iorSecurityConfig;
            Ejb[] ejbArray = sunEjbJar.getEnterpriseBeans().getEjb();
            Ejb ejb = null;
            for (int i = 0; i < ejbArray.length; ++i) {
                if (!ejbArray[i].getEjbName().equals(ejbDescriptor.getName())) continue;
                ejb = ejbArray[i];
                break;
            }
            if ((iorSecurityConfig = ejb.getIorSecurityConfig()) == null) {
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-EJB ior-security-config] : ior-security-config Element not defined"));
            } else {
                TransportConfig transportConfig = iorSecurityConfig.getTransportConfig();
                if (transportConfig != null) {
                    this.testTranConfig(transportConfig, result);
                } else {
                    result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-EJB ior-security-config] : transport-config Element not defined"));
                }
                AsContext asContext = iorSecurityConfig.getAsContext();
                if (asContext != null) {
                    this.testAsContext(asContext, result);
                } else {
                    result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-EJB ior-security-config] : as-context Element not defined"));
                }
                SasContext sasContext = iorSecurityConfig.getSasContext();
                if (sasContext != null) {
                    this.testSasContext(sasContext, result);
                } else {
                    result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-EJB ior-security-config] : sas-context Element not defined"));
                }
            }
            if (this.oneFailed) {
                result.setStatus(1);
            }
        } else {
            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".notRun", "NOT RUN [AS-EJB] : Could not create an SunEjbJar object"));
        }
        return result;
    }

    protected void testTranConfig(TransportConfig transportConfig, Result result) {
        String string = transportConfig.getIntegrity();
        this.testMsgs(string, result, "transport-config", "integrity");
        String string2 = transportConfig.getConfidentiality();
        this.testMsgs(string2, result, "transport-config", "confidentiality");
        String string3 = transportConfig.getEstablishTrustInTarget();
        this.testMsgs(string3, result, "transport-config", "extablish-trust-in-target");
        String string4 = transportConfig.getEstablishTrustInClient();
        this.testMsgs(string4, result, "transport-config", "establish-trust-in-client");
    }

    protected void testAsContext(AsContext asContext, Result result) {
        String string = asContext.getAuthMethod();
        if (string.length() == 0) {
            this.oneFailed = true;
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedAsContextAuthMethod", "FAILED [AS-EJB as-context] : auth-method cannotb be an empty string"));
        } else if (string.equals("USERNAME_PASSWORD")) {
            result.passed(smh.getLocalString(this.getClass().getName() + ".passedAsContextAuthMethod", "PASSED [AS-EJB as-context] : auth-method is {0}", new Object[]{string}));
        } else {
            this.oneFailed = true;
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedAsContextAuthMethod1", "FAILED [AS-EJB as-context] : auth-method cannot be {0}. It can only be USERNAME_PASSWORD", new Object[]{string}));
        }
        string = asContext.getRealm();
        if (string.length() == 0) {
            this.oneFailed = true;
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedAsContextRealm", "FAILED [AS-EJB as-context] : realm cannot be an empty string"));
        } else {
            result.passed(smh.getLocalString(this.getClass().getName() + ".passedAsContextRealm", "PASSED [AS-EJB as-context] : realm is {0}", new Object[]{string}));
        }
        string = asContext.getRequired();
        if (string.length() == 0) {
            this.oneFailed = true;
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedAsContextRequired", "FAILED [AS-EJB as-context] : required cannot be an empty string"));
        } else if (string.equals("true") || string.equals("false")) {
            result.passed(smh.getLocalString(this.getClass().getName() + ".passedAsContextRequired", "PASSED [AS-EJB as-context] : required is {0}", new Object[]{string}));
        } else {
            this.oneFailed = true;
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedAsContextRequired1", "FAILED [AS-EJB as-context] : required cannot be {0}. It can only be true or false", new Object[]{string}));
        }
    }

    protected void testSasContext(SasContext sasContext, Result result) {
        String string = sasContext.getCallerPropagation();
        this.testMsgs(string, result, "sas-context", "caller-propagation");
    }

    private void testMsgs(String string, Result result, String string2, String string3) {
        if (string.length() == 0) {
            this.oneFailed = true;
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedTestMsg", "FAILED [AS-EJB " + string2 + "] : " + string3 + " cannot be an empty String"));
        } else if (!(string.equals("NONE") || string.equals("SUPPORTED") || string.equals("REQUIRED"))) {
            this.oneFailed = true;
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedTestMsg", "FAILED [AS-EJB " + string2 + "] : " + string3 + " cannot be {0}. It can be either NONE, SUPPORTED or REQUIRED", new Object[]{string}));
        } else {
            result.passed(smh.getLocalString(this.getClass().getName() + ".passedTestMsg", "PASSED [AS-EJB " + string2 + "] : " + string3 + " is {0}", new Object[]{string}));
        }
    }
}

