/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server.monitor;

import com.iplanet.ias.admin.monitor.BaseMonitorMBean;
import com.iplanet.ias.admin.monitor.types.Gauge;
import com.iplanet.ias.admin.monitor.types.MonitoredAttributeType;
import com.iplanet.ias.server.monitor.HttpServerMonitorMBean;
import com.iplanet.ias.server.monitor.beans.ServerMonitorBean;
import com.iplanet.ias.server.monitor.beans.StatsMonitorBean;
import com.iplanet.ias.server.monitor.beans.VirtualServerMonitorBean;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanInfo;
import javax.management.RuntimeOperationsException;

public class VirtualServerMonitorMBean
extends BaseMonitorMBean {
    private static Logger _logger = null;
    private static ResourceBundle _rb = null;
    private Map _attrNameTypeMap;
    private MBeanInfo _mBeanInfo;
    private HttpServerMonitorMBean _parent;

    public VirtualServerMonitorMBean(HttpServerMonitorMBean httpServerMonitorMBean) {
        this._parent = httpServerMonitorMBean;
        this._attrNameTypeMap = new HashMap(1);
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
            _rb = _logger.getResourceBundle();
        }
        try {
            this._attrNameTypeMap.put("<vs-id>", new Gauge(Class.forName("java.lang.StringBuffer")));
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "web.monitor.unexpected_error_in_constr_virtualserver_mbean", exception);
        }
        this._mBeanInfo = VirtualServerMonitorMBean.createMBeanInfo(this._attrNameTypeMap);
    }

    public MBeanInfo getMBeanInfo() {
        return this._mBeanInfo;
    }

    public Map getMonitoringMetaData() {
        return this._attrNameTypeMap;
    }

    public MonitoredAttributeType getAttributeType(String string) {
        MonitoredAttributeType monitoredAttributeType = null;
        if (this._attrNameTypeMap != null && string != null) {
            monitoredAttributeType = (MonitoredAttributeType)this._attrNameTypeMap.get(string);
        }
        return monitoredAttributeType;
    }

    public Object getAttribute(String string) throws AttributeNotFoundException {
        StatsMonitorBean statsMonitorBean = this._parent.getServerStats();
        if (statsMonitorBean == null) {
            String string2 = _rb.getString("web.monitor.attribute_not_found");
            Object[] objectArray = new Object[]{string};
            string2 = MessageFormat.format(string2, objectArray);
            throw new AttributeNotFoundException(string2);
        }
        String string3 = "    ";
        ServerMonitorBean serverMonitorBean = statsMonitorBean.getServer(0);
        StringBuffer stringBuffer = new StringBuffer();
        VirtualServerMonitorBean[] virtualServerMonitorBeanArray = serverMonitorBean.getVirtualServer();
        for (int i = 0; i < virtualServerMonitorBeanArray.length; ++i) {
            if (!virtualServerMonitorBeanArray[i].getAttributeValue("id").equals(string)) continue;
            stringBuffer.append("\nVirtual Server: " + string);
            serverMonitorBean.dumpAttributes("VirtualServer", i, stringBuffer, "\n");
            virtualServerMonitorBeanArray[i].dump(stringBuffer, "\n" + string3);
            return stringBuffer;
        }
        String string4 = _rb.getString("web.monitor.attribute_not_found");
        Object[] objectArray = new Object[]{string};
        string4 = MessageFormat.format(string4, objectArray);
        throw new AttributeNotFoundException(string4);
    }

    public AttributeList getAttributes(String[] stringArray) {
        if (stringArray == null) {
            String string = _rb.getString("web.monitor.attribute_cannot_be_null");
            throw new RuntimeOperationsException(new IllegalArgumentException(string));
        }
        AttributeList attributeList = new AttributeList();
        if (stringArray.length == 0) {
            return attributeList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Object object = this.getAttribute(stringArray[i]);
                attributeList.add(new Attribute(stringArray[i], object));
                continue;
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "web.monitor.error_while_getting_monitor_attr", exception);
            }
        }
        return attributeList;
    }

    public String[] getAllAttributeNames() {
        StatsMonitorBean statsMonitorBean = this._parent.updateNewStats();
        if (statsMonitorBean == null) {
            return null;
        }
        ServerMonitorBean serverMonitorBean = statsMonitorBean.getServer(0);
        VirtualServerMonitorBean[] virtualServerMonitorBeanArray = serverMonitorBean.getVirtualServer();
        String[] stringArray = new String[virtualServerMonitorBeanArray.length];
        for (int i = 0; i < virtualServerMonitorBeanArray.length; ++i) {
            stringArray[i] = virtualServerMonitorBeanArray[i].getAttributeValue("id");
        }
        return stringArray;
    }
}

