/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server;

import com.iplanet.ias.admin.event.AdminEventListenerException;
import com.iplanet.ias.admin.event.AdminEventListenerRegistry;
import com.iplanet.ias.admin.event.ModuleDeployEvent;
import com.iplanet.ias.admin.event.ModuleDeployEventListener;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.deployment.backend.DeployableObjectType;
import com.iplanet.ias.deployment.backend.Deployer;
import com.iplanet.ias.deployment.backend.DeployerFactory;
import com.iplanet.ias.deployment.backend.DeploymentCommand;
import com.iplanet.ias.deployment.backend.DeploymentRequest;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.instance.EjbModulesManager;
import com.iplanet.ias.server.AbstractLoader;
import com.iplanet.ias.server.AbstractManager;
import com.iplanet.ias.server.EJBModuleLoader;
import com.iplanet.ias.server.MonitorableEntry;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

class StandAloneEJBModulesManager
extends AbstractManager
implements ModuleDeployEventListener {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static StringManager localStrings = StringManager.getManager(StandAloneEJBModulesManager.class);

    StandAloneEJBModulesManager(EjbModulesManager ejbModulesManager, ClassLoader classLoader) {
        super(classLoader, ejbModulesManager);
        AdminEventListenerRegistry.addModuleDeployEventListener(this);
    }

    protected AbstractLoader getLoader(String string) {
        return new EJBModuleLoader(string, this.parentClassLoader, (EjbModulesManager)this.configManager);
    }

    private void holdRequest() {
    }

    private void holdRequest(String string) {
    }

    public synchronized boolean reload(MonitorableEntry monitorableEntry) {
        boolean bl = false;
        String string = monitorableEntry.getId();
        bl = this.moduleUnDeployed(string, false);
        try {
            DeploymentRequest deploymentRequest = new DeploymentRequest(this.configManager.getInstanceEnvironment(), DeployableObjectType.EJB, DeploymentCommand.DEPLOY);
            deploymentRequest.setFileSource(monitorableEntry.getMonitoredFile().getParentFile());
            deploymentRequest.setName(string);
            deploymentRequest.setForced(true);
            deploymentRequest.iAmNotAnAdminServer();
            Deployer deployer = DeployerFactory.getDeployer(deploymentRequest);
            deployer.doRequest();
            deployer.cleanup();
        }
        catch (IASDeploymentException iASDeploymentException) {
            _logger.log(Level.WARNING, "core.error_in_reload_ejb_module", iASDeploymentException);
            bl = false;
        }
        if (bl) {
            bl = this.moduleDeployed(string, false);
        }
        return bl;
    }

    private boolean moduleDeployed(String string) {
        return this.moduleDeployed(string, true);
    }

    private boolean moduleDeployed(String string, boolean bl) {
        boolean bl2 = false;
        try {
            if (this.configManager.isEnabled(string)) {
                AbstractLoader abstractLoader;
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "Loading enabled ejb module: " + string);
                }
                if ((abstractLoader = this.getLoader(string)).load()) {
                    this.id2loader.put(string, abstractLoader);
                    if (bl) {
                        this.addToReloadMonitor(string);
                    }
                    bl2 = true;
                } else {
                    _logger.log(Level.WARNING, "core.error_while_loading_ejb_module");
                }
            } else {
                _logger.log(Level.INFO, "core.ejb_module_disabled", string);
            }
        }
        catch (ConfigException configException) {
            _logger.log(Level.WARNING, "core.error_while_loading_ejb_module", configException);
            bl2 = false;
        }
        return bl2;
    }

    private boolean moduleUnDeployed(String string) {
        return this.moduleUnDeployed(string, true);
    }

    private boolean moduleUnDeployed(String string, boolean bl) {
        EJBModuleLoader eJBModuleLoader;
        if (bl) {
            this.removeFromReloadMonitor(string);
        }
        if ((eJBModuleLoader = (EJBModuleLoader)this.id2loader.remove(string)) == null) {
            return true;
        }
        Application application = eJBModuleLoader.getApplication();
        RoleMapper.removeRoleMapper(application.getRoleMapper().getName());
        boolean bl2 = eJBModuleLoader.unload();
        if (bl2) {
            _logger.log(Level.INFO, "core.ejb_module_unload_successful", string);
        } else {
            _logger.log(Level.INFO, "core.ejb_module_not_unloaded", string);
        }
        return bl2;
    }

    public synchronized void moduleDeployed(ModuleDeployEvent moduleDeployEvent) throws AdminEventListenerException {
        if (moduleDeployEvent.getModuleTypeCode() == 2) {
            String string = moduleDeployEvent.getModuleName();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "Deploying EJB Module: " + string);
            }
            try {
                this.configManager.refreshConfigContext(moduleDeployEvent.getConfigContext());
                boolean bl = this.moduleDeployed(string);
                if (!bl) {
                    String string2 = localStrings.getString("standaloneejbmodulesmgr.ejbmodule_deployed_failed", string);
                    throw new AdminEventListenerException(string2);
                }
            }
            catch (ConfigException configException) {
                throw new AdminEventListenerException(configException.getMessage());
            }
        }
    }

    public synchronized void moduleUndeployed(ModuleDeployEvent moduleDeployEvent) throws AdminEventListenerException {
        try {
            if (moduleDeployEvent.getModuleTypeCode() == 2) {
                String string = moduleDeployEvent.getModuleName();
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "Undeploying EJB Module: " + string);
                }
                this.configManager.refreshConfigContext(moduleDeployEvent.getOldConfigContext());
                boolean bl = this.moduleUnDeployed(string);
                if (!bl) {
                    String string2 = localStrings.getString("standaloneejbmodulesmgr.ejbmodule_undeployed_failed", string);
                    throw new AdminEventListenerException(string2);
                }
            }
        }
        catch (ConfigException configException) {
            throw new AdminEventListenerException(configException.getMessage());
        }
    }

    public synchronized void moduleRedeployed(ModuleDeployEvent moduleDeployEvent) throws AdminEventListenerException {
        if (moduleDeployEvent.getModuleTypeCode() == 2) {
            String string = moduleDeployEvent.getModuleName();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "Redeploying EJB Module: " + string);
            }
            this.moduleUndeployed(moduleDeployEvent);
            this.moduleDeployed(moduleDeployEvent);
        }
    }

    public synchronized void moduleEnabled(ModuleDeployEvent moduleDeployEvent) throws AdminEventListenerException {
        if (moduleDeployEvent.getModuleTypeCode() == 2) {
            String string = moduleDeployEvent.getModuleName();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "Enabling EJB Module: " + string);
            }
            this.moduleDeployed(moduleDeployEvent);
        }
    }

    public synchronized void moduleDisabled(ModuleDeployEvent moduleDeployEvent) throws AdminEventListenerException {
        if (moduleDeployEvent.getModuleTypeCode() == 2) {
            String string = moduleDeployEvent.getModuleName();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "Disabling EJB Module: " + string);
            }
            this.moduleUndeployed(moduleDeployEvent);
        }
    }
}

