/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server;

import com.iplanet.ias.config.serverbeans.Resources;
import com.iplanet.ias.jms.JmsResourceDeployer;
import com.iplanet.ias.resource.CustomResourceDeployer;
import com.iplanet.ias.resource.ExternalJndiResourceDeployer;
import com.iplanet.ias.resource.JdbcConnectionPoolDeployer;
import com.iplanet.ias.resource.JdbcResourceDeployer;
import com.iplanet.ias.resource.MailResourceDeployer;
import com.iplanet.ias.resource.PersistenceManagerFactoryResourceDeployer;
import com.iplanet.ias.server.ResourceDeployer;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;

class ResourceDeployerFactory {
    private ResourceDeployer jmsResourceDeployer_ = new JmsResourceDeployer();
    private ResourceDeployer jdbcResourceDeployer_ = new JdbcResourceDeployer();
    private ResourceDeployer pmfResourceDeployer_ = new PersistenceManagerFactoryResourceDeployer();
    private ResourceDeployer customResourceDeployer_ = new CustomResourceDeployer();
    private ResourceDeployer externalJndiResourceDeployer_ = new ExternalJndiResourceDeployer();
    private ResourceDeployer mailResourceDeployer_ = new MailResourceDeployer();
    private ResourceDeployer JdbcConnectionPoolDeployer_ = new JdbcConnectionPoolDeployer();
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static StringManager localStrings = StringManager.getManager("com.iplanet.ias.server");

    ResourceDeployerFactory() {
    }

    ResourceDeployer getResourceDeployer(String string) throws Exception {
        ResourceDeployer resourceDeployer = null;
        if (string.equals("jms")) {
            resourceDeployer = this.jmsResourceDeployer_;
        } else if (string.equals("jdbc")) {
            resourceDeployer = this.jdbcResourceDeployer_;
        } else if (string.equals("pmf")) {
            resourceDeployer = this.pmfResourceDeployer_;
        } else if (string.equals("custom")) {
            resourceDeployer = this.customResourceDeployer_;
        } else if (string.equals("external-jndi")) {
            resourceDeployer = this.externalJndiResourceDeployer_;
        } else if (string.equals("mail")) {
            resourceDeployer = this.mailResourceDeployer_;
        } else if (string.equals("jcp")) {
            resourceDeployer = this.JdbcConnectionPoolDeployer_;
        } else {
            String string2 = localStrings.getString("resource.deployment.resource_type_not_implemented", string);
            throw new Exception(string2);
        }
        return resourceDeployer;
    }

    Object getResource(String string, String string2, Resources resources) throws Exception {
        return this.getResourceDeployer(string).getResource(string2, resources);
    }
}

