/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server;

import com.iplanet.ias.admin.audit.ASAuditException;
import com.iplanet.ias.admin.audit.ASAuditService;
import com.iplanet.ias.admin.event.AdminEventListenerRegistry;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.loader.ClassLoaderUtils;
import com.iplanet.ias.server.ResourceManager;
import com.iplanet.ias.server.ServerContext;
import com.iplanet.ias.server.ServerContextImpl;
import com.iplanet.ias.server.logging.ServerLogManager;
import com.sun.appserv.server.ServerLifecycle;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.server.J2EEServer;
import com.sun.enterprise.util.ConnectorClassLoader;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ApplicationServer {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    public static PrintStream ostream = System.out;
    public static PrintStream estream = System.err;
    private static final String USER_TX = "java:comp/UserTransaction";
    private static final String CODEBASE_PROP = "java.rmi.server.codebase";
    static String[][] servicesByName = new String[][]{{"LicenseChecker", "com.iplanet.ias.license.LicenseLifecycle"}, {"JMSProvider", "com.iplanet.ias.jms.JmsProviderLifecycle"}, {"AdminService", "com.iplanet.ias.admin.server.core.AdminServiceLifeCycle"}, {"PersistenceManagerService", "com.iplanet.ias.persistence.internal.ejb.PersistenceManagerServiceImpl"}, {"Application Service", "com.iplanet.ias.server.ApplicationLifecycle"}, {"Servlet/JSP Service", "com.iplanet.ias.web.WebContainerLifecycle"}, {"LifecycleModuleService", "com.sun.appserv.server.LifecycleModuleService"}};
    private static ServerContext context = null;
    private ArrayList services = new ArrayList();
    private ClassLoader commonClassLoader;
    private ClassLoader connectorClassLoader;

    public void onInitialization(ServerContext serverContext) throws ServerLifecycleException {
        Object object;
        Object object2;
        context = serverContext;
        ServerLogManager.reInitializeServerLoggers();
        try {
            object2 = ASAuditService.getAuditSession(ASAuditService.GLOBAL_AUDITSESS);
            object2.setIdentity(null, "localhost", -1);
        }
        catch (ASAuditException aSAuditException) {
            // empty catch block
        }
        this.printStartupInfo();
        object2 = this.getClass().getClassLoader();
        InstanceEnvironment instanceEnvironment = context.getInstanceEnvironment();
        try {
            object = instanceEnvironment.getLibClassesPath();
            String string = instanceEnvironment.getLibPath();
            this.commonClassLoader = ClassLoaderUtils.getClassLoader(new File[]{new File((String)object)}, new File[]{new File(string)}, (ClassLoader)object2);
            if (this.commonClassLoader == null) {
                this.commonClassLoader = object2;
            }
        }
        catch (IOException iOException) {
            _logger.log(Level.WARNING, "server.ioexception", iOException);
            this.commonClassLoader = object2;
        }
        catch (Throwable throwable) {
            _logger.log(Level.WARNING, "server.exception", throwable);
            this.commonClassLoader = object2;
        }
        this.connectorClassLoader = ConnectorClassLoader.getInstance(this.commonClassLoader);
        if (context instanceof ServerContextImpl) {
            object = (ServerContextImpl)context;
            ((ServerContextImpl)object).setCommonClassLoader(this.commonClassLoader);
            ((ServerContextImpl)object).setSharedClassLoader(this.connectorClassLoader);
            ((ServerContextImpl)object).setLifecycleParentClassLoader(this.connectorClassLoader);
        }
        object = this.commonClassLoader;
        AccessController.doPrivileged(new PrivilegedAction((ClassLoader)object){
            private final /* synthetic */ ClassLoader val$commonCL;
            {
                this.val$commonCL = classLoader;
            }

            public Object run() {
                Thread.currentThread().setContextClassLoader(this.val$commonCL);
                return null;
            }
        });
        this.instantiateRuntimeServices();
        for (int i = 0; i < this.services.size(); ++i) {
            Object e = this.services.get(i);
            if (!(e instanceof ServerLifecycle)) continue;
            ((ServerLifecycle)e).onInitialization(serverContext);
        }
        J2EEServer.main(serverContext);
        final ClassLoader classLoader = this.connectorClassLoader;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(classLoader);
                return null;
            }
        });
    }

    private void instantiateRuntimeServices() {
        for (int i = 0; i < servicesByName.length; ++i) {
            try {
                String[] stringArray = servicesByName[i];
                Class<?> clazz = Class.forName(stringArray[1]);
                Object obj = clazz.newInstance();
                this.services.add(obj);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onStartup() throws ServerLifecycleException {
        for (int i = 0; i < this.services.size(); ++i) {
            Object e = this.services.get(i);
            if (!(e instanceof ServerLifecycle)) continue;
            ((ServerLifecycle)e).onStartup(context);
        }
    }

    public void onReady() throws ServerLifecycleException {
        Class<Object> clazz;
        try {
            AdminEventListenerRegistry.addResourceDeployEventListener(new ResourceManager(context));
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread.currentThread().setContextClassLoader(ApplicationServer.this.commonClassLoader);
                    return null;
                }
            });
            String string = null;
            string = System.getProperty("com.iplanet.ias.server.startupHook");
            if (string != null) {
                try {
                    clazz = Class.forName(string);
                    Method method = clazz.getMethod("main", ServerContext.class);
                    method.invoke(null, context);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            throw new ServerLifecycleException(exception);
        }
        for (int i = 0; i < this.services.size(); ++i) {
            clazz = this.services.get(i);
            if (!(clazz instanceof ServerLifecycle)) continue;
            ((ServerLifecycle)((Object)clazz)).onReady(context);
        }
    }

    public void onShutdown() throws ServerLifecycleException {
        for (int i = this.services.size(); i > 0; --i) {
            Object e = this.services.get(i - 1);
            if (e instanceof ServerLifecycle) {
                ((ServerLifecycle)e).onShutdown();
            }
            ASAuditService.removeAuditSession(ASAuditService.GLOBAL_AUDITSESS);
        }
    }

    public void onTermination() throws ServerLifecycleException {
        for (int i = this.services.size(); i > 0; --i) {
            Object e = this.services.get(i - 1);
            if (!(e instanceof ServerLifecycle)) continue;
            ((ServerLifecycle)e).onTermination();
        }
        this.services = null;
    }

    public static ServerContext getServerContext() {
        return context;
    }

    private void printStartupInfo() {
        _logger.log(Level.INFO, "j2eerunner.printstartinfo", new Object[]{System.getProperty("java.vm.name"), System.getProperty("java.version"), System.getProperty("java.vm.vendor")});
    }
}

