/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server;

import com.iplanet.ias.config.ConfigBeansFactory;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.Applications;
import com.iplanet.ias.config.serverbeans.ServerXPathHelper;
import com.iplanet.ias.instance.AppsManager;
import com.iplanet.ias.instance.ConnectorModulesManager;
import com.iplanet.ias.instance.EjbModulesManager;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.InstanceFactory;
import com.iplanet.ias.server.AbstractMonitor;
import com.iplanet.ias.server.ApplicationManager;
import com.iplanet.ias.server.ApplicationRegistry;
import com.iplanet.ias.server.JarManagerImplAdapter;
import com.iplanet.ias.server.ReloadMonitor;
import com.iplanet.ias.server.ServerContext;
import com.iplanet.ias.server.StandAloneConnectorModulesManager;
import com.iplanet.ias.server.StandAloneEJBModulesManager;
import com.sun.appserv.server.ServerLifecycle;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.appserv.server.util.PreprocessorUtil;
import com.sun.ejb.Container;
import com.sun.enterprise.Switch;
import com.sun.logging.LogDomains;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ApplicationLifecycle
implements ServerLifecycle {
    private ServerContext _context = null;
    private ApplicationManager _applicationMgr = null;
    private StandAloneEJBModulesManager _ejbMgr = null;
    private StandAloneConnectorModulesManager _connMgr = null;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");

    public void onInitialization(ServerContext serverContext) throws ServerLifecycleException {
        this._context = serverContext;
        try {
            InstanceEnvironment instanceEnvironment = serverContext.getInstanceEnvironment();
            ClassLoader classLoader = serverContext.getSharedClassLoader();
            AppsManager appsManager = InstanceFactory.createAppsManager(instanceEnvironment, false);
            this._applicationMgr = new ApplicationManager(appsManager, classLoader);
            EjbModulesManager ejbModulesManager = InstanceFactory.createEjbModuleManager(instanceEnvironment, false);
            this._ejbMgr = new StandAloneEJBModulesManager(ejbModulesManager, classLoader);
            ConnectorModulesManager connectorModulesManager = InstanceFactory.createConnectorModuleManager(instanceEnvironment, false);
            this._connMgr = new StandAloneConnectorModulesManager(connectorModulesManager, classLoader);
            try {
                if (appsManager.isByteCodePreprocessingEnabled()) {
                    PreprocessorUtil.init(appsManager.getBytecodeProcessorClassNames());
                }
            }
            catch (ConfigException configException) {
                _logger.log(Level.WARNING, "core.preprocessor_config_ex", configException);
                _logger.log(Level.WARNING, "core.preprocessor_disabled");
            }
        }
        catch (ConfigException configException) {
            _logger.log(Level.SEVERE, "core.config_exception_while_app_loading", configException);
        }
        catch (Throwable throwable) {
            _logger.log(Level.SEVERE, "core.unexpected_error_occured_while_app_loading", throwable);
        }
    }

    public void onStartup(ServerContext serverContext) throws ServerLifecycleException {
        try {
            JarManagerImplAdapter jarManagerImplAdapter = new JarManagerImplAdapter(this._applicationMgr);
            Switch.getSwitch().setEJBJarManager(jarManagerImplAdapter);
            this._connMgr.load();
            this._ejbMgr.load();
            this._applicationMgr.load();
        }
        catch (Throwable throwable) {
            _logger.log(Level.SEVERE, "core.unexpected_error_occured_while_app_loading", throwable);
        }
    }

    public void onReady(ServerContext serverContext) throws ServerLifecycleException {
        Object object;
        Object object2;
        Object object3;
        try {
            object3 = ApplicationRegistry.getInstance();
            object2 = null;
            if (object3 != null) {
                object2 = ((ApplicationRegistry)object3).getAllEjbContainers();
            }
            if (object2 != null) {
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (Container)iterator.next();
                    if (object == null) continue;
                    object.onReady();
                }
            }
            _logger.log(Level.INFO, "core.application_onReady_complete");
        }
        catch (Throwable throwable) {
            _logger.log(Level.SEVERE, "core.unexpected_error_occured_while_app_onready", throwable);
        }
        object3 = serverContext.getConfigContext();
        object2 = null;
        boolean bl = false;
        try {
            object2 = (Applications)ConfigBeansFactory.getConfigBeanByXPath((ConfigContext)object3, ServerXPathHelper.XPATH_APPLICATIONS);
            bl = ((Applications)object2).isDynamicReloadEnabled();
        }
        catch (ConfigException configException) {
            _logger.log(Level.SEVERE, "core.config_exception_while_dynamic_reloading", configException);
            bl = false;
        }
        if (bl) {
            object = ReloadMonitor.getInstance(2000L);
            ((AbstractMonitor)object).start();
        }
    }

    public void onShutdown() throws ServerLifecycleException {
        try {
            _logger.log(Level.INFO, "core.shutting_down_applications");
            this._applicationMgr.shutdown();
            ApplicationRegistry applicationRegistry = ApplicationRegistry.getInstance();
            Collection collection = null;
            if (applicationRegistry != null) {
                collection = applicationRegistry.getAllEjbContainers();
            }
            if (collection != null) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Container container = (Container)iterator.next();
                    if (container == null) continue;
                    container.onShutdown();
                }
            }
            _logger.log(Level.INFO, "core.application_shutdown_complete");
        }
        catch (Throwable throwable) {
            _logger.log(Level.SEVERE, "core.unexpected_error_occured_while_app_shutdown", throwable);
        }
    }

    public void onTermination() throws ServerLifecycleException {
        try {
            ApplicationRegistry applicationRegistry = ApplicationRegistry.getInstance();
            Collection collection = null;
            if (applicationRegistry != null) {
                collection = applicationRegistry.getAllEjbContainers();
            }
            if (collection != null) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Container container = (Container)iterator.next();
                    if (container == null) continue;
                    container.onTermination();
                }
            }
        }
        catch (Throwable throwable) {
            _logger.log(Level.SEVERE, "core.unexpected_error_occured_while_app_terminate", throwable);
        }
    }
}

