/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server;

import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.instance.BaseManager;
import com.iplanet.ias.server.AbstractLoader;
import com.iplanet.ias.server.ApplicationRegistry;
import com.iplanet.ias.server.MonitorListener;
import com.iplanet.ias.server.MonitorableEntry;
import com.iplanet.ias.server.ReloadMonitor;
import com.sun.logging.LogDomains;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class AbstractManager
implements MonitorListener {
    protected ClassLoader parentClassLoader;
    protected ApplicationRegistry registry;
    protected BaseManager configManager;
    protected Hashtable id2loader = new Hashtable();
    protected ReloadMonitor reloadMonitor = null;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");

    AbstractManager(ClassLoader classLoader, BaseManager baseManager) {
        this.parentClassLoader = classLoader;
        this.configManager = baseManager;
        this.registry = ApplicationRegistry.getInstance();
        boolean bl = this.configManager.isDynamicReloadEnabled();
        if (bl) {
            this.reloadMonitor = ReloadMonitor.getInstance(this.configManager.getReloadPollIntervalInMillis());
        }
    }

    void load() {
        final ClassLoader classLoader = this.parentClassLoader;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(classLoader);
                return null;
            }
        });
        List list = null;
        try {
            list = this.configManager.listIds();
        }
        catch (ConfigException configException) {
            _logger.log(Level.WARNING, "core.error_while_getting_deployed_applist", configException);
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            try {
                if (!this.configManager.isEnabled(string)) continue;
                AbstractLoader abstractLoader = this.getLoader(string);
                if (abstractLoader.load()) {
                    this.id2loader.put(string, abstractLoader);
                } else {
                    _logger.log(Level.WARNING, "core.application_not_loaded", string);
                }
                this.addToReloadMonitor(string);
                continue;
            }
            catch (ConfigException configException) {
                _logger.log(Level.WARNING, "core.error_while_loading_app", configException);
                continue;
            }
            catch (Throwable throwable) {
                _logger.log(Level.WARNING, "core.unexpected_error_occured_while_loading_app", throwable);
            }
        }
    }

    void shutdown() {
        try {
            if (this.reloadMonitor != null) {
                this.reloadMonitor.stop();
            }
        }
        catch (Throwable throwable) {
            _logger.log(Level.WARNING, "core.unexpected_error_occured_while_app_shutdown", throwable);
        }
    }

    protected void addToReloadMonitor(String string) throws ConfigException {
        if (this.reloadMonitor != null) {
            String string2 = this.configManager.getLocation(string) + File.separator + ".reload";
            MonitorableEntry monitorableEntry = new MonitorableEntry(string, new File(string2), this);
            this.reloadMonitor.addMonitorableEntry(monitorableEntry);
        }
    }

    protected void removeFromReloadMonitor(String string) {
        if (this.reloadMonitor != null) {
            this.reloadMonitor.removeMonitoredEntry(string);
        }
    }

    public boolean reload(MonitorableEntry monitorableEntry) {
        return false;
    }

    public boolean deploy(MonitorableEntry monitorableEntry, File file) {
        return false;
    }

    protected abstract AbstractLoader getLoader(String var1);

    ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }
}

