/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server;

import com.iplanet.ias.connectors.deployment.IASMCFFactory;
import com.iplanet.ias.instance.BaseManager;
import com.iplanet.ias.loader.EJBClassLoader;
import com.iplanet.ias.security.Audit;
import com.iplanet.ias.server.ApplicationRegistry;
import com.iplanet.ias.util.io.FileUtils;
import com.sun.ejb.Container;
import com.sun.ejb.ContainerFactory;
import com.sun.enterprise.SecurityManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.security.application.EJBSecurityManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NameAlreadyBoundException;

abstract class AbstractLoader {
    protected String id = null;
    ClassLoader parentClassLoader = null;
    ClassLoader ejbClassLoader = null;
    ClassLoader ejbUrlClassLoader = null;
    Application application = null;
    private URL[] classPathURLs = new URL[0];
    protected boolean robFlag = false;
    protected ApplicationRegistry registry = null;
    protected BaseManager configManager = null;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");

    AbstractLoader(String string, ClassLoader classLoader, BaseManager baseManager) {
        this.id = string;
        this.parentClassLoader = classLoader;
        this.registry = ApplicationRegistry.getInstance();
        this.configManager = baseManager;
    }

    protected void initializeLoader(String[] stringArray) {
        this.ejbClassLoader = new EJBClassLoader(this.parentClassLoader);
        if (stringArray != null) {
            int n = stringArray.length;
            this.classPathURLs = new URL[n];
            for (int i = 0; i < n; ++i) {
                try {
                    this.classPathURLs[i] = new File(stringArray[i]).toURL();
                    ((EJBClassLoader)this.ejbClassLoader).appendURL(this.classPathURLs[i]);
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    _logger.log(Level.WARNING, "loader.cannot_convert_classpath_into_url", stringArray[i]);
                    _logger.log(Level.WARNING, "loader.exception", malformedURLException);
                }
            }
        }
        this.ejbUrlClassLoader = new URLClassLoader(this.classPathURLs, this.parentClassLoader);
    }

    abstract boolean load();

    abstract boolean unload();

    ClassLoader getClassLoader() {
        return this.ejbClassLoader;
    }

    Application getApplication() {
        return this.application;
    }

    protected void done() {
        if (this.ejbClassLoader instanceof EJBClassLoader) {
            ((EJBClassLoader)this.ejbClassLoader).done();
        }
        this.id = null;
        this.parentClassLoader = null;
        this.application = null;
        this.ejbClassLoader = null;
        this.ejbUrlClassLoader = null;
        this.classPathURLs = null;
        this.registry = null;
        this.configManager = null;
    }

    protected boolean unloadEjbs() {
        boolean bl = true;
        if (this.application == null) {
            bl = false;
        } else {
            Vector vector = this.application.getEjbDescriptors();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                EjbDescriptor ejbDescriptor = (EjbDescriptor)enumeration.nextElement();
                this.registry.removeUniqueId(ejbDescriptor.getUniqueId());
                try {
                    Container container = this.registry.removeDescriptor2Container(ejbDescriptor);
                    if (container == null) continue;
                    container.undeploy();
                }
                catch (Exception exception) {
                    bl = false;
                    _logger.log(Level.WARNING, "loader.unexpected_error_while_unloading_ejb_container", exception);
                }
            }
            if (!this.application.isVirtual()) {
                this.registry.removeAppId2ClassLoader(this.id);
            } else {
                this.registry.removeModuleId2ClassLoader(this.id);
            }
            this.registry.removeClassLoader2Application(this.ejbClassLoader);
        }
        _logger.log(Level.FINE, "[AbstractLoader] Unload EJB(s) Status: " + bl);
        return bl;
    }

    protected boolean loadEjbs() {
        Object object;
        Object object2;
        final ClassLoader classLoader = this.ejbClassLoader;
        if (this.application == null) {
            return false;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "[AbstractLoader] Id: " + this.id + " Setting thread context class loader to: " + classLoader);
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(classLoader);
                return null;
            }
        });
        if (!this.application.isVirtual()) {
            this.registry.addAppId2ClassLoader(this.id, this.ejbClassLoader);
        } else {
            this.registry.addModuleId2ClassLoader(this.id, this.ejbClassLoader);
        }
        this.registry.addClassLoader2Application(this.ejbClassLoader, this.application);
        HashSet<Container> hashSet = new HashSet<Container>();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "[AbstractLoader] Id: " + this.id + " Unique Id: " + this.application.getUniqueId());
        }
        Vector vector = this.application.getEjbDescriptors();
        Enumeration enumeration = vector.elements();
        ContainerFactory containerFactory = Switch.getSwitch().getContainerFactory();
        while (enumeration.hasMoreElements()) {
            object2 = (EjbDescriptor)enumeration.nextElement();
            if (!this.registry.isUnique(((EjbDescriptor)object2).getUniqueId())) {
                _logger.log(Level.SEVERE, "loader.duplicate_unique_id", new Object[]{String.valueOf(((EjbDescriptor)object2).getUniqueId()), ((Descriptor)object2).getName()});
                this.unloadEjbs();
                return false;
            }
            try {
                object = new EJBSecurityManager(classLoader, (EjbDescriptor)object2);
                Container container = null;
                try {
                    container = containerFactory.createContainer((EjbDescriptor)object2, classLoader, (SecurityManager)object);
                }
                catch (NameAlreadyBoundException nameAlreadyBoundException) {
                    _logger.log(Level.SEVERE, "loader.jndi_name_conflict", new Object[]{this.id, ((EjbAbstractDescriptor)object2).getJndiName(), ((Descriptor)object2).getName()});
                    _logger.log(Level.SEVERE, "loader.naming_exception_in_createcontainer", nameAlreadyBoundException);
                    this.unloadEjbs();
                    return false;
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Created container with uinque id: " + ((EjbDescriptor)object2).getUniqueId());
                }
                this.registry.addDescriptor2Container((EjbDescriptor)object2, container);
                hashSet.add(container);
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "loader.unexpected_error_while_creating_ejb_container", exception);
                this.unloadEjbs();
                return false;
            }
        }
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = (Container)object2.next();
            object.doAfterApplicationDeploy();
        }
        Audit.showACL(this.application);
        if (this.application.getEjbComponentCount() > 0) {
            _logger.log(Level.INFO, "loader.ejbs_loaded", this.id);
        }
        return true;
    }

    protected Set getEJBClasses(Application application, ClassLoader classLoader) throws ClassNotFoundException {
        HashSet<String> hashSet = new HashSet<String>();
        if (application != null && classLoader != null) {
            Enumeration enumeration = application.getEjbDescriptors().elements();
            while (enumeration.hasMoreElements()) {
                EjbDescriptor ejbDescriptor = (EjbDescriptor)enumeration.nextElement();
                String string = ejbDescriptor.getEjbClassName();
                Class<?> clazz = classLoader.loadClass(string);
                do {
                    hashSet.add(clazz.getName());
                } while ((clazz = clazz.getSuperclass()) != null);
            }
        }
        return hashSet;
    }

    protected boolean unloadRars() {
        boolean bl = true;
        try {
            String string = this.configManager.getLocation(this.id);
            Set set = this.application.getRarDescriptors();
            IASMCFFactory iASMCFFactory = IASMCFFactory.getMCFFactory();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ConnectorDescriptor connectorDescriptor = (ConnectorDescriptor)iterator.next();
                String string2 = connectorDescriptor.getDeployName();
                String string3 = string + File.separator + FileUtils.makeFriendlyFilename(string2);
                String string4 = FileUtils.makeFriendlyFilenameNoExtension(string2);
                iASMCFFactory.unloadOneMCF(string3, string4);
            }
        }
        catch (Exception exception) {
            bl = false;
            _logger.log(Level.WARNING, "loader.application_loader_exception", exception);
        }
        _logger.log(Level.FINE, "[AbstractLoader] Unload RAR(s) Status: " + bl);
        return bl;
    }

    protected boolean loadRars() {
        try {
            String string = this.configManager.getLocation(this.id);
            Set set = this.application.getRarDescriptors();
            IASMCFFactory iASMCFFactory = IASMCFFactory.getMCFFactory();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ConnectorDescriptor connectorDescriptor = (ConnectorDescriptor)iterator.next();
                String string2 = connectorDescriptor.getDeployName();
                String string3 = string + File.separator + FileUtils.makeFriendlyFilename(string2);
                String string4 = FileUtils.makeFriendlyFilenameNoExtension(string2);
                iASMCFFactory.loadOneMCF(string3, string4, this.ejbClassLoader);
            }
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "loader.application_loader_exception", exception);
        }
        return true;
    }
}

