/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.security.auth.login;

import com.sun.logging.LogDomains;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

class LdapConnectionPool {
    private Properties _prop = null;
    private HashMap _map = new HashMap();
    private int _maxSize = 1;
    private Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");

    public LdapConnectionPool(Properties properties, int n) {
        this._prop = properties;
        if (n > 0) {
            this._maxSize = n;
        }
    }

    public int getMaxPoolSize() {
        return this._maxSize;
    }

    public synchronized DirContext getLdapCtx() throws NamingException {
        DirContext dirContext = null;
        while ((dirContext = this.tryLdapCtx()) == null) {
            try {
                this._logger.log(Level.FINE, "ldaplm.poolbusy", String.valueOf(this._map.size()));
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new NamingException("cannot get ldap connection");
            }
        }
        return dirContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLdapCtx(DirContext dirContext) {
        if (dirContext != null) {
            LdapConnectionPool ldapConnectionPool = this;
            synchronized (ldapConnectionPool) {
                this._map.put(dirContext, Boolean.TRUE);
                this.notifyAll();
            }
        }
    }

    public synchronized void remove(DirContext dirContext) {
        try {
            dirContext.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._map.remove(dirContext);
    }

    private synchronized DirContext tryLdapCtx() throws NamingException {
        DirContext dirContext = null;
        Iterator iterator = this._map.keySet().iterator();
        while (iterator.hasNext()) {
            DirContext dirContext2 = (DirContext)iterator.next();
            if (!this._map.get(dirContext2).equals(Boolean.TRUE)) continue;
            dirContext = dirContext2;
            break;
        }
        if (dirContext == null && this._map.size() < this._maxSize) {
            dirContext = new InitialDirContext(this._prop);
        }
        if (dirContext != null) {
            this._map.put(dirContext, Boolean.FALSE);
        }
        return dirContext;
    }

    private synchronized void removeAll() {
        Iterator iterator = this._map.keySet().iterator();
        while (iterator.hasNext()) {
            DirContext dirContext = (DirContext)iterator.next();
            try {
                dirContext.close();
            }
            catch (Exception exception) {}
        }
        this._map.clear();
    }
}

