/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.resource.monitor;

import com.iplanet.ias.admin.monitor.BaseMonitorMBean;
import com.iplanet.ias.admin.monitor.MonitoredObjectType;
import com.iplanet.ias.admin.monitor.types.Counter;
import com.iplanet.ias.admin.monitor.types.MonitoredAttributeType;
import com.iplanet.ias.resource.monitor.IASResourcePoolMonitor;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanInfo;
import javax.management.RuntimeOperationsException;

public class JDBCPoolMonitorMBean
extends BaseMonitorMBean {
    private static final StringManager localStrings = StringManager.getManager("com.iplanet.ias.resource");
    public static final String numThreadsWaiting = "total-threads-waiting";
    public static final String numConnFailedValidation = "total-connections-failed-validation";
    public static final String numConnTimedOut = "total-connections-timed-out";
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private static Object[][] attrNameTypeArray = new Object[][]{{"total-threads-waiting", Counter.INTEGER}, {"total-connections-failed-validation", Counter.INTEGER}, {"total-connections-timed-out", Counter.INTEGER}};
    private MonitoredObjectType type = MonitoredObjectType.JDBC_CONN_POOL;
    private boolean monitorOn = false;
    private static Map attrNameTypeMap = JDBCPoolMonitorMBean.createAttrNameTypeMap(attrNameTypeArray);
    private static MBeanInfo mBeanInfo = JDBCPoolMonitorMBean.createMBeanInfo(attrNameTypeMap);
    private IASResourcePoolMonitor poolmonitor;

    public JDBCPoolMonitorMBean(IASResourcePoolMonitor iASResourcePoolMonitor) {
        this.poolmonitor = iASResourcePoolMonitor;
    }

    public Object getAttribute(String string) throws AttributeNotFoundException {
        if (string == null) {
            String string2 = localStrings.getString("resource.no_attrib_name");
            throw new RuntimeOperationsException(new IllegalArgumentException(string2));
        }
        if (string.equals(numThreadsWaiting)) {
            return new Integer(this.poolmonitor.getNumThreadWaiting());
        }
        if (string.equals(numConnFailedValidation)) {
            return new Integer(this.poolmonitor.getNumConnFailedValidation());
        }
        if (string.equals(numConnTimedOut)) {
            return new Integer(this.poolmonitor.getNumConnTimedOut());
        }
        String string3 = localStrings.getString("resource.attrib_not_found", string);
        throw new AttributeNotFoundException(string3);
    }

    public AttributeList getAttributes(String[] stringArray) {
        if (stringArray == null) {
            String string = localStrings.getString("resource.attrib_name_needed");
            throw new RuntimeOperationsException(new IllegalArgumentException(string));
        }
        AttributeList attributeList = new AttributeList();
        if (stringArray.length == 0) {
            return attributeList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Object object = this.getAttribute(stringArray[i]);
                attributeList.add(new Attribute(stringArray[i], object));
                continue;
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "web.error_while_getting_monitor_attr", exception);
            }
        }
        return attributeList;
    }

    public void startMonitoring() {
        this.monitorOn = true;
    }

    public void stopMonitoring() {
        this.monitorOn = false;
    }

    public MBeanInfo getMBeanInfo() {
        return mBeanInfo;
    }

    public Map getMonitoringMetaData() {
        return attrNameTypeMap;
    }

    public MonitoredAttributeType getAttributeType(String string) {
        MonitoredAttributeType monitoredAttributeType = null;
        if (attrNameTypeMap != null && string != null) {
            monitoredAttributeType = (MonitoredAttributeType)attrNameTypeMap.get(string);
        }
        return monitoredAttributeType;
    }

    public MonitoredObjectType getMonitoredObjectType() {
        return this.type;
    }
}

