/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.resource;

import com.iplanet.ias.config.serverbeans.PersistenceManagerFactoryResource;
import com.iplanet.ias.config.serverbeans.Resources;
import com.iplanet.ias.server.ResourceDeployer;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.repository.IASJ2EEResourceFactoryImpl;
import com.sun.enterprise.repository.PMFResource;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PersistenceManagerFactoryResourceDeployer
implements ResourceDeployer {
    private static final StringManager localStrings = StringManager.getManager("com.iplanet.ias.resource");
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");

    public synchronized void deployResource(Object object) throws Exception {
        PersistenceManagerFactoryResource persistenceManagerFactoryResource = (PersistenceManagerFactoryResource)object;
        if (persistenceManagerFactoryResource.isEnabled()) {
            PMFResource pMFResource = (PMFResource)IASJ2EEResourceFactoryImpl.toPMFJ2EEResource(persistenceManagerFactoryResource);
            ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
            resourceInstaller.installPersistenceManagerResource(pMFResource);
            resourceInstaller.addResource(pMFResource);
        } else {
            _logger.log(Level.INFO, "core.resource_disabled", new Object[]{persistenceManagerFactoryResource.getJndiName(), "persistence-manager-factory-resource"});
        }
    }

    public synchronized void undeployResource(Object object) throws Exception {
        NamingManager namingManager = Switch.getSwitch().getNamingManager();
        PersistenceManagerFactoryResource persistenceManagerFactoryResource = (PersistenceManagerFactoryResource)object;
        namingManager.unpublishObject(persistenceManagerFactoryResource.getJndiName());
        ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
        resourceInstaller.removeResource((PMFResource)IASJ2EEResourceFactoryImpl.toPMFJ2EEResource(persistenceManagerFactoryResource));
    }

    public synchronized void redeployResource(Object object) throws Exception {
        this.undeployResource(object);
        this.deployResource(object);
    }

    public synchronized void enableResource(Object object) throws Exception {
        this.deployResource(object);
    }

    public synchronized void disableResource(Object object) throws Exception {
        this.undeployResource(object);
    }

    public Object getResource(String string, Resources resources) throws Exception {
        PersistenceManagerFactoryResource persistenceManagerFactoryResource = resources.getPersistenceManagerFactoryResourceByJndiName(string);
        if (persistenceManagerFactoryResource == null) {
            String string2 = localStrings.getString("resource.no_resource", string);
            throw new Exception(string2);
        }
        return persistenceManagerFactoryResource;
    }
}

