/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.resource;

import com.iplanet.ias.config.serverbeans.MailResource;
import com.iplanet.ias.config.serverbeans.Resources;
import com.iplanet.ias.server.ResourceDeployer;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.repository.IASJ2EEResourceFactoryImpl;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MailResourceDeployer
implements ResourceDeployer {
    private static final StringManager localStrings = StringManager.getManager("com.iplanet.ias.resource");
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");

    public synchronized void deployResource(Object object) throws Exception {
        MailResource mailResource = (MailResource)object;
        if (mailResource.isEnabled()) {
            J2EEResource j2EEResource = IASJ2EEResourceFactoryImpl.toMailJ2EEResource(mailResource);
            ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
            resourceInstaller.installMailResource((com.sun.enterprise.repository.MailResource)j2EEResource);
            resourceInstaller.addResource(j2EEResource);
        } else {
            _logger.log(Level.INFO, "core.resource_disabled", new Object[]{mailResource.getJndiName(), "mail-resource"});
        }
    }

    public synchronized void undeployResource(Object object) throws Exception {
        NamingManager namingManager = Switch.getSwitch().getNamingManager();
        MailResource mailResource = (MailResource)object;
        J2EEResource j2EEResource = IASJ2EEResourceFactoryImpl.toMailJ2EEResource(mailResource);
        namingManager.unpublishObject(j2EEResource.getName());
        ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
        resourceInstaller.removeResource(j2EEResource);
    }

    public synchronized void redeployResource(Object object) throws Exception {
        this.undeployResource(object);
        this.deployResource(object);
    }

    public synchronized void enableResource(Object object) throws Exception {
        this.deployResource(object);
    }

    public synchronized void disableResource(Object object) throws Exception {
        this.undeployResource(object);
    }

    public Object getResource(String string, Resources resources) throws Exception {
        MailResource mailResource = resources.getMailResourceByJndiName(string);
        if (mailResource == null) {
            String string2 = localStrings.getString("resource.no_resource", string);
            throw new Exception(string2);
        }
        return mailResource;
    }
}

