/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.resource;

import com.iplanet.ias.config.serverbeans.Resources;
import com.iplanet.ias.server.ResourceDeployer;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.repository.IASJdbcResource;
import com.sun.enterprise.repository.IASJdbcXAResource;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceBase;
import com.sun.enterprise.repository.JdbcConnectionPool;
import com.sun.enterprise.repository.JdbcResource;
import com.sun.enterprise.repository.JdbcXAResource;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JdbcResourceDeployer
implements ResourceDeployer {
    private static final StringManager localStrings = StringManager.getManager("com.iplanet.ias.resource");
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");

    public synchronized void deployResource(Object object) throws Exception {
        com.iplanet.ias.config.serverbeans.JdbcResource jdbcResource = (com.iplanet.ias.config.serverbeans.JdbcResource)object;
        if (jdbcResource.isEnabled()) {
            J2EEResource j2EEResource = this.toJdbcJ2eeResource(jdbcResource);
            ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
            if (j2EEResource instanceof JdbcXAResource) {
                resourceInstaller.installJdbcXADataSource((JdbcXAResource)j2EEResource);
            } else {
                resourceInstaller.installJdbc10DataSource((JdbcResource)j2EEResource);
            }
            resourceInstaller.addResource(j2EEResource);
        } else {
            _logger.log(Level.INFO, "core.resource_disabled", new Object[]{jdbcResource.getJndiName(), "jdbc-resource"});
        }
    }

    public synchronized void undeployResource(Object object) throws Exception {
        com.iplanet.ias.config.serverbeans.JdbcResource jdbcResource = (com.iplanet.ias.config.serverbeans.JdbcResource)object;
        ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
        resourceInstaller.uninstallJdbcResource(this.toJdbcJ2eeResource(jdbcResource));
    }

    public synchronized void redeployResource(Object object) throws Exception {
        this.undeployResource(object);
        this.deployResource(object);
    }

    public synchronized void enableResource(Object object) throws Exception {
        this.deployResource(object);
    }

    public synchronized void disableResource(Object object) throws Exception {
        this.undeployResource(object);
    }

    public Object getResource(String string, Resources resources) throws Exception {
        com.iplanet.ias.config.serverbeans.JdbcResource jdbcResource = resources.getJdbcResourceByJndiName(string);
        if (jdbcResource == null) {
            String string2 = localStrings.getString("resource.no_resource", string);
            throw new Exception(string2);
        }
        return jdbcResource;
    }

    private J2EEResource toJdbcJ2eeResource(com.iplanet.ias.config.serverbeans.JdbcResource jdbcResource) throws Exception {
        J2EEResourceBase j2EEResourceBase = null;
        ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
        JdbcConnectionPool jdbcConnectionPool = resourceInstaller.lookupJdbcConnectionPool(jdbcResource.getPoolName());
        if (jdbcConnectionPool == null) {
            String string = localStrings.getString("resource.no_pool", jdbcResource.getPoolName());
            throw new Exception(string);
        }
        if (jdbcConnectionPool.isXA()) {
            j2EEResourceBase = new IASJdbcXAResource(jdbcResource.getJndiName());
            ((IASJdbcXAResource)j2EEResourceBase).setJdbcConnectionPool(jdbcConnectionPool);
            ((IASJdbcXAResource)j2EEResourceBase).setEnabled(jdbcResource.isEnabled());
        } else {
            j2EEResourceBase = new IASJdbcResource(jdbcResource.getJndiName());
            ((IASJdbcResource)j2EEResourceBase).setJdbcConnectionPool(jdbcConnectionPool);
            ((IASJdbcResource)j2EEResourceBase).setEnabled(jdbcResource.isEnabled());
        }
        return j2EEResourceBase;
    }
}

