/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.resource;

import com.iplanet.ias.config.serverbeans.CustomResource;
import com.iplanet.ias.config.serverbeans.Resources;
import com.iplanet.ias.server.ResourceDeployer;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.repository.IASJ2EEResourceFactoryImpl;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CustomResourceDeployer
implements ResourceDeployer {
    private static final StringManager localStrings = StringManager.getManager("com.iplanet.ias.resource");
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");

    public synchronized void deployResource(Object object) throws Exception {
        CustomResource customResource = (CustomResource)object;
        if (customResource.isEnabled()) {
            J2EEResource j2EEResource = IASJ2EEResourceFactoryImpl.toCustomJ2EEResource(customResource);
            ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
            resourceInstaller.installCustomResource((com.sun.enterprise.repository.CustomResource)j2EEResource);
            resourceInstaller.addResource(j2EEResource);
        } else {
            _logger.log(Level.INFO, "core.resource_disabled", new Object[]{customResource.getJndiName(), "custom-resource"});
        }
    }

    public synchronized void undeployResource(Object object) throws Exception {
        NamingManager namingManager = Switch.getSwitch().getNamingManager();
        CustomResource customResource = (CustomResource)object;
        J2EEResource j2EEResource = IASJ2EEResourceFactoryImpl.toCustomJ2EEResource(customResource);
        namingManager.unpublishObject(j2EEResource.getName());
        ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
        resourceInstaller.removeResource(j2EEResource);
    }

    public synchronized void redeployResource(Object object) throws Exception {
        this.undeployResource(object);
        this.deployResource(object);
    }

    public synchronized void enableResource(Object object) throws Exception {
        this.deployResource(object);
    }

    public synchronized void disableResource(Object object) throws Exception {
        this.undeployResource(object);
    }

    public Object getResource(String string, Resources resources) throws Exception {
        CustomResource customResource = resources.getCustomResourceByJndiName(string);
        if (customResource == null) {
            String string2 = localStrings.getString("resource.no_resource", string);
            throw new Exception(string2);
        }
        return customResource;
    }
}

