/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.license;

import com.iplanet.ias.license.LicenseBase;
import com.iplanet.ias.license.LicenseException;
import com.iplanet.ias.license.LicenseManager;
import java.io.IOException;

public class LicenseUtil {
    private static final String STARS = "***************************************************";
    private static final String USAGE = "java com.iplanet.ias.license.LicenseUtil\n\t-install IAS_ROOT license_file\n\t-dump  IAS_ROOT\n";

    private LicenseUtil() {
    }

    private static void pr(String string) {
        System.out.println(string);
    }

    private static void head(String string) {
        LicenseUtil.pr(STARS);
        LicenseUtil.pr("***********  " + string);
        LicenseUtil.pr(STARS);
    }

    public static void usage() {
        System.out.println(USAGE);
        System.exit(1);
    }

    private static void dump() throws Exception {
        try {
            LicenseBase licenseBase = LicenseManager.getLicense();
            LicenseUtil.pr(licenseBase.printLicenseString());
        }
        catch (LicenseException licenseException) {
            System.out.println(licenseException.getMessage());
        }
    }

    private static void install(String string) throws IOException, Exception {
        try {
            LicenseManager.upgradeLicenseKey(string);
            LicenseUtil.pr("License has been installed successfully!");
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            LicenseUtil.usage();
        }
        String string = stringArray[1];
        System.setProperty("com.sun.aas.installRoot", string);
        if (stringArray[0].equals("-dump")) {
            LicenseUtil.dump();
        } else if (stringArray.length == 3 && stringArray[0].equals("-install")) {
            LicenseUtil.install(stringArray[2]);
        } else {
            LicenseUtil.usage();
        }
    }
}

