/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.license;

import com.iplanet.ias.license.FileLicense;
import com.iplanet.ias.license.LicenseBase;
import com.iplanet.ias.license.LicenseException;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Properties;

public class LicenseManager {
    private static StringManager sm = StringManager.getManager(LicenseManager.class);
    private static LicenseBase currentLicense = null;
    private static LicenseManager manager = null;
    private static final String PE_KEY = "7348950986-5346271508";
    private static final String SE_KEY = "2378124054-1735946538";
    private static final String DEV_KEY = "2284910653-4386095633";
    private static final String EVAL_KEY = "5971754263-2547835531";
    private static final String EE_KEY = "3459714045-8923072315";
    private static final String SE71_KEY = "0459876237-6385421735";
    private static final String EVAL71_KEY = "6317545971-7530839563";
    private static final String EE71_KEY = "9659734005-8520272953";
    private static final String[] iasParams = new String[]{"allow_upgrade", "description", "date_string", "ias.license_type", "ias.file_version", "ias.license_version", "ias.precedence", "ias.num_instances", "ias.allow_remote_admin"};
    private static final String[] PEValue = new String[]{"1", "Sun ONE Application Server 7 Platform Edition production license", "NONE", "PE", "1", "3", "3000", "1", "0"};
    private static final String[] SEValue = new String[]{"1", "Sun ONE Application Server 7 Standard Edition production license", "NONE", "SE", "1", "3", "4000", "-1", "1"};
    private static final String[] EEValue = new String[]{"1", "Sun ONE Application Server 7 Enterprise Edition production license", "NONE", "EE", "1", "3", "5000", "-1", "1"};
    private static final String[] DevValue = new String[]{"1", "Sun ONE Application Server 7 Developer license", "NONE", "DEV", "1", "3", "2000", "-1", "1"};
    private static final String[] EvalValue = new String[]{"1", "Sun ONE Application Server 7 Evaluation license", "TRY[60]", "Eval", "1", "3", "1000", "-1", "1"};
    private static final String[] Eval71Value = new String[]{"1", "Sun Java System Application Server Standard Edition 7 2004Q2 evaluation license", "TRY[60]", "Eval", "1", "4", "1000", "-1", "1"};
    private static final String[] EE71Value = new String[]{"1", "Sun Java System Application Server Enterprise Edition 7 2004Q2 production license", "NONE", "EE", "1", "4", "5000", "-1", "1"};
    private static final String[] SE71Value = new String[]{"1", "Sun Java System Application Server Standard Edition 7 2004Q2 production license", "NONE", "SE", "1", "4", "4000", "-1", "1"};
    private static final String LICENSE_BASE_PKG_PREFIX = "com.iplanet.ias.license.";
    private static final String STANDALONE_LICENSE_BASE = "StandaloneLicense";
    private static final String LICENSE_BASE_CLASS_PREFIX = "L";
    private static final int MAX_LICENSE_BASE_CLASSES = 100;
    private static final String LICENSE_FILE_SUBDIR = "";
    private boolean allow_multiple_files = false;
    private static FilenameFilter licFilter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return string.startsWith("appserv") && string.endsWith(".lic");
        }
    };

    private LicenseManager() {
    }

    public static LicenseBase getLicense() throws IOException, LicenseException {
        if (manager == null) {
            manager = new LicenseManager();
        }
        if (currentLicense != null) {
            return currentLicense;
        }
        String string = LicenseManager.getLicenseHome();
        LicenseBase licenseBase = manager.getLicenseBase();
        FileLicense fileLicense = manager.loadLicenseFile(string);
        if (fileLicense != null) {
            try {
                fileLicense.rewriteLicense();
            }
            catch (IOException iOException) {
                throw new LicenseException(iOException.getMessage());
            }
        }
        if (fileLicense != null) {
            licenseBase.superimpose(fileLicense.getProperties());
        } else if (licenseBase.isLicenseFileRequired()) {
            throw new LicenseException(sm.getString("license.e_no_valid_license"));
        }
        currentLicense = licenseBase;
        return licenseBase;
    }

    public static void upgradeLicenseKey(String string) throws IOException, LicenseException {
        if (string == null) {
            throw new LicenseException(sm.getString("license.e_bad_key"));
        }
        if (!(string.equals(PE_KEY) || string.equals(SE_KEY) || string.equals(DEV_KEY) || string.equals(EE_KEY) || string.equals(EE71_KEY) || string.equals(SE71_KEY) || string.equals(EVAL71_KEY))) {
            throw new LicenseException(sm.getString("license.e_bad_key"));
        }
        LicenseManager.installLicense(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installLicense(String string) throws IOException, LicenseException {
        File file = null;
        try {
            String string2 = LicenseManager.getLicenseHome();
            try {
                File file2 = new File(string2);
                file = new File(file2, "appserv.lic.new");
                LicenseManager.generateLicense(file, string);
            }
            catch (Exception exception) {
                throw new LicenseException(sm.getString("license.e_no_permission"));
            }
            LicenseManager.upgradeLicense(file.getAbsolutePath());
            currentLicense = null;
            currentLicense = manager.getLicense();
        }
        finally {
            file.delete();
        }
    }

    private static void generateLicense(File file, String string) throws IOException, LicenseException {
        Properties properties = new Properties();
        LicenseManager.readASProperties(properties, string);
        FileLicense fileLicense = new FileLicense();
        fileLicense.setAutoChecking(false);
        fileLicense.superimpose(properties);
        fileLicense.writeLicense(file);
    }

    private static void readASProperties(Properties properties, String string) throws LicenseException {
        for (int i = 0; i < iasParams.length; ++i) {
            String string2 = iasParams[i];
            String string3 = null;
            if (string.equals(PE_KEY)) {
                string3 = PEValue[i];
            } else if (string.equals(SE_KEY)) {
                string3 = SEValue[i];
            } else if (string.equals(EE_KEY)) {
                string3 = EEValue[i];
            } else if (string.equals(DEV_KEY)) {
                string3 = DevValue[i];
            } else if (string.equals(EVAL_KEY)) {
                string3 = EvalValue[i];
            } else if (string.equals(EVAL71_KEY)) {
                string3 = Eval71Value[i];
            } else if (string.equals(EE71_KEY)) {
                string3 = EE71Value[i];
            } else if (string.equals(SE71_KEY)) {
                string3 = SE71Value[i];
            } else if (string == null || string.length() == 0) {
                string3 = Eval71Value[i];
            } else {
                throw new LicenseException(sm.getString("license.e_bad_key"));
            }
            properties.setProperty(string2, string3);
        }
    }

    public static void upgradeLicense(String string) throws IOException, LicenseException {
        Object object;
        boolean bl = true;
        try {
            object = LicenseManager.getLicense();
            bl = ((LicenseBase)object).allowUpgrade();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            object = LicenseManager.getLicenseHome();
            FileOutputStream fileOutputStream = null;
            FileInputStream fileInputStream = null;
            File file = null;
            File file2 = null;
            try {
                file2 = new File(string);
                fileInputStream = new FileInputStream(file2);
            }
            catch (Exception exception) {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                throw new LicenseException(sm.getString("license.e_no_license", string));
            }
            try {
                File file3 = new File((String)object);
                file = new File(file3, "appserv.lic");
                fileOutputStream = new FileOutputStream(file);
                FileUtils.copy(fileInputStream, fileOutputStream);
            }
            catch (Exception exception) {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                throw new LicenseException(sm.getString("license.e_no_permission"));
            }
        }
        throw new LicenseException(sm.getString("license.e_can_not_upgrade"));
    }

    private LicenseBase getLicenseBase() throws LicenseException {
        Class<?> clazz = null;
        String string = "com.iplanet.ias.license.StandaloneLicense";
        try {
            clazz = Class.forName(string);
            return this.newInstance(clazz);
        }
        catch (Exception exception) {
            ArrayList<LicenseBase> arrayList = new ArrayList<LicenseBase>();
            for (int i = 0; i < 100; ++i) {
                string = "com.iplanet.ias.license.L" + i;
                try {
                    clazz = Class.forName(string);
                    arrayList.add(this.newInstance(clazz));
                    continue;
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
            }
            LicenseBase[] licenseBaseArray = arrayList.toArray(new LicenseBase[0]);
            return this.selectBestLicense(licenseBaseArray);
        }
    }

    private LicenseBase newInstance(Class clazz) throws Exception {
        Constructor constructor = clazz.getConstructor(null);
        return (LicenseBase)constructor.newInstance(null);
    }

    private LicenseBase selectBestLicense(LicenseBase[] licenseBaseArray) throws LicenseException {
        if (licenseBaseArray == null || licenseBaseArray.length == 0) {
            throw new LicenseException(sm.getString("license.e_no_valid_license"));
        }
        LicenseBase licenseBase = licenseBaseArray[0];
        for (int i = 1; i < licenseBaseArray.length; ++i) {
            if (licenseBase.getPrecedence() >= licenseBaseArray[i].getPrecedence()) continue;
            licenseBase = licenseBaseArray[i];
        }
        return licenseBase;
    }

    private FileLicense loadLicenseFile(String string) throws LicenseException {
        File file = new File(string);
        if (this.allow_multiple_files) {
            try {
                LicenseBase[] licenseBaseArray = LicenseManager.loadFileLicenses(string);
                FileLicense fileLicense = (FileLicense)this.selectBestLicense(licenseBaseArray);
                return fileLicense;
            }
            catch (Exception exception) {
                throw new LicenseException(exception);
            }
        }
        if (LICENSE_FILE_SUBDIR.length() > 0) {
            file = new File(file, LICENSE_FILE_SUBDIR);
        }
        if (!(file = new File(file, "appserv.lic")).exists() || file.isDirectory()) {
            throw new LicenseException(sm.getString("license.e_no_license", file.getPath()));
        }
        try {
            FileLicense fileLicense = new FileLicense(file);
            return fileLicense;
        }
        catch (Exception exception) {
            throw new LicenseException(exception.getMessage());
        }
    }

    public static LicenseBase[] loadFileLicenses(String string) {
        File file = new File(string);
        if (LICENSE_FILE_SUBDIR.length() > 0) {
            file = new File(file, LICENSE_FILE_SUBDIR);
        }
        String[] stringArray = file.list(licFilter);
        ArrayList<FileLicense> arrayList = new ArrayList<FileLicense>();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                File file2 = new File(file, stringArray[i]);
                FileLicense fileLicense = new FileLicense(file2);
                arrayList.add(fileLicense);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList.toArray(new FileLicense[0]);
    }

    private static String getLicenseHome() throws IOException, LicenseException {
        String string = System.getProperty("com.sun.aas.configRoot");
        if (string == null) {
            throw new LicenseException(sm.getString("license.e_no_config"));
        }
        return string.trim();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray != null && stringArray.length > 0) {
            String string = stringArray[0];
            if (string.equals(EVAL_KEY)) {
                LicenseManager.installLicense(string);
            } else {
                LicenseManager.upgradeLicenseKey(string);
            }
        } else {
            LicenseBase licenseBase = LicenseManager.getLicense();
        }
    }
}

