/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.license;

import com.iplanet.ias.license.LicenseException;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.i18n.StringManager;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

public class LicenseBase {
    private static StringManager sm = StringManager.getManager(LicenseBase.class);
    protected Properties props = new Properties();
    private boolean autoChecking = true;
    private int daysToTry = 0;
    private Date expirationDate = null;
    private Date startDate = null;
    protected static final long LICENSE_MAGIC_NUMBER = 1011902605893L;
    protected static final String LICENSE_FILE_NAME = "appserv.lic";
    protected static final String LICENSE_FILE_NAME_NEW = "appserv.lic.new";
    protected static final String LICENSE_FILE_SUBFIX = ".lic";
    protected static final String LICENSE_FILE_PREFIX = "appserv";
    private static final String CURRENT_FILE_VERSION = "7";
    private static final String CURRENT_LICENSE_VERSION = "Beta";
    public static final String PROP_FILE_VERSION = "ias.file_version";
    public static final String PROP_LICENSE_VERSION = "ias.license_version";
    public static final String PROP_LICENSE_TYPE = "ias.license_type";
    public static final String PROP_PRECEDENCE = "ias.precedence";
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_ALLOW_UPGRADE = "allow_upgrade";
    public static final String PROP_DATE_STRING = "date_string";
    protected static final String NONE_STRING = "NONE";
    protected static final String TRY_STRING = "TRY";
    protected static final String VALID_STRING = "VALID";
    protected static final String OPEN_BRACKET = "[";
    protected static final String CLOSE_BRACKET = "]";
    protected static final String DASH = "-";
    protected static final int UNLIMITED_INSTANCE = -1;
    protected static final int MAX_LICENSE_LEN = 2048;
    protected static final long DAYTOMILLISECOND = 86400000L;
    public static final String PROP_MULTIPLE_INSTANCE = "ias.num_instances";
    public static final String PROP_REMOTE_ADMIN = "ias.allow_remote_admin";
    private static final String licenseDateTitle = "Expiration date";
    private static final String instanceLimitTitle = "Number of instances per admin server";
    private static final String allowRemoteAdminTitle = "Allow remote administration";
    private static int longestTitle = -1;
    public static final String LICENSE_TYPE_DEV = "Dev";
    public static final String LICENSE_TYPE_PE = "PE";
    public static final String LICENSE_TYPE_SE = "SE";
    public static final String LICENSE_TYPE_EVAL = "Eval";
    private static final String STARS = "**********************************************************************\n";

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    public int getIntProperty(String string, int n) {
        try {
            return Integer.parseInt(this.getProperty(string));
        }
        catch (Exception exception) {
            return n;
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    public int getPrecedence() {
        int n = 0;
        try {
            n = Integer.parseInt(this.props.getProperty(PROP_PRECEDENCE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public int getInstanceLimit() {
        int n = 0;
        try {
            n = Integer.parseInt(this.props.getProperty(PROP_MULTIPLE_INSTANCE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public boolean allowRemoteAdmin() {
        boolean bl = true;
        try {
            int n = Integer.parseInt(this.props.getProperty(PROP_REMOTE_ADMIN));
            bl = n != 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean allowUpgrade() {
        boolean bl = true;
        try {
            int n = Integer.parseInt(this.props.getProperty(PROP_ALLOW_UPGRADE));
            bl = n != 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean willExpire() {
        String string = this.props.getProperty(PROP_DATE_STRING);
        return string == null || !string.equals(NONE_STRING);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date date) {
        this.startDate = date;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date date) {
        this.expirationDate = date;
    }

    public int getDaysToTry() {
        return this.daysToTry;
    }

    public void setDaysToTry(int n) {
        this.daysToTry = n;
    }

    public boolean isLicenseFileRequired() {
        return true;
    }

    public int checkValidity() throws LicenseException {
        int n = 0;
        n = this.checkDate();
        return n;
    }

    public void setAutoChecking(boolean bl) {
        this.autoChecking = bl;
    }

    public void superimpose(Properties properties) throws LicenseException {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            this.props.setProperty(string, string2);
        }
        this.processLicenseInfo();
    }

    private void processLicenseInfo() throws LicenseException {
        if (!this.autoChecking) {
            return;
        }
        String string = this.props.getProperty(PROP_FILE_VERSION);
        String string2 = this.props.getProperty(PROP_LICENSE_VERSION);
        this.parseDateString();
    }

    private void parseDateString() throws LicenseException {
        String string = this.props.getProperty(PROP_DATE_STRING);
        if (string == null) {
            throw new LicenseException(sm.getString("license.e_bad_license_data"));
        }
        if (!string.startsWith(NONE_STRING)) {
            if (string.startsWith(TRY_STRING)) {
                int n = string.indexOf(OPEN_BRACKET);
                int n2 = string.indexOf(CLOSE_BRACKET);
                int n3 = Integer.parseInt(string.substring(n + 1, n2));
                this.setDaysToTry(n3);
            } else if (string.startsWith(VALID_STRING)) {
                long l;
                int n = string.indexOf(OPEN_BRACKET);
                int n4 = string.indexOf(DASH);
                int n5 = string.indexOf(CLOSE_BRACKET);
                if (n4 - n > 1) {
                    l = Long.parseLong(string.substring(n + 1, n4));
                    this.setStartDate(new Date(l));
                }
                if (n5 - n4 > 1) {
                    l = Long.parseLong(string.substring(n4 + 1, n5));
                    this.setExpirationDate(new Date(l));
                }
            } else {
                throw new LicenseException(sm.getString("license.e_bad_license_data"));
            }
        }
    }

    private int checkDate() throws LicenseException {
        Calendar calendar;
        int n = 0;
        if (!this.willExpire()) {
            return Integer.MAX_VALUE;
        }
        if (this.getExpirationDate() != null) {
            calendar = Calendar.getInstance();
            calendar.setTime(this.getExpirationDate());
            long l = calendar.getTime().getTime();
            long l2 = new Date().getTime();
            if (l <= l2) {
                throw new LicenseException(sm.getString("license.e_license_expired"));
            }
            n = (int)((l - l2) / 86400000L) + 1;
        }
        if (this.getStartDate() != null) {
            calendar = Calendar.getInstance();
            calendar.setTime(this.getStartDate());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            if (new Date().getTime() < calendar.getTime().getTime()) {
                throw new LicenseException(sm.getString("license.e_license_not_valid_yet"));
            }
        }
        return n;
    }

    public String toString() {
        return "Contents of License:\n" + StringUtils.toString((Properties)this.props);
    }

    public String printLicenseString() {
        String string = null;
        String string2 = this.props.getProperty(PROP_LICENSE_TYPE);
        String string3 = this.props.getProperty(PROP_DESCRIPTION);
        boolean bl = this.allowUpgrade();
        int n = this.getInstanceLimit();
        String string4 = null;
        String string5 = null;
        string4 = n == -1 ? "Unlimited" : Integer.toString(n);
        Date date = this.getExpirationDate();
        string5 = date == null ? "Unlimited" : date.toString();
        String string6 = this.pad(string2) + string3 + "\n";
        String string7 = this.pad(licenseDateTitle) + string5 + "\n";
        String string8 = this.pad(instanceLimitTitle) + string4 + "\n";
        String string9 = this.allowRemoteAdmin() ? "Yes" : "No";
        String string10 = this.pad(allowRemoteAdminTitle) + string9 + "\n";
        string = STARS + string6 + string7 + string8 + string10 + STARS;
        return string;
    }

    private String pad(String string) {
        if (longestTitle < 0) {
            longestTitle = instanceLimitTitle.length() + 2;
        }
        return StringUtils.padRight((String)string, (int)longestTitle);
    }
}

