/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.license;

import com.iplanet.ias.license.IASLicenseException;
import com.iplanet.ias.license.LicenseBase;
import com.iplanet.ias.license.LicenseException;
import com.iplanet.ias.license.LicenseManager;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.net.NetUtils;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IASLicense {
    private static StringManager sm;
    static Logger _logger;
    private static String installRoot;
    private static LicenseBase licenseBase;
    private static boolean allowRemote;
    private static int instanceLimit;
    private static boolean isCurrentLicense;
    private static String errorMessage;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void checkAllowRemoteAdmin(String string) throws IASLicenseException {
        IASLicense.checkCurrent(false);
        if (allowRemote) {
            return;
        }
        if (NetUtils.isLocal(string)) {
            return;
        }
        throw new IASLicenseException(sm.getString("license.no_remote_admin"));
    }

    public static void checkAllowRemoteAdmin() throws IASLicenseException {
        IASLicense.checkCurrent(false);
        if (allowRemote) {
            return;
        }
        throw new IASLicenseException(sm.getString("license.no_remote_admin"));
    }

    public static void checkCanCreateInstance(int n) throws IASLicenseException {
        IASLicense.checkCurrent(false);
        if (instanceLimit < 0) {
            return;
        }
        if (n >= instanceLimit) {
            throw new IASLicenseException(sm.getString("license.no_more_instances"));
        }
    }

    public static int getInstanceLimit() throws IASLicenseException {
        IASLicense.checkCurrent(false);
        return instanceLimit;
    }

    public static void checkCurrent(boolean bl) throws IASLicenseException {
        try {
            if (bl) {
                LicenseBase licenseBase = IASLicense.getLicenseBase();
                licenseBase.checkValidity();
            }
        }
        catch (LicenseException licenseException) {
            throw new IASLicenseException(sm.getString("license.e_license_expired"));
        }
        if (!isCurrentLicense) {
            throw new IASLicenseException(sm.getString("license.e_license_expired"));
        }
    }

    public static LicenseBase getLicenseBase() {
        return licenseBase;
    }

    private IASLicense() {
    }

    public static void reinit() {
        IASLicense.init();
    }

    private static void init() {
        IASLicense.setInstallRoot();
        IASLicense.setLicenseBase();
        if (licenseBase != null) {
            IASLicense.setIsCurrent();
            if (!isCurrentLicense) {
                return;
            }
            IASLicense.setRemotePermission();
            IASLicense.setInstanceLimit();
        }
    }

    private static void setInstallRoot() {
        installRoot = System.getProperty("com.sun.aas.installRoot");
    }

    private static void setLicenseBase() {
        licenseBase = null;
        if (installRoot == null) {
            return;
        }
        try {
            licenseBase = LicenseManager.getLicense();
        }
        catch (LicenseException licenseException) {
            _logger.log(Level.WARNING, "core.error_while_loading_license", licenseException);
            licenseBase = null;
        }
        catch (Throwable throwable) {
            _logger.log(Level.WARNING, "core.unexpected_exception_no_valid_licfile", throwable);
            licenseBase = null;
        }
    }

    private static void setIsCurrent() {
        if (!$assertionsDisabled && licenseBase == null) {
            throw new AssertionError();
        }
        try {
            licenseBase.checkValidity();
            isCurrentLicense = true;
        }
        catch (Throwable throwable) {
            isCurrentLicense = false;
        }
    }

    private static void setRemotePermission() {
        if (!$assertionsDisabled && licenseBase == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !isCurrentLicense) {
            throw new AssertionError();
        }
        try {
            allowRemote = licenseBase.allowRemoteAdmin();
        }
        catch (Throwable throwable) {
            _logger.log(Level.WARNING, "core.unexpected_exception_while_setting_remote_permission", throwable);
            allowRemote = false;
        }
    }

    private static void setInstanceLimit() {
        if (!$assertionsDisabled && licenseBase == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !isCurrentLicense) {
            throw new AssertionError();
        }
        try {
            instanceLimit = licenseBase.getInstanceLimit();
        }
        catch (Throwable throwable) {
            _logger.log(Level.WARNING, "core.unexpected_exception_while_setting_instance_limit", throwable);
            instanceLimit = 0;
        }
    }

    static {
        $assertionsDisabled = !IASLicense.class.desiredAssertionStatus();
        sm = StringManager.getManager(IASLicense.class);
        _logger = LogDomains.getLogger("javax.enterprise.system.core");
        installRoot = null;
        licenseBase = null;
        allowRemote = false;
        instanceLimit = 0;
        isCurrentLicense = false;
        errorMessage = null;
        IASLicense.init();
    }
}

