/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.license;

import com.iplanet.ias.license.LicenseBase;
import com.iplanet.ias.license.LicenseException;
import com.iplanet.ias.util.i18n.StringManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Properties;

public class FileLicense
extends LicenseBase {
    private static StringManager sm;
    private File myLicenseFile = null;
    private static final int CHECKSUM_LEN = 16;
    private static final int BLOW_FACTOR = 3;
    private static final int FAKE_FACTOR = 2;
    private static final int CUT_FACTOR = 2;
    private static MessageDigest digest;
    private static int ROTORSZ;
    private static int MASK;
    private static int[] t1;
    private static int[] t2;
    private static int[] t3;

    public FileLicense() {
    }

    public FileLicense(File file, boolean bl) throws LicenseException {
        this.myLicenseFile = file;
        this.setAutoChecking(bl);
        this.readLicense();
    }

    public FileLicense(File file) throws LicenseException {
        this(file, true);
    }

    public void writeLicense(File file) throws IOException, LicenseException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            if (file.exists() && !file.canWrite()) {
                throw new LicenseException(sm.getString("license.e_license_file_not_writable"));
            }
            throw iOException;
        }
        DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
        digest.reset();
        byte[] byArray = this.getEncryptedData();
        byte[] byArray2 = digest.digest(byArray);
        dataOutputStream.writeLong(1011902605893L);
        dataOutputStream.write(byArray2, 0, byArray2.length);
        dataOutputStream.writeInt(byArray.length * 3);
        int n = byArray.length / 2;
        dataOutputStream.write(byArray, 0, n);
        dataOutputStream.write(byArray, 0, byArray.length);
        dataOutputStream.write(byArray, 0, byArray.length);
        dataOutputStream.write(byArray, n, byArray.length - n);
        dataOutputStream.flush();
        dataOutputStream.close();
        fileOutputStream.close();
    }

    private byte[] getEncryptedData() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.props.store(byteArrayOutputStream, null);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return FileLicense.scramble(byArray);
    }

    public void rewriteLicense() throws IOException, LicenseException {
        String string = this.props.getProperty("date_string");
        if (string == null) {
            return;
        }
        if (string.startsWith("TRY")) {
            Calendar calendar = Calendar.getInstance();
            this.setStartDate(calendar.getTime());
            calendar.add(5, this.getDaysToTry());
            this.setExpirationDate(calendar.getTime());
            string = this.generateDateString();
            this.props.setProperty("date_string", string);
            this.writeLicense(this.myLicenseFile);
        }
    }

    private String generateDateString() {
        String string;
        if (!this.willExpire()) {
            string = "NONE";
        } else if (this.getStartDate() != null || this.getExpirationDate() != null) {
            String string2 = this.getStartDate() != null ? String.valueOf(this.getStartDate().getTime()) : "";
            String string3 = this.getExpirationDate() != null ? String.valueOf(this.getExpirationDate().getTime()) : "";
            string = this.formatString("VALID", string2 + "-" + string3);
        } else {
            string = this.formatString("TRY", String.valueOf(this.getDaysToTry()));
        }
        return string;
    }

    private String formatString(String string, String string2) {
        return string + "[" + string2 + "]";
    }

    private void readLicense() throws LicenseException {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.myLicenseFile);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            long l = dataInputStream.readLong();
            if (l != 1011902605893L) {
                throw new LicenseException(sm.getString("license.e_bad_license_data"));
            }
            byte[] byArray = new byte[16];
            dataInputStream.readFully(byArray);
            int n = dataInputStream.readInt();
            int n2 = n / 3;
            int n3 = n2 / 2;
            byte[] byArray2 = new byte[n2];
            dataInputStream.read(byArray2, 0, n3);
            dataInputStream.skipBytes(n2 * 2);
            dataInputStream.read(byArray2, n3, n2 - n3);
            dataInputStream.close();
            fileInputStream.close();
            digest.reset();
            byte[] byArray3 = digest.digest(byArray2);
            if (!this.goodChecksum(byArray, byArray3)) {
                throw new LicenseException(sm.getString("license.e_bad_license_data"));
            }
            this.parseData(FileLicense.scramble(byArray2));
        }
        catch (IOException iOException) {
            throw new LicenseException(sm.getString("license.e_bad_license_data_arg"));
        }
    }

    private boolean goodChecksum(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private void parseData(byte[] byArray) throws IOException, LicenseException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Properties properties = new Properties();
        properties.load(byteArrayInputStream);
        this.superimpose(properties);
    }

    private static byte[] scramble(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = (byte)(t2[t3[t1[byArray[i] + n & MASK] + n2 & MASK] - n2 & MASK] - n);
            if (++n != ROTORSZ) continue;
            n = 0;
            if (++n2 != ROTORSZ) continue;
            n2 = 0;
        }
        return byArray2;
    }

    static {
        int n;
        sm = StringManager.getManager(FileLicense.class);
        ROTORSZ = 256;
        MASK = 255;
        t1 = new int[ROTORSZ];
        t2 = new int[ROTORSZ];
        t3 = new int[ROTORSZ];
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(sm.getString("license.runtime_exception", noSuchAlgorithmException.getMessage()));
        }
        int n2 = 12345;
        for (n = 0; n < ROTORSZ; ++n) {
            FileLicense.t1[n] = n;
            FileLicense.t3[n] = 0;
        }
        for (n = 0; n < ROTORSZ; ++n) {
            int n3 = 5 * n2 % 65521;
            int n4 = ROTORSZ - 1 - n;
            int n5 = (n3 & MASK) % (n4 + 1);
            n3 >>= 8;
            int n6 = t1[n4];
            FileLicense.t1[n4] = t1[n5];
            FileLicense.t1[n5] = n6;
            if (t3[n4] != 0) continue;
            n5 = (n3 & MASK) % n4;
            while (t3[n5] != 0) {
                n5 = (n5 + 1) % n4;
            }
            FileLicense.t3[n4] = n5;
            FileLicense.t3[n5] = n4;
        }
        for (n = 0; n < ROTORSZ; ++n) {
            FileLicense.t2[FileLicense.t1[n] & FileLicense.MASK] = n;
        }
    }
}

